// -*- C++ -*-
/*!
 * @file  SampleRangeDataIn.cpp * @brief InPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "SampleRangeDataIn.h"

// Module specification
// <rtc-template block="module_spec">
static const char* samplerangedatain_spec[] =
  {
    "implementation_id", "SampleRangeDataIn",
    "type_name",         "SampleRangeDataIn",
    "description",       "InPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

SampleRangeDataIn::SampleRangeDataIn(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_rangedataIn("rangedata", m_rangedata)

    // </rtc-template>
{
}

SampleRangeDataIn::~SampleRangeDataIn()
{
}


RTC::ReturnCode_t SampleRangeDataIn::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  addInPort("rangedata", m_rangedataIn);

  // Set OutPort buffer

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t SampleRangeDataIn::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleRangeDataIn::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleRangeDataIn::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleRangeDataIn::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleRangeDataIn::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t SampleRangeDataIn::onExecute(RTC::UniqueId ec_id)
{
  int i,maxsize;

  // RangeData
  if( m_rangedataIn.isNew() )
  {
    m_rangedataIn.read();
    std::cout << "RangeData read" << std::endl;
    maxsize = m_rangedata.ranges.length();
    std::cout << "RangeList:" << std::endl;
    for(i = 0; i < maxsize; i++)
    {
      std::cout << i << ":" << m_rangedata.ranges[i] << std::endl;
    }
    std::cout << "RangerGeometry:" << std::endl;
    std::cout << "  Geometry3D:" << std::endl;
    std::cout << "    Pose3D:" << std::endl;
    std::cout << "      Point3D:" << std::endl;
    std::cout << "        x:" << m_rangedata.geometry.geometry.pose.position.x << std::endl;
    std::cout << "        y:" << m_rangedata.geometry.geometry.pose.position.y << std::endl;
    std::cout << "        z:" << m_rangedata.geometry.geometry.pose.position.z << std::endl;
    std::cout << "      Orientation3D:" << std::endl;
    std::cout << "        r:" << m_rangedata.geometry.geometry.pose.orientation.r << std::endl;
    std::cout << "        p:" << m_rangedata.geometry.geometry.pose.orientation.p << std::endl;
    std::cout << "        y:" << m_rangedata.geometry.geometry.pose.orientation.y << std::endl;
    std::cout << "    Size3D:" << std::endl;
    std::cout << "        l:" << m_rangedata.geometry.geometry.size.l << std::endl;
    std::cout << "        w:" << m_rangedata.geometry.geometry.size.w << std::endl;
    std::cout << "        h:" << m_rangedata.geometry.geometry.size.h << std::endl;
    maxsize = m_rangedata.geometry.elementGeometries.length();
    std::cout << "  ElementGeometryList:" << std::endl;
    for(i = 0; i < maxsize; i++)
    {
      std::cout << "    " << i << std::endl;
      std::cout << "      Pose3D:" << std::endl;
      std::cout << "        Point3D:" << std::endl;
      std::cout << "          x:" << m_rangedata.geometry.elementGeometries[i].pose.position.x << std::endl;
      std::cout << "          y:" << m_rangedata.geometry.elementGeometries[i].pose.position.y << std::endl;
      std::cout << "          z:" << m_rangedata.geometry.elementGeometries[i].pose.position.z << std::endl;
      std::cout << "        Orientation3D:" << std::endl;
      std::cout << "          r:" << m_rangedata.geometry.elementGeometries[i].pose.orientation.r << std::endl;
      std::cout << "          p:" << m_rangedata.geometry.elementGeometries[i].pose.orientation.p << std::endl;
      std::cout << "          y:" << m_rangedata.geometry.elementGeometries[i].pose.orientation.y << std::endl;
      std::cout << "      Size3D:" << std::endl;
      std::cout << "          l:" << m_rangedata.geometry.elementGeometries[i].size.l << std::endl;
      std::cout << "          w:" << m_rangedata.geometry.elementGeometries[i].size.w << std::endl;
      std::cout << "          h:" << m_rangedata.geometry.elementGeometries[i].size.h << std::endl;
    }
    std::cout << "RangerConfig:" << std::endl;
    std::cout << "  minAngle:" << m_rangedata.config.minAngle << std::endl;
    std::cout << "  maxAngle:" << m_rangedata.config.maxAngle << std::endl;
    std::cout << "  angularRes:" << m_rangedata.config.angularRes << std::endl;
    std::cout << "  minRange:" << m_rangedata.config.minRange << std::endl;
    std::cout << "  maxRange:" << m_rangedata.config.maxRange << std::endl;
    std::cout << "  rangeRes:" << m_rangedata.config.rangeRes << std::endl;
    std::cout << "  frequency:" << m_rangedata.config.frequency << std::endl;
 
  }
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t SampleRangeDataIn::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleRangeDataIn::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleRangeDataIn::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleRangeDataIn::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleRangeDataIn::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void SampleRangeDataInInit(RTC::Manager* manager)
  {
    coil::Properties profile(samplerangedatain_spec);
    manager->registerFactory(profile,
                             RTC::Create<SampleRangeDataIn>,
                             RTC::Delete<SampleRangeDataIn>);
  }
  
};



