// -*- C++ -*-
/*!
 * @file  RangerGeometryIn.cpp * @brief InPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "RangerGeometryIn.h"

// Module specification
// <rtc-template block="module_spec">
static const char* rangergeometryin_spec[] =
  {
    "implementation_id", "RangerGeometryIn",
    "type_name",         "RangerGeometryIn",
    "description",       "InPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

RangerGeometryIn::RangerGeometryIn(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_RGdataIn("RGdata", m_RGdata)

    // </rtc-template>
{
}

RangerGeometryIn::~RangerGeometryIn()
{
}


RTC::ReturnCode_t RangerGeometryIn::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  addInPort("RGdata", m_RGdataIn);

  // Set OutPort buffer

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t RangerGeometryIn::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerGeometryIn::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerGeometryIn::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerGeometryIn::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerGeometryIn::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t RangerGeometryIn::onExecute(RTC::UniqueId ec_id)
{
  int i, maxsize;

  if( m_RGdataIn.isNew() )
  {
    m_RGdataIn.read();

    std::cout << "RangerGeometry read" << std::endl;
    std::cout << "  Geometry3D:" << std::endl;
    std::cout << "    Pose3D:" << std::endl;
    std::cout << "      Point3D:" << std::endl;
    std::cout << "        x:" << m_RGdata.geometry.pose.position.x << std::endl;
    std::cout << "        y:" << m_RGdata.geometry.pose.position.y << std::endl;
    std::cout << "        z:" << m_RGdata.geometry.pose.position.z << std::endl;
    std::cout << "      Orientation3D:" << std::endl;
    std::cout << "        r:" << m_RGdata.geometry.pose.orientation.r << std::endl;
    std::cout << "        p:" << m_RGdata.geometry.pose.orientation.p << std::endl;
    std::cout << "        y:" << m_RGdata.geometry.pose.orientation.y << std::endl;
    std::cout << "    Size3D:" << std::endl;
    std::cout << "        l:" << m_RGdata.geometry.size.l << std::endl;
    std::cout << "        w:" << m_RGdata.geometry.size.w << std::endl;
    std::cout << "        h:" << m_RGdata.geometry.size.h << std::endl;
    maxsize = m_RGdata.elementGeometries.length();
    std::cout << "  ElementGeometryList:" << std::endl;
    for(i = 0; i < maxsize; i++)
    {
      std::cout << "    " << i << std::endl;
      std::cout << "      Pose3D:" << std::endl;
      std::cout << "        Point3D:" << std::endl;
      std::cout << "          x:" << m_RGdata.elementGeometries[i].pose.position.x << std::endl;
      std::cout << "          y:" << m_RGdata.elementGeometries[i].pose.position.y << std::endl;
      std::cout << "          z:" << m_RGdata.elementGeometries[i].pose.position.z << std::endl;
      std::cout << "        Orientation3D:" << std::endl;
      std::cout << "          r:" << m_RGdata.elementGeometries[i].pose.orientation.r << std::endl;
      std::cout << "          p:" << m_RGdata.elementGeometries[i].pose.orientation.p << std::endl;
      std::cout << "          y:" << m_RGdata.elementGeometries[i].pose.orientation.y << std::endl;
      std::cout << "      Size3D:" << std::endl;
      std::cout << "          l:" << m_RGdata.elementGeometries[i].size.l << std::endl;
      std::cout << "          w:" << m_RGdata.elementGeometries[i].size.w << std::endl;
      std::cout << "          h:" << m_RGdata.elementGeometries[i].size.h << std::endl;
    }

  }
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t RangerGeometryIn::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerGeometryIn::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerGeometryIn::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerGeometryIn::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerGeometryIn::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void RangerGeometryInInit(RTC::Manager* manager)
  {
    coil::Properties profile(rangergeometryin_spec);
    manager->registerFactory(profile,
                             RTC::Create<RangerGeometryIn>,
                             RTC::Delete<RangerGeometryIn>);
  }
  
};



