// -*- C++ -*-
/*!
 * @file  InPortCorbaCdrConsumer.h
 * @brief InPortCorbaCdrConsumer class
 * @date  $Date: 2007-12-31 03:08:03 $
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2006
 *     Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id: InPortCorbaCdrConsumer.h 1255 2009-04-07 01:09:47Z kurihara $
 *
 */

#include <rtm/NVUtil.h>
#include <rtm/InPortCorbaCdrConsumer.h>

namespace RTC
{
  /*!
   * @if jp
   * @brief 󥹥ȥ饯
   * @else
   * @brief Constructor
   * @param buffer The buffer object that is attached to this Consumer
   * @endif
   */
  InPortCorbaCdrConsumer::InPortCorbaCdrConsumer(void)
    : rtclog("InPortCorbaCdrConsumer")
  {
  }
  
  /*!
   * @if jp
   * @brief ǥȥ饯
   * @else
   * @brief Destructor
   * @endif
   */
  InPortCorbaCdrConsumer::~InPortCorbaCdrConsumer(void)
  {
    RTC_PARANOID(("~InPortCorbaCdrConsumer()"));
  }

  /*!
   * @if jp
   * @brief 
   * @else
   * @brief Initializing configuration
   * @endif
   */
  void InPortCorbaCdrConsumer::init(coil::Properties& prop)
  {
    m_properties = prop;
  }

  /*!
   * @if jp
   * @brief ХåեؤΥǡ
   * @else
   * @brief Write data into the buffer
   * @endif
   */
  InPortConsumer::ReturnCode InPortCorbaCdrConsumer::
  put(const cdrMemoryStream& data)
  {
    RTC_PARANOID(("put()"));

#ifndef ORB_IS_RTORB
    ::OpenRTM::CdrData tmp(data.bufSize(), data.bufSize(),
                           static_cast<CORBA::Octet*>(data.bufPtr()), 0);
    try
      {
        // return code conversion
        // (IDL)OpenRTM::DataPort::ReturnCode_t -> DataPortStatus
        return convertReturnCode(_ptr()->put(tmp));
      }
    catch (...)
      {
        return CONNECTION_LOST;
      }
#else
    OpenRTM_CdrData *cdrdata_tmp = new OpenRTM_CdrData();
    cdrdata_tmp->_buffer = (CORBA_octet *)RtORB_alloc(data.bufSize(), "put(InPortCorbaCdrComsumer");
    memcpy(cdrdata_tmp->_buffer, data.bufPtr(), data.bufSize());
    cdrdata_tmp->_length=cdrdata_tmp->_maximum= data.bufSize();
    ::OpenRTM::CdrData tmp(cdrdata_tmp);
    try
      {
        return convertReturnCode(_ptr()->put(tmp));
      }
    catch (...)
      {
        return CONNECTION_LOST;
      }

#endif
    return UNKNOWN_ERROR;
  }
  
  /*!
   * @if jp
   * @brief InterfaceProfile
   * @else
   * @brief Publish InterfaceProfile information
   * @endif
   */
  void InPortCorbaCdrConsumer::
  publishInterfaceProfile(SDOPackage::NVList& properties)
  {
    return;
  }

  /*!
   * @if jp
   * @brief ǡΤؤϿ
   * @else
   * @brief Subscribe to the data sending notification
   * @endif
   */
  bool InPortCorbaCdrConsumer::
  subscribeInterface(const SDOPackage::NVList& properties)
  {
    RTC_TRACE(("subscribeInterface()"));
    RTC_DEBUG_STR((NVUtil::toString(properties)));
    
    // getting InPort's ref from IOR string
    if (subscribeFromIor(properties)) { return true; }
    
    // getting InPort's ref from Object reference
    if (subscribeFromRef(properties)) { return true; }
    
    return false;;
  }
  
  /*!
   * @if jp
   * @brief ǡΤϿ
   * @else
   * @brief Unsubscribe the data send notification
   * @endif
   */
  void InPortCorbaCdrConsumer::
  unsubscribeInterface(const SDOPackage::NVList& properties)
  {
    RTC_TRACE(("unsubscribeInterface()"));
    RTC_DEBUG_STR((NVUtil::toString(properties)));
    
    if (unsubscribeFromIor(properties)) { return; }
    unsubscribeFromRef(properties);
  }
  
  //----------------------------------------------------------------------
  // private functions

  /*!
   * @if jp
   * @brief IORʸ󤫤饪֥ȻȤ
   * @else
   * @brief Getting object reference fromn IOR string
   * @endif
   */
  bool InPortCorbaCdrConsumer::
  subscribeFromIor(const SDOPackage::NVList& properties)
  {
    RTC_TRACE(("subscribeFromIor()"));
    
    CORBA::Long index;
    index = NVUtil::find_index(properties,
                               "dataport.corba_cdr.inport_ior");
    if (index < 0)
      {
        RTC_ERROR(("inport_ior not found"));
        return false;
      }
    
    const char* ior(0);
    if (!(properties[index].value >>= ior))
      {
        RTC_ERROR(("inport_ior has no string"));
        return false;
      }
    
    CORBA::ORB_ptr orb = RTC::Manager::instance().getORB();
    CORBA::Object_var obj = orb->string_to_object(ior);
    
    if (CORBA::is_nil(obj))
      {
        RTC_ERROR(("invalid IOR string has been passed"));
        return false;
      }
    
    if (!setObject(obj.in()))
      {
        RTC_WARN(("Setting object to consumer failed."));
        return false;
      }
    return true;
  }
  
  /*!
   * @if jp
   * @brief Anyľܥ֥ȻȤ
   * @else
   * @brief Getting object reference fromn Any directry
   * @endif
   */
  bool InPortCorbaCdrConsumer::
  subscribeFromRef(const SDOPackage::NVList& properties)
  {
    RTC_TRACE(("subscribeFromRef()"));
    CORBA::Long index;
    index = NVUtil::find_index(properties,
                               "dataport.corba_cdr.inport_ref");
    if (index < 0)
      {
        RTC_ERROR(("inport_ref not found"));
        return false;
      }
    
    CORBA::Object_var obj;
    if (!(properties[index].value >>= CORBA::Any::to_object(obj.out())))
      {
        RTC_ERROR(("prop[inport_ref] is not objref"));
        return true;
      }

    if (CORBA::is_nil(obj))
      {
        RTC_ERROR(("prop[inport_ref] is not objref"));
        return false;
      }
    
    if (!setObject(obj.in()))
      {
        RTC_ERROR(("Setting object to consumer failed."));
        return false;
      }
    return true;
  }
  
  /*!
   * @if jp
   * @brief ³(IOR)
   * @else
   * @brief ubsubscribing (IOR version)
   * @endif
   */
  bool InPortCorbaCdrConsumer::
  unsubscribeFromIor(const SDOPackage::NVList& properties)
  {
    RTC_TRACE(("unsubscribeFromIor()"));
    CORBA::Long index;
    index = NVUtil::find_index(properties,
                               "dataport.corba_cdr.inport_ior");
    if (index < 0)
      {
        RTC_ERROR(("inport_ior not found"));
        return false;
      }
    
    const char* ior;
    if (!(properties[index].value >>= ior))
      {
        RTC_ERROR(("prop[inport_ior] is not string"));
        return false;
      }
    
    CORBA::ORB_ptr orb = RTC::Manager::instance().getORB();
    CORBA::Object_var var = orb->string_to_object(ior);

    if (!(_ptr()->_is_equivalent(var)))
      {
        RTC_ERROR(("connector property inconsistency"));
        return false;
      }
    
    releaseObject();
    return true;
  }
  
  /*!
   * @if jp
   * @brief ³(Object reference)
   * @else
   * @brief ubsubscribing (Object reference version)
   * @endif
   */
  bool InPortCorbaCdrConsumer::
  unsubscribeFromRef(const SDOPackage::NVList& properties)
  {
    RTC_TRACE(("unsubscribeFromRef()"));
    CORBA::Long index;
    index = NVUtil::find_index(properties,
                               "dataport.corba_cdr.inport_ref");
    if (index < 0) { return false; }
    
    CORBA::Object_var obj;
    if (!(properties[index].value >>= CORBA::Any::to_object(obj.out()))) 
      {
        return false;
      }

    if (!(_ptr()->_is_equivalent(obj.in()))) { return false; }
    
    releaseObject();
    return true;
  }

  /*!
   * @if jp
   * @brief ꥿󥳡Ѵ
   * @else
   * @brief Return codes conversion
   * @endif
   */
  InPortConsumer::ReturnCode
  InPortCorbaCdrConsumer::convertReturnCode(OpenRTM::PortStatus ret)
  {
    switch (ret)
      {
      case OpenRTM::PORT_OK:
        return InPortConsumer::PORT_OK;
        break;
      case OpenRTM::PORT_ERROR:
        return InPortConsumer::PORT_ERROR;
        break;
      case OpenRTM::BUFFER_FULL:
        return InPortConsumer::SEND_FULL;
        break;
      case OpenRTM::BUFFER_TIMEOUT:
        return InPortConsumer::SEND_TIMEOUT;
        break;
      case OpenRTM::UNKNOWN_ERROR:
        return InPortConsumer::UNKNOWN_ERROR;
        break;
      default:
        return InPortConsumer::UNKNOWN_ERROR;
        break;
      }
    return InPortConsumer::UNKNOWN_ERROR;
  }
  
};     // namespace RTC

extern "C"
{
  void InPortCorbaCdrConsumerInit(void)
  {
    RTC::InPortConsumerFactory& factory(RTC::InPortConsumerFactory::instance());
    factory.addFactory("corba_cdr",
                       ::coil::Creator< ::RTC::InPortConsumer,
                                        ::RTC::InPortCorbaCdrConsumer>,
                       ::coil::Destructor< ::RTC::InPortConsumer,
                                           ::RTC::InPortCorbaCdrConsumer>);
  }
};
