// -*- C++ -*-
/*!
 * @file ManagerServant.h
 * @brief RTComponent manager servant implementation class
 * @date $Date: 2007-12-31 03:08:04 $
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2008-2010
 *     Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

#ifndef RTM_MANAGERSERVANT_H
#define RTM_MANAGERSERVANT_H

#include <iostream>
#include <coil/Mutex.h>
#include <coil/Guard.h>
#include <rtm/idl/ManagerSkel.h>
#include <rtm/Manager.h>
#include <rtm/SystemLogger.h>

/*!
 * @if jp
 * @namespace RTM
 *
 * @brief RTCޥ͡
 *
 *
 * @else
 * @namespace RTM
 *
 * @brief RTCManager
 *
 *
 * @endif
 */
namespace RTM
{
  /*!
   * @if jp
   * @brief ManagerCORBA饹
   *
   * ManagerCORBAХȲ饳ݡͥȤ
   * ƥ֤μʤɤԤ롣
   *
   * @else
   * @brief Manager CORBA class
   *
   * This class changes Manager to CORBA Servant.
   * Generation/deletion of the component, to get the state of the system, 
   * etc. can be done from the outside. 
   *
   * @endif
   */
  class ManagerServant
    : public virtual POA_RTM::Manager,
      public virtual PortableServer::RefCountServantBase
  {
  public:
    /*!
     * @if jp
     * @brief 󥹥ȥ饯
     *
     * 󥹥ȥ饯
     *
     * @else
     * @brief Constructor
     *
     * Constructor
     *
     * @endif
     */
    // standard constructor
    ManagerServant();

    /*!
     * @if jp
     *
     * @brief ۥǥȥ饯
     * 
     * @else
     * 
     * @brief Virtual destructor
     * 
     * @endif
     */
    virtual ~ManagerServant(void);

    /*!
     * @if jp
     * @brief ⥸塼ɤ
     *
     * ޥ͡˻ꤵ줿⥸塼ɤꤵ줿
     * ؿǽԤ
     *
     * @param pathname ⥸塼ؤΥѥ
     * @param initfunc ⥸塼νؿ
     * @return ꥿󥳡
     *
    // standard constructor
     * @else
     * @brief Loading a module
     *
     * This operation loads a specified loadable moduleand perform
     * initialization with the specified function.
     *
     * @param pathname A path to a loading module.
     * @param initfunc Module initialization function.
     * @return The return code.
     *
     * @endif
     */
    RTC::ReturnCode_t load_module(const char* pathname, const char* initfunc);

    /*!
     * @if jp
     * @brief ⥸塼򥢥ɤ
     *
     * ޥ͡˻ꤵ줿⥸塼򥢥ɤ롣
     *
     * @param pathname ⥸塼ؤΥѥ
     * @return ꥿󥳡
     *
     * @else
     * @brief Unloading a module
     *
     * This operation unloads a specified loadable module.
     *
     * @param pathname A path to a loading module.
     * @return The return code.
     *
     * @endif
     */
    RTC::ReturnCode_t unload_module(const char* pathname);

    /*!
     * @if jp
     * @brief ɲǽʥ⥸塼Υץե
     *
     * ɲǽʥ⥸塼Υץե롣
     *
     * @return ⥸塼ץե
     *
     * @else
     * @brief Getting loadable module profiles
     *
     * This operation returns loadable module profiles.
     *
     * @return A module profile list.
     *
     * @endif
     */
    RTM::ModuleProfileList* get_loadable_modules();

    /*!
     * @if jp
     * @brief ɺѤߤΥ⥸塼Υץե
     *
     * ɺѤߤΥ⥸塼Υץե롣
     *
     * @return ⥸塼ץե
     *
     * @else
     * @brief Getting loaded module profiles
     *
     * This operation returns loaded module profiles.
     *
     * @return A module profile list.
     *
     * @endif
     */
    RTM::ModuleProfileList* get_loaded_modules();

    // component Ϣ
    /*!
     * @if jp
     * @brief ݡͥȥեȥΥץե
     *
     * ɺѤߤΥ⥸塼ΤRTݡͥȤΥ⥸塼뤬
     * եȥΥץեΥꥹȤ롣
     *
     * @return ݡͥȥեȥΥץեꥹ
     *
     * @else
     * @brief Getting component factory profiles
     *
     * This operation returns component factory profiles from loaded
     * RT-Component module factory profiles.
     *
     * @return An RT-Component factory profile list.
     *
     * @endif
     */
    RTM::ModuleProfileList* get_factory_profiles();

    /*!
     * @if jp
     * @brief ݡͥȤ
     *
     * ˻ꤵ줿ݡͥȤ롣
     *
     * @return 줿RTݡͥ
     *
     * @else
     * @brief Creating an RT-Component
     *
     * This operation creates RT-Component according to the string
     * argument.
     *
     * @return A created RT-Component
     *
     * @endif
     */
    RTC::RTObject_ptr create_component(const char* module_name);

    /*!
     * @if jp
     * @brief ݡͥȤ
     *
     * ˻ꤵ줿ݡͥȤ롣
     *
     * @return ꥿󥳡
     *
     * @else
     * @brief Deleting an RT-Component
     *
     * This operation delete an RT-Component according to the string
     * argument.
     *
     * @return Return code
     *
     * @endif
     */
    RTC::ReturnCode_t delete_component(const char* instance_name);

    /*!
     * @if jp
     * @brief ưΥݡͥȤΥꥹȤ
     *
     * ޥ͡ǵưΥݡͥȤΥꥹȤ֤
     *
     * @return RTݡͥȤΥꥹ
     *
     * @else
     * @brief Getting RT-Component list running on this manager
     *
     * This operation returns RT-Component list running on this manager.
     *
     * @return A list of RT-Components
     *
     * @endif
     */
    RTC::RTCList* get_components();

    /*!
     * @if jp
     * @brief ưΥݡͥȥץեΥꥹȤ
     *
     * ޥ͡ǵưΥݡͥȤΥץեΥꥹ
     * Ȥ֤
     *
     * @return RTݡͥȥץեΥꥹ
     *
     * @else
     * @brief Getting RT-Component's profile list running on this manager
     *
     * This operation returns RT-Component's profile list running on
     * this manager.
     *
     * @return A list of RT-Components' profiles
     *
     * @endif
     */
    RTC::ComponentProfileList* get_component_profiles();

    // manager 
    /*!
     * @if jp
     * @brief ޥ͡Υץե
     *
     * ޥ͡Υץե롣
     *
     * @return ޥ͡ץե
     *
     * @else
     * @brief Getting this manager's profile.
     *
     * This operation returns this manager's profile.
     *
     * @return Manager's profile
     *
     * @endif
     */
    RTM::ManagerProfile* get_profile();

    /*!
     * @if jp
     * @brief ޥ͡Υե졼
     *
     * ޥ͡Υե졼롣
     *
     * @return ޥ͡㥳ե졼
     *
     * @else
     * @brief Getting this manager's configuration.
     *
     * This operation returns this manager's configuration.
     *
     * @return Manager's configuration
     *
     * @endif
     */
    RTM::NVList* get_configuration();

    /*!
     * @if jp
     * @brief ޥ͡Υե졼ꤹ
     *
     * ޥ͡Υե졼ꤹ롣
     *
     * @param name åȤ륳ե졼Υ̾
     * @param value åȤ륳ե졼
     * @return ꥿󥳡
     *
     * @else
     * @brief Setting manager's configuration
     *
     * This operation sets managers configuration.
     *  
     * @param name A configuration key name to be set
     * @param value A configuration value to be set
     * @return Return code
     *
     * @endif
     */
    RTC::ReturnCode_t set_configuration(const char* name, const char* value);

    /*!
     * @if jp
     * @brief ޥ͡㤬ޥɤ
     *
     * δؿϥޥ͡㤬ޥɤ֤TrueʤС
     * ͡ϥޥǤꡢʳ False ֤
     *
     * @return ޥޥ͡㤫ɤbool
     *
     * @else
     * @brief Whether this manager is master or not
     *
     * It returns "True" if this manager is a master, and it returns
     * "False" in other cases.
     *  
     * @return A boolean value that means it is master or not.
     *
     * @endif
     */
#ifdef ORB_IS_RTORB
    CORBA::Boolean is_master();
#else
    bool is_master();
#endif

    /*!
     * @if jp
     * @brief ޥޥ͡μ
     *
     * Υޥ͡㤬졼֥ޥ͡ξ硢ޥȤʤäƤ
     * ͡ΥꥹȤ֤Υޥ͡㤬ޥξ硢Υꥹ
     * Ȥ֤롣
     *
     * @return ޥޥ͡Υꥹ
     *
     * @else
     * @brief Getting master managers
     *
     * This operation returns master manager list if this manager is
     * slave. If this manager is master, an empty sequence would be
     * returned.
     *  
     * @return Master manager list
     *
     * @endif
     */
    RTM::ManagerList* get_master_managers();

    /*!
     * @if jp
     * @brief ޥޥ͡ɲ
     *
     * Υޥ͡ΥޥȤƥޥ͡ɲä롣ͤˤϡ
     * ޥ͡ɲä줿ޥޥ̤͡ˡ
     * ID֤롣Υޥ͡㤬ޥξ硢IDǻꤵ줿
     * ޥޥ֤͡IDǻꤵ줿ޥޥ͡㤬ʤ
     * 硢nil֥Ȥ֤롣
     *
     * @return ޥޥ͡
     *
     * @else
     * @brief Getting a master manager
     *
     * This operation returns a master manager with specified id. If
     * the manager with the specified id does not exist, nil object
     * reference would be returned.
     *  
     * @return A master manager
     *
     * @endif
     */
    RTC::ReturnCode_t add_master_manager(RTM::Manager_ptr mgr);

    /*!
     * @if jp
     * @brief ޥޥ͡κ
     *
     * Υޥ͡㤬ݻޥΤꤵ줿Τ롣
     *
     * @param mgr ޥޥ͡
     * @return ReturnCode_t
     *
     * @else
     * @brief Removing a master manager
     *
     * This operation removes a master manager from this manager.
     * 
     * @param mgr A master manager
     * @return ReturnCode_t 
     *
     * @endif
     */
    RTC::ReturnCode_t remove_master_manager(RTM::Manager_ptr mgr);

    /*!
     * @if jp
     * @brief 졼֥ޥ͡μ
     *
     * Υޥ͡㤬졼֥ޥ͡ξ硢졼֤ȤʤäƤ
     * ͡ΥꥹȤ֤Υޥ͡㤬졼֤ξ硢Υꥹ
     * Ȥ֤롣
     *
     * @return 졼֥ޥ͡Υꥹ
     *
     * @else
     * @brief Getting slave managers
     *
     * This operation returns slave manager list if this manager is
     * slave. If this manager is slave, an empty sequence would be
     * returned.
     *  
     * @return Slave manager list
     *
     * @endif
     */
    RTM::ManagerList* get_slave_managers();

    /*!
     * @if jp
     * @brief 졼֥ޥ͡ɲ
     *
     * Υޥ͡ΥޥȤƥޥ͡ɲä롣
     *
     * @param mgr 졼֥ޥ͡
     * @return ReturnCode_t
     *
     * @else
     * @brief Getting a slave manager
     *
     * This operation add a slave manager to this manager.
     *  
     * @param mgr A slave manager
     * @return ReturnCode_t
     *
     * @endif
     */
    RTC::ReturnCode_t add_slave_manager(RTM::Manager_ptr mgr);

    /*!
     * @if jp
     * @brief 졼֥ޥ͡κ
     *
     * Υޥ͡㤬ݻޥΤꤵ줿Τ롣
     *
     * @param mgr 졼֥ޥ͡
     * @return ReturnCode_t
     *
     * @else
     * @brief Removing a slave manager
     *
     * This operation removes a slave manager from this manager.
     * 
     * @param mgr A slave manager
     * @return ReturnCode_t 
     *
     * @endif
     */
    RTC::ReturnCode_t remove_slave_manager(RTM::Manager_ptr mgr);



    /*!
     * @if jp
     * @brief ץΥԡ
     * @return ReturnCode_t
     * @else
     * @brief The copy of the process is generated. 
     * @return ReturnCode_t 
     * @endif
     */
    RTC::ReturnCode_t fork();
    /*!
     * @if jp
     * @brief shutdown
     * @return ReturnCode_t
     * @else
     * @brief This method shutdowns RTC. 
     * @return ReturnCode_t 
     * @endif
     */
    RTC::ReturnCode_t shutdown();
    /*!
     * @if jp
     * @brief Ƶư롣
     * @return ReturnCode_t
     * @else
     * @brief This method restarts RTC.  
     * @return ReturnCode_t 
     * @endif
     */
    RTC::ReturnCode_t restart();

    /*!
     * @if jp
     * @brief RTCΥե󥹤롣
     * @return RTCΥե
     * @else
     * @brief Get the reference of RTC. 
     * @return RTC reference
     * @endif
     */
    CORBA::Object_ptr get_service(const char* name);

    /*!
     * @if jp
     * @brief ManagerΥե󥹤롣
     * @return ManagerΥե
     * @else
     * @brief Get the reference of Manager. 
     * @return Manager reference
     * @endif
     */
    RTM::Manager_ptr getObjRef() const;

    /*!
     * @if jp
     * @brief INSManager
     * @return 
     * @else :true, :false
     * @brief Generate INSManager. 
     * @return Successful:true, Failed:false
     * @endif
     */
    bool createINSManager();

    /*!
     * @if jp
     * @brief ManagerΥե󥹤򸡺롣
     * @return ManagerΥե
     * @else
     * @brief Find the reference of Manager. 
     * @return Manager reference
     * @endif
     */
    RTM::Manager_ptr findManager(const char* host_port);
  private:
    typedef coil::Guard<coil::Mutex> Guard;
    ::RTC::Logger rtclog;
    ::RTC::Manager& m_mgr;
    ::RTM::Manager_var m_objref;

    ::RTM::ManagerList m_masters;
    ::coil::Mutex m_masterMutex;
    ::RTM::ManagerList m_slaves;
    ::coil::Mutex m_slaveMutex;

    CORBA::Boolean m_isMaster;

    class is_equiv
    {
      RTM::Manager_var m_mgr;
    public:
      is_equiv(RTM::Manager_ptr mgr)
        : m_mgr(RTM::Manager::_duplicate(mgr)) {}
      bool operator()(RTM::Manager_ptr mgr)
      {
        return m_mgr->_is_equivalent(mgr);
      }
    };

  };
}; // namespace RTM
#endif // RTM_MANAGERSERVANT_H
