/**
 * @file nes_posix_mutex.h
 * @brief mutex function interface define
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _NES_POSIX_MUTEX_H_
#define _NES_POSIX_MUTEX_H_

#include <basic.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Mutexes (not abstract because of PTHREAD_MUTEX_INITIALIZER).  */
/* (The layout is unnatural to maintain binary compatibility
with earlier releases of LinuxThreads.) */
typedef struct {
	int __m_count;                 /* Depth of recursive locking */
	int __m_owner;		     /* Owner thread (if recursive or errcheck) */
	int __m_kind;                   /* Mutex kind: fast, recursive or errcheck */
	W __m_lock;		     /* real lock */
} pthread_mutex_t;

/* Attribute for mutex.  */
typedef struct {
	int __mutexkind;
} pthread_mutexattr_t;

/* @T-Engine, only one type lock, not apply RECURSIVE lock*/
/* PTHREAD_MUTEX_ADAPTIVE_NP */
enum
{
	PTHREAD_MUTEX_ADAPTIVE_NP,
	PTHREAD_MUTEX_FAST_NP = PTHREAD_MUTEX_ADAPTIVE_NP,
	PTHREAD_MUTEX_RECURSIVE_NP,
	PTHREAD_MUTEX_ERRORCHECK_NP,
	PTHREAD_MUTEX_TIMED_NP,
};

/* Functions for mutex handling.  */

/* Initialize MUTEX using attributes in *MUTEX_ATTR, or use the
default values if later is NULL.  */
IMPORT int nes_posix_pthread_mutex_init(pthread_mutex_t* mutex, const pthread_mutexattr_t* mutex_attr) ;

/* Destroy MUTEX.  */
IMPORT int nes_posix_pthread_mutex_destroy(pthread_mutex_t* mutex) ;

/* Try to lock MUTEX.  */
IMPORT int nes_posix_pthread_mutex_trylock(pthread_mutex_t* mutex) ;

/* Wait until lock for MUTEX becomes available and lock it.  */
IMPORT int nes_posix_pthread_mutex_lock(pthread_mutex_t* mutex) ;

/* Unlock MUTEX.  */
IMPORT int nes_posix_pthread_mutex_unlock(pthread_mutex_t* mutex) ;

/* Functions for handling mutex attributes.  */

/* Initialize mutex attribute object ATTR with default attributes
(kind is PTHREAD_MUTEX_TIMED_NP).  */
IMPORT int nes_posix_pthread_mutexattr_init(pthread_mutexattr_t* attr) ;

/* Destroy mutex attribute object ATTR.  */
IMPORT int nes_posix_pthread_mutexattr_destroy(pthread_mutexattr_t* attr) ;

 /* Get lock type */
IMPORT int nes_posix_pthread_mutexattr_gettype(const pthread_mutexattr_t* attr, int* type);
IMPORT int nes_posix_pthread_mutexattr_getkind_np(const pthread_mutexattr_t* attr, int* kind);

 /* Set lock type */
IMPORT int nes_posix_pthread_mutexattr_settype(pthread_mutexattr_t* attr, int type);
IMPORT int nes_posix_pthread_mutexattr_setkind_np(pthread_mutexattr_t* attr, int kind);

#ifdef __cplusplus
}
#endif

/*
 * Maxiaochen @ NECsoft (JiNan). 2008/07/10 append
*/

#ifdef __cplusplus
extern "C" {
#endif

IMPORT int pthread_mutex_init(pthread_mutex_t* mutex, const pthread_mutexattr_t* mutex_attr);
IMPORT int pthread_mutex_destroy(pthread_mutex_t* mutex);
IMPORT int pthread_mutex_trylock(pthread_mutex_t* mutex);
IMPORT int pthread_mutex_lock(pthread_mutex_t* mutex);
IMPORT int pthread_mutex_unlock(pthread_mutex_t* mutex);
IMPORT int pthread_mutexattr_init(pthread_mutexattr_t* attr);
IMPORT int pthread_mutexattr_destroy(pthread_mutexattr_t* attr);
IMPORT int pthread_mutexattr_gettype(const pthread_mutexattr_t* attr,int* type);
IMPORT int pthread_mutexattr_getkind_np(const pthread_mutexattr_t* attr,int* kind);
IMPORT int pthread_mutexattr_settype(pthread_mutexattr_t* attr, int type);
IMPORT int pthread_mutexattr_setkind_np(pthread_mutexattr_t* attr, int kind);

#ifdef __cplusplus
}
#endif
#endif
