/**
 * @file nes_posix_timeb.h
 * @brief This file is part of the posix library
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __NES_POSIX_TIMEB_H
#define __NES_POSIX_TIMEB_H

#include <time.h>
#include <typedef.h>

#ifdef __cplusplus
extern "C" { 
#endif

	/* Structure returned by the `ftime' function.  */

	struct timeb
	{
		time_t time;		/* Seconds since epoch, as from `time'.  */
		unsigned short int millitm;	/* Additional milliseconds.  */
		short int timezone;		/* Minutes west of GMT.  */
		short int dstflag;		/* Nonzero if Daylight Savings Time used.  */
	};

	/* Fill in TIMEBUF with information about the current time.  */

	IMPORT int nes_posix_ftime(struct timeb *__timebuf);
#ifdef __cplusplus
} 
#endif

/*
 * Maxiaochen @ NECsoft (JiNan). 2008/07/10 append
*/

#ifdef __cplusplus
extern "C" { 
#endif

IMPORT int ftime(struct timeb* __timebuf);

#ifdef __cplusplus
} 
#endif
#endif	/* timeb.h */
