/**
 * @file common.h
 * @brief lib common data and interface define
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _PTHREAD_COMM_H_
#define _PTHREAD_COMM_H_

#define D_LEVEL_ALL			0xFFFFFFFF			/* All info */
#define D_LEVEL_DEBUG		0x00000001			/* Debug info */
#define D_LEVEL_WARN			0x00000002			/* Warning info */
#define D_LEVEL_INFO			0x00000004			/* Info info */

#define D_MODU_ALL			0xFFFFFFFF			/* All module */
#define D_MODU_THCORE		0x00000001			/* Thread Core mudule */
#define D_MODU_SEM			0x00000002			/* Semaphore */
#define D_MODU_MUTEX		0x00000004			/* Mutex */
#define D_MODU_COND			0x00000008			/* Condition */
#define D_MODU_TSD			0x00000010			/* TSD */
#define D_MODU_ONCE			0x00000020			/* Once */
#define D_MODU_CANC			0x00000040			/* Cancel */
#define D_MODU_THATTR		0x00000080			/* Thread attr */
#define D_MODU_INTER			0x00000100			/* Internal */
#define D_MODU_OTHRES		0x00000200			/* Others */

/* 
 * Added by Wang yage @ NEC Soft(Ji Nan) Group 5. 2006/06/22. 
 * Support signal related module
 */
#define D_MODU_SIG_REG			0x00000010			/* Signal regist releated */
#define D_MODU_SIG_SND			0x00000020			/* Signal send releated */
#define D_MODU_SIG_WAT			0x00000040			/* Signal wait releated */
#define D_MODU_SIG_INTER			0x00000040			/* Signal internal interface  */


#ifdef PTHREAD_DEBUG
extern unsigned int __g_debug_level;
extern unsigned int __g_debug_module;
#endif

#ifdef PTHREAD_DEBUG
#define DP0(level, module, exp)	if( (__g_debug_level & level) && (__g_debug_module & module) )  printf exp
#else
#define DP0(level,module, exp)
#endif

#define DP1(module, exp)	DP0(D_LEVEL_DEBUG, module, exp)
#define DP2(module, exp)	DP0(D_LEVEL_WARN, module, exp)
#define DP3(module, exp)	DP0(D_LEVEL_INFO, module, exp)
#define DP(exp)			DP0(D_LEVEL_DEBUG, D_MODU_OTHRES, exp)

#endif	// _PTHREAD_COMM_H_
