/**
 * @file export.c
 * @brief implement of process operation
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "nes_posix_cond.h" 
#include "nes_posix_semaphore.h" 
#include "nes_posix_signal.h"
#include "nes_posix_mutex.h"
#include "nes_posix_pthread.h"

////////////////// nes_posix_cond.h ////////////////////////
int pthread_cond_init(pthread_cond_t *cond, pthread_condattr_t *cond_attr)
{
	return nes_posix_pthread_cond_init(cond, cond_attr);
}

int pthread_condattr_init(pthread_condattr_t * attr)
{
	return nes_posix_pthread_condattr_init(attr);
}

int pthread_condattr_destroy(pthread_condattr_t *attr)
{
	return nes_posix_pthread_condattr_destroy(attr);
}

int pthread_cond_destroy(pthread_cond_t *cond)
{
	return nes_posix_pthread_cond_destroy(cond);
}

int pthread_cond_wait(pthread_cond_t *cond, pthread_mutex_t *mutex)
{
	return nes_posix_pthread_cond_wait(cond, mutex);
}

int pthread_cond_timedwait(pthread_cond_t *cond, pthread_mutex_t *mutex, const struct timespec *abstime)
{
	return nes_posix_pthread_cond_timedwait(cond, mutex, abstime);
}

int pthread_cond_signal(pthread_cond_t *cond)
{
	return nes_posix_pthread_cond_signal(cond);
}

int pthread_cond_broadcast(pthread_cond_t *cond)
{
	return nes_posix_pthread_cond_broadcast(cond);
}

////////////////// nes_posix_semaphore.h ////////////////////////

int sem_init(sem_t* sem, int pshared, unsigned int value)
{
	return nes_posix_sem_init(sem, pshared, value);
}
int sem_destroy(sem_t* sem)
{
	return nes_posix_sem_destroy(sem);
}
int sem_wait(sem_t* sem)
{
	return nes_posix_sem_wait(sem);
}
int sem_trywait(sem_t* sem)
{
	return nes_posix_sem_trywait(sem);
}
int sem_post(sem_t* sem)
{
	return nes_posix_sem_post(sem);
}
int sem_getvalue(sem_t* sem, int* sval)
{
	return nes_posix_sem_getvalue(sem, sval);
}

////////////////// nes_posix_signal.h ////////////////////////
int getpid(void)
{
	return nes_posix_getpid();
}

int sigfillset(sigset_t* set)
{
	return nes_posix_sigfillset(set);
}

int sigemptyset(sigset_t* set)
{
	return nes_posix_sigemptyset(set);
}

int sigaddset(sigset_t* set,int _sig)
{
	return nes_posix_sigaddset(set, _sig);
}

int sigdelset(sigset_t* set,int _sig)
{
	return nes_posix_sigdelset(set, _sig);
}

int sigismember(const sigset_t* set, int _sig)
{
	return nes_posix_sigismember(set, _sig);
}

int sigorsets(const sigset_t* in1, const sigset_t* in2, sigset_t* out)
{
	return nes_posix_sigorsets(in1, in2, out);
}

int sigandsets(const sigset_t* in1, const sigset_t* in2, sigset_t* out)
{
	return nes_posix_sigandsets(in1, in2, out);
}

int sigpending(sigset_t* set)
{
	return nes_posix_sigpending(set);
}

int sigprocmask(int how, const sigset_t* set, sigset_t* oldset)
{
	return nes_posix_sigprocmask(how, set, oldset);
}

sighandler_t signal(int signum, sighandler_t handler)
{
	return nes_posix_signal(signum, handler);
}

int sigaction(int signum, const struct sigaction* act,  struct sigaction* oldact)
{
	return nes_posix_sigaction(signum, act, oldact);
}

int raise(int signum)
{
	return nes_posix_raise(signum);
}

int kill(pid_t pid, int signum)
{
	return nes_posix_kill(pid, signum);
}

unsigned int alarm(unsigned int seconds)
{
	return nes_posix_alarm(seconds);
}

int sigqueue(pid_t pid, int signum, const union sigval value)
{
	return nes_posix_sigqueue(pid, signum, value);
}

int pause(void)
{
	return nes_posix_pause();
}

int sigsuspend(const sigset_t* set)
{
	return nes_posix_sigsuspend(set);
}

////////////////// nes_posix_mutex.h ////////////////////////
int pthread_mutex_init(pthread_mutex_t* mutex, const pthread_mutexattr_t* mutex_attr)
{
	return nes_posix_pthread_mutex_init(mutex, mutex_attr);
}

int pthread_mutex_destroy(pthread_mutex_t* mutex)
{
	return nes_posix_pthread_mutex_destroy(mutex);
}

int pthread_mutex_trylock(pthread_mutex_t* mutex)
{
	return nes_posix_pthread_mutex_trylock(mutex);
}

int pthread_mutex_lock(pthread_mutex_t* mutex)
{
	return nes_posix_pthread_mutex_lock(mutex);
}

int pthread_mutex_unlock(pthread_mutex_t* mutex)
{
	return nes_posix_pthread_mutex_unlock(mutex);
}

int pthread_mutexattr_init(pthread_mutexattr_t* attr)
{
	return nes_posix_pthread_mutexattr_init(attr);
}

int pthread_mutexattr_destroy(pthread_mutexattr_t* attr)
{
	return nes_posix_pthread_mutexattr_destroy(attr);
}

int pthread_mutexattr_gettype(const pthread_mutexattr_t* attr,int* type)
{
	return nes_posix_pthread_mutexattr_gettype(attr, type);
}

int pthread_mutexattr_getkind_np(const pthread_mutexattr_t* attr,int* kind)
{
	return nes_posix_pthread_mutexattr_getkind_np(attr, kind);
}

int pthread_mutexattr_settype(pthread_mutexattr_t* attr, int type)
{
	return nes_posix_pthread_mutexattr_settype(attr, type);
}

int pthread_mutexattr_setkind_np(pthread_mutexattr_t* attr, int kind)
{
	return nes_posix_pthread_mutexattr_setkind_np(attr, kind);
}

////////////////// nes_posix_pthread.h ////////////////////////
int pthread_create(pthread_t* thread, const pthread_attr_t* attr, void (*start_routine)(void*), void* arg)
{
	return nes_posix_pthread_create(thread, attr, start_routine, arg);
}

int pthread_join(pthread_t thread, void** thread_return)
{
	return nes_posix_pthread_join(thread, thread_return);
}

pthread_t pthread_self(void)
{
	return nes_posix_pthread_self();
}

int pthread_equal(pthread_t thread1, pthread_t thread2)
{
	return nes_posix_pthread_equal(thread1, thread2);
}

void pthread_exit(void *retval)
{
	nes_posix_pthread_exit(retval);
}

int pthread_detach(pthread_t  th)
{
	return nes_posix_pthread_detach(th);
}

int pthread_attr_init(pthread_attr_t * attr)
{
	return nes_posix_pthread_attr_init(attr);
}

int pthread_attr_destroy(pthread_attr_t * attr)
{
	return nes_posix_pthread_attr_destroy(attr);
}

int pthread_attr_setdetachstate(pthread_attr_t* attr, int detachstate)
{
	return nes_posix_pthread_attr_setdetachstate(attr, detachstate);
}

int pthread_attr_getdetachstate(const pthread_attr_t* attr, int* detachstate)
{
	return nes_posix_pthread_attr_getdetachstate(attr, detachstate);
}

int pthread_attr_setschedparam(pthread_attr_t* attr, const struct sched_param* param)
{
	return nes_posix_pthread_attr_setschedparam(attr, param);
}

int pthread_attr_getschedparam(const pthread_attr_t* attr, struct sched_param*  param)
{
	return nes_posix_pthread_attr_getschedparam(attr, param);
}

int pthread_attr_setschedpolicy(pthread_attr_t* attr, int  policy) 
{
	return nes_posix_pthread_attr_setschedpolicy(attr, policy);
}

int pthread_attr_getschedpolicy(const pthread_attr_t* attr, int*  policy)
{
	return nes_posix_pthread_attr_getschedpolicy(attr, policy);
}

int pthread_attr_setinheritsched(pthread_attr_t* attr, int  inherit)
{
	return nes_posix_pthread_attr_setinheritsched(attr, inherit);
}

int pthread_attr_getinheritsched(const pthread_attr_t* attr, int* inherit)
{
	return nes_posix_pthread_attr_getinheritsched(attr, inherit);
}

int pthread_attr_setscope(pthread_attr_t* attr, int  scope)
{
	return nes_posix_pthread_attr_setscope(attr, scope);
}

int pthread_attr_getscope(const pthread_attr_t*  attr, int*  scope)
{
	return nes_posix_pthread_attr_getscope(attr, scope);
}

int pthread_attr_setstack(pthread_attr_t* attr, void* stackaddr, size_t stacksize)
{
	return nes_posix_pthread_attr_setstack(attr, stackaddr, stacksize);
}

int pthread_attr_getstack(const pthread_attr_t* attr, void** stackaddr, size_t* stacksize)
{
	return nes_posix_pthread_attr_getstack(attr, stackaddr, stacksize);
}

int pthread_attr_setstackaddr(pthread_attr_t* attr, void* stackaddr)
{
	return nes_posix_pthread_attr_setstackaddr(attr, stackaddr);
}

int pthread_attr_getstackaddr(const pthread_attr_t* attr, void**  stackaddr)
{
	return nes_posix_pthread_attr_getstackaddr(attr, stackaddr);
}

int pthread_attr_setstacksize(pthread_attr_t* attr, size_t stacksize)
{
	return nes_posix_pthread_attr_setstacksize(attr, stacksize);
}

int pthread_attr_getstacksize(const pthread_attr_t* attr, size_t* stacksize)
{
	return nes_posix_pthread_attr_getstacksize(attr, stacksize);
}

int pthread_setschedparam(pthread_t target_thread, int  policy, const struct sched_param * param)
{
	return nes_posix_pthread_setschedparam(target_thread, policy, param);
}

int pthread_getschedparam(pthread_t  target_thread, int* policy, struct sched_param* param)
{
	return nes_posix_pthread_getschedparam(target_thread, policy, param);
}

int pthread_attr_setguardsize(pthread_attr_t* attr, size_t guardsize)
{
	return nes_posix_pthread_attr_setguardsize(attr, guardsize);
}

int pthread_attr_getguardsize(const pthread_attr_t* attr, size_t* guardsize)
{
	return nes_posix_pthread_attr_getguardsize(attr, guardsize);
}

int pthread_getattr_np(pthread_t thread, pthread_attr_t *attr)
{
	return nes_posix_pthread_getattr_np(thread, attr);
}

int pthread_once(pthread_once_t *__once_control, void (*__init_routine) (void))
{
	return nes_posix_pthread_once(__once_control, __init_routine);
}

int pthread_key_create(pthread_key_t*__key, void (*__destr_function) (void*))
{
	return nes_posix_pthread_key_create(__key, __destr_function);
}

int pthread_key_delete(pthread_key_t __key)
{
	return nes_posix_pthread_key_delete(__key);
}

int pthread_setspecific(pthread_key_t __key,   const void* __pointer)
{
	return nes_posix_pthread_setspecific(__key, __pointer);
}

void* pthread_getspecific(pthread_key_t __key)
{
	return nes_posix_pthread_getspecific(__key);
}

int pthread_setcanceltype(int type, int *oldtype)
{
	return nes_posix_pthread_setcanceltype(type, oldtype);
}

int pthread_cancel(pthread_t cancelthread)
{
	return nes_posix_pthread_cancel(cancelthread);
}

void pthread_testcancel(void)
{
	nes_posix_pthread_testcancel();
}

int pthread_kill(pthread_t thread, int signo)
{
	return nes_posix_pthread_kill(thread, signo);
}

void pthread_kill_other_threads_np(void)
{
	nes_posix_pthread_kill_other_threads_np();
}

int pthread_setcancelstate(int state, int *oldstate)
{
	return nes_posix_pthread_setcancelstate(state, oldstate);
}

void pthread_cleanup_push_defer_np(void (*routine)(void*), void* arg)
{
	nes_posix_pthread_cleanup_push_defer_np(routine, arg);
}

void pthread_cleanup_pop_restore_np(int execute)
{
	nes_posix_pthread_cleanup_pop_restore_np(execute);
}

int sigwait(const sigset_t* set, int *sig)
{
	return nes_posix_sigwait(set, sig);
}

int pthread_sigmask(int how, const sigset_t *newmask, sigset_t *oldmask)
{
	return nes_posix_pthread_sigmask(how, newmask, oldmask);
}
