/**
 * @file manager.h
 * @brief internal core header file 
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __MANAGER_H__
#define __MANAGER_H__

#include "nes_posix_pthread.h"
#include "internal_lock.h"
#include "tsd.h"
#include "nes_posix_siginfo.h"

#ifdef __cplusplus
extern "C" {
#endif

extern pthread_t __g_main_thread;
#define __MAIN_THREAD __g_main_thread

#define GLOBAL_THREADMGR_LOCK() __pthread_lock()
#define GLOBAL_THREADMGR_UNLOCK() __pthread_unlock()

#define  STATUS_THREAD_DEFAULT		0x00000000		/* main thread flag bit */
#define  STATUS_THREAD_MAIN_THREAD		0x00000001		/* main thread flag bit */
#define  STATUS_THREAD_JOIN_NOW		0x00000002		/* pthread_join is waiting NOW */
#define  STATUS_THREAD_CANCEL_ALREADY	0x00000004		/* thread has been canceled*/

/*
 * Thread control block define
 */
typedef struct TCB
{
	unsigned int __status;		/* Thread status word */

	int __exitcode;			/* thread exit code */
	__internal_lock_t __lock;	/* Use for thread join */
	pthread_attr_t __attr;		/* Thread attribute */

	void** __tsd_buf[PTHREAD_KEY_1STLEVEL_SIZE];		/* Use for TSD */

	//------------------------------------------------->by liu-cm
	int cancelState;			/* cancel state */
	int cancelType;			/* cancel type */
	struct _pthread_cleanup_buffer* p_cleanup; /* cleanup functions */
	//<------------------------------------------------- by liu-cm

	/* Modified by wang-yg @ NECSoft(JiNan) May 25 2006 */
	sigset_t __block_sigmask;		/* Blocked signal mask */
	int __sigwait_signum;		/* sigwait() result signal number */

} __pthread_desr;

/* Pthread libary init */
int __phread_init(void);			
int __phread_finish(void);

/* Pthread libary global lock operation*/
int __pthread_lock(void);
int __pthread_unlock(void);

/*
 *	These functions used without GLOBAL_THREADMGR_LOCK
 *	When use them, callers must use LOCK and UNLOCK manual
 */
/* Pthread descriptor struct init and destroy */
int __pthread_desr_init(__pthread_desr* desr, const pthread_attr_t* attr, unsigned char is_mainthread);
int __pthread_desr_destroy(__pthread_desr* desr);

/* Pthread descriptor manager */
int __pthread_add_desr(const pthread_t tid, const __pthread_desr* desr);
int __pthread_del_desr(const pthread_t tid);
__pthread_desr* __pthread_del_desr_2(const pthread_t tid);
__pthread_desr* __pthread_find_desr(const pthread_t tid);

#ifdef __cplusplus
}
#endif

#endif //__MANAGER_H__
