/**
 * @file sigmanager.h
 * @brief define internal sigmanager related interface
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __SIGMANAGER_H__
#define __SIGMANAGER_H__

#include "nes_posix_siginfo.h"
#ifdef NES_SE   /* Use Standard Extension */
#include <sys/queue.h>
#include <tkse/extension/message.h>
#else           /* Use PMC Extension */
#include <queue.h>
#include <btron/message.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define __MSG_TERM			MS_TYPE0
#define __MSG_BREAK			MS_TYPE1
#define __MSG_UNREALTIME		MS_TYPE2
#define __MSG_REALTIME			MS_TYPE3
#define __MSG_END_THREAD		MS_TYPE4
#define __MSG_BLOCK			MS_TYPE5

#define __ALL_RECEIVE_MASK	( MSGMASK(__MSG_UNREALTIME) | \
					          MSGMASK(__MSG_REALTIME) | \
					          MSGMASK(__MSG_END_THREAD) | \
					          MSGMASK(__MSG_BLOCK) )

#define GLOBAL_SIG_LOCK() __sig_lock();
#define GLOBAL_SIG_UNLOCK()  __sig_unlock();

typedef struct _sigqueue {
	QUEUE node;		/* Queue pointor */
	int signum;			/* Linux signal number */
	int sender;			/* Sender process */
	int thread;			/* Dest thread (0 means MAIN THREAD) */
	MESSAGE msg;		/* Original MESSAGE */
}sigqueue_t;

struct sigpending {
	sigset_t mask;		/* Pending signal mask */
	sigqueue_t queue;	/* Pending signal queue */
	int queue_len;		/* Pending queue len */
};

struct __alarm_time {
	UW	__send_time;
	UW	__alive_time;
};

#define SIGWAIT_WAIT_TYPE 0
#define SIGSUSPEND_WAIT_TYPE 1
#define PAUSE_WAIT_TYPE 2
struct __sigwait_queue {
	QUEUE node;
	int thread;
	int type;
	sigset_t waitset;
};

#define __SIG_QUEUE_MAX	100	/* Pending signal queue max len */

int __init_sig_lib(void);
void __finish_sig_lib(void);

int __sig_lock(void);
int __sig_unlock(void);

Inline int __signal_is_valid(const int signum) { return (signum < 1 || signum > _NSIG ) ? 0 : 1; }

/* Block signal set update notify */
int __send_block_notify(void);
int __send_break_notify(void);
int __send_term_notify(void);

sigqueue_t* __find_and_remove_pending_signal(const int signum);

#ifdef __cplusplus
}
#endif


#endif //__SIGMANAGER_H__
