/**
 * @file queue.h
 * @brief This file is part of the posix library
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _QUEUE_H_
#define _QUEUE_H_

#include <basic.h>
#include <stdlib.h>

typedef struct node {
	W itid;//task id
	int iptn;//option of flg
	struct node *next;
} node;

struct queue {
  struct node* head;
  struct node* tail; 
};

/* init a queue */
void queue_init(struct queue *myroot);
/* push a node into the queue */
void queue_push(struct queue *myroot, struct node *mynode);
/* search the data is existing or not in the queue */
int queue_find(struct queue *myroot, int tskid);
/* destroy a queue */
int queue_destroy(struct queue *myroot);
/* pop the head node of queue */
node* queue_pop(struct queue *myroot);
/* find one node and delete it from queue */
int queue_search_del(struct queue *myroot, int tskid);


#endif
