/**
 * @file nes_posix_unistd.c
 * @brief This file is part of the posix library
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <errno.h>
#include <btron/proctask.h>
#include <btron/errcode.h>

#include "nes_posix_unistd.h"

/**
 * nes_posix_usleep - suspends execution of the calling task for (at least) usec microseconds.
 * @param usec	microseconds that to be suspends
 * @retval int 0: success -1: failed
 * 
 * @note
 */
int nes_posix_usleep(useconds_t usec)
{
	if( usec == 0 ) {
		errno = EINVAL;
		return -1;
	}

	int ret = b_slp_tsk(usec / 1000);
	if( ret == ER_PAR ) {
		errno = EINVAL;
		return -1;
	} else if( ret == ER_MINTR||ret==ER_OK ) {
		errno = EINTR;	/* Interuppt by signal */
		return -1;
	}
	return 0; /* ER_OK || ER_NONE */
}
