/*
 * Copyright (c) 2008, AIST.
 * All rights reserved. This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * National Institute of Advanced Industrial Science and Technology (AIST)
 */
#ifndef __T_KERNEL__
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <netdb.h>
#include <ctype.h>
#endif
#include <RtORB/corba.h>

#ifdef USE_SHMC
static char s_localhost[32] = {0};

static int use_socket(GIOP_Connection *conn)
{
  char hostname[128];
  if (!s_localhost[0]) {
    char *addr = Get_IP_Address();
    strcpy(s_localhost, addr);
    RtORB_free(addr, "use_socket");
  }
  
  if (isalpha(conn->hostname[0])) {
    struct hostent * h = gethostbyname((char*)conn->hostname);
    if (!h) { return 1; }
    /* inet_ntoa function doesn't work!! */
    unsigned char *p  = *(unsigned char **)h->h_addr_list;
    sprintf(hostname, "%d.%d.%d.%d", p[0], p[1], p[2], p[3]);
  } else {
    strcpy(hostname, (char*)conn->hostname);
  }

  return (strcmp("localhost", hostname) == 0 ||
	  strcmp("127.0.0.1", hostname) == 0 ||
	  strcmp(s_localhost, hostname) == 0 ) ? 0: 1;
}
#else
#define use_socket(CONN) 1
#endif

#ifdef USE_SHMC
static int touch(const char *fname)
{
  int fd;

  fd = open(fname,
	    O_WRONLY | O_CREAT | O_NONBLOCK | O_NOCTTY,
	    S_IWUSR | S_IRUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH);
  if (fd == -1) { return 1; }
  close(fd);
  return 0;
}

#ifndef TMPDIR
#define TMPDIR "/tmp"
#endif

static char *get_key(int port, char *buf, int create)
{
  sprintf(buf, "%s/rtorb-shmc.%d", TMPDIR, port);
  if (create) {
    touch(buf);
  }
  return buf;
}
#endif  

int make_server_connection(GIOP_Connection *conn, int port)
{
  int sock = make_server_socket_port(port);
  if (sock < 0) { return -1; }

  if(!conn->port) conn->port = get_socket_port(sock);
  else conn->port = port;

#ifdef USE_SHMC
  {
    Shmc *shmc = NULL;
    char key[128];
    get_key(conn->port, key, 1);
    shmc = shmcOpen(key);
    if (!shmc) {
      fprintf(stderr, "shmc : fail to call shmcOpen");
      return -1;
    }
    if (shmcBind(shmc) < 0) {
      fprintf(stderr, "shmc : fail to call shmcBind\n");
      shmcClose(shmc);
      return -1;
    }
    conn->shmc = shmc;
  }
#endif
  conn->sock = sock;
  return sock;
}

GIOP_ConnectionHandler * make_client_connection(GIOP_Connection *conn)
{
  GIOP_ConnectionType type;
  GIOP_ConnectionHandler *h = NULL;

  if (use_socket(conn)) {
    if (!conn->sock) {
      int sock = make_client_socket_port((char*)conn->hostname, conn->port);
      if (sock < 0) {
	return NULL;
      }
      conn->sock = sock;
    }
    type = CONNECTION_TYPE_SOCKET;
#ifdef USE_SHMC
  } else {
    if (!conn->shmc) {
      Shmc * shmc = NULL;
      char key[128];
      get_key(conn->port, key, 0);
      shmc = shmcOpen(key);
      if (shmc == NULL) {
	fprintf(stderr, "shmc : fail to call shmcOpen\n");
	exit(1);
      }
      if (shmcConnect(shmc) < 0) {
	fprintf(stderr, "shmc : fail to call shmcConnect\n");
	shmcClose(shmc);
	exit(1);
      }
      conn->shmc = shmc;
    }
    type = CONNECTION_TYPE_SHMC;
#endif
  }

  h = (GIOP_ConnectionHandler *)RtORB_alloc(sizeof(GIOP_ConnectionHandler), "make_client_connection");

  h->type = type;
  h->sock = conn->sock;
#ifdef USE_SHMC
  h->shmc = conn->shmc;
#endif

  return h;
}

