// -*- C -*-
/*!
 * @file  rtc_log.h
 * @brief Log Operate
 * @date  $Date$
 *
 * $Id$
 */

#ifndef RTC_LOG_H
#define RTC_LOG_H

#include	<stdio.h>

#define FILE_NAME_MAX_LENGTH 256

// եϥ⡼
typedef enum
{
	LOGFILE_MODE_NUMBER = 1,	// ֹ
	LOGFILE_MODE_DAY,			// ñ
	LOGFILE_MODE_WEEK			// ñ
} LOGFILE_MODE;

// ե
#define MAXFILENUM_DEF	(3)	//ǥե
#define MAXFILENUM_MIN	(1)	//Ǿ
#define MAXFILENUM_MAX	(7)	//

// ե륫
#define FILECOUNTER_DEF	(1)
#define FILECOUNTER_MIN	MAXFILENUM_MIN
#define FILECOUNTER_MAX	MAXFILENUM_MAX

#define FILECOUNTER_NEXT(counter, maxcounter)	((counter % maxcounter)+1)

// ϥ⡼
typedef enum
{
	OUTPUT_MODE_OFF = 0,		// OFF
	OUTPUT_MODE_ON				// ON
} OUTPUT_MODE;

#ifdef __cplusplus
extern "C"{
#endif
	
	// ⡼
	typedef struct log_mode_tag
	{
		char			fileDirPath[FILE_NAME_MAX_LENGTH];	// եǥ쥯ȥѥ
		char			fileName[FILE_NAME_MAX_LENGTH];		// ե̾
		LOGFILE_MODE	mode;								// ե⡼
		int				maxNum;								// ե
		int				counter;							// ե륫(եϥ⡼ɤֹλΤͭ)
		OUTPUT_MODE		console;							// 󥽡ϲ
		OUTPUT_MODE		logFile;							// եϲ
	} LOG_MODE;
	
	// ϵǽ
	void initLog(LOG_MODE logMode);
	// ϵǽλ
	void finishLog();
	// 󥽡Ͼ
	void setConsoleMode(OUTPUT_MODE console);
	// 󥽡Ͼּ
	void getConsoleMode(OUTPUT_MODE* console);
	// եϾ
	void setLogFileMode(OUTPUT_MODE logFile);
	// եϾּ
	void getLogFileMode(OUTPUT_MODE* logFile);
	// ǥХåϤԤ
	void outputLog(const char *msg, const char *file, const int line, const char *format, ...);

#ifdef __cplusplus
};
#endif

// ǥХå
#ifdef DEBUG_OUT
#define	DEBUGOUT(...)	printf(__VA_ARGS__); printf("\n")
#else
#define	DEBUGOUT(...)
#endif

#ifdef DEBUG_FILE_LINE
#define LOGOUT(...) outputLog( NULL, __FILE__, __LINE__, __VA_ARGS__);
#else
#define LOGOUT(...) outputLog( NULL, NULL, 0, __VA_ARGS__)
#endif

#define	USAGEOUT(...)	printf(__VA_ARGS__); printf("\n");

#endif //RTC_LOG_H
