#ifndef CONNECT_THREAD_H
#define CONNECT_THREAD_H

/*!
  \file
  \brief 再生時の接続用スレッド

  \author Satofumi KAMIMURA

  $Id: RangeSensorConnectThread.h 1775 2010-04-12 21:38:30Z satofumi $
*/

#include <QThread>
#include <memory>

namespace qrk
{
  class RangeSensor;
}


/*!
  \brief 接続用スレッドクラス
*/
class RangeSensorConnectThread : public QThread
{
  Q_OBJECT;

public:
  RangeSensorConnectThread(qrk::RangeSensor& sensor);
  ~RangeSensorConnectThread(void);

  void setConnectSettings(const std::string& device, long baudrate);

signals:
  void connected(bool connected);

protected:
  void run(void);

private:
  RangeSensorConnectThread(void);
  RangeSensorConnectThread(const RangeSensorConnectThread& rhs);
  RangeSensorConnectThread& operator = (const RangeSensorConnectThread& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /* !CONNECT_THREAD_H */
