// -*- C++ -*-
/*!
 * @file  RtcUrgViewer.cpp * @brief InPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "UrgViewerWindow.h"
#include <QApplication>
#include <QTranslator>
#include "RtcUrgViewer.h"

extern UrgViewerWindow *g_window;

// Module specification
// <rtc-template block="module_spec">
static const char* samplerangedatain_spec[] =
{
    "implementation_id", "RtcUrgViewer",
    "type_name",         "RtcUrgViewer",
    "description",       "range data viewer component",
    "version",           RTC_URG_VIEWER_VERSION,
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
};
// </rtc-template>

RtcUrgViewer::RtcUrgViewer(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_rangedataIn("rangedata", m_rangedata)

    // </rtc-template>
{
}

RtcUrgViewer::~RtcUrgViewer()
{
}


RTC::ReturnCode_t RtcUrgViewer::onInitialize()
{
    // Registration: InPort/OutPort/Service
    // <rtc-template block="registration">
    // Set InPort buffers
    addInPort("rangedata", m_rangedataIn);

    // Set OutPort buffer

    // Set service provider to Ports

    // Set service consumers to Ports

    // Set CORBA Service Ports

    // </rtc-template>

    // <rtc-template block="bind_config">
    // Bind variables and configuration variable

    // </rtc-template>


    return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t RtcUrgViewer::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RtcUrgViewer::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RtcUrgViewer::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RtcUrgViewer::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RtcUrgViewer::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

void dumpRangeData(RangeData *rangedata)
{
    int i, maxsize;

    std::cout << "RangeData read" << std::endl;
    maxsize = rangedata->ranges.length();
    std::cout << "RangeList:" << std::endl;

    for (i = 0; i < maxsize; i++)
    {
        std::cout << i << " : " << rangedata->ranges[i] << std::endl;
    }

    std::cout << "RangerGeometry:" << std::endl;
    std::cout << "  Geometry3D:" << std::endl;
    std::cout << "    Pose3D:" << std::endl;
    std::cout << "      Point3D:" << std::endl;
    std::cout << "        x:" << rangedata->geometry.geometry.pose.position.x << std::endl;
    std::cout << "        y:" << rangedata->geometry.geometry.pose.position.y << std::endl;
    std::cout << "        z:" << rangedata->geometry.geometry.pose.position.z << std::endl;
    std::cout << "      Orientation3D:" << std::endl;
    std::cout << "        r:" << rangedata->geometry.geometry.pose.orientation.r << std::endl;
    std::cout << "        p:" << rangedata->geometry.geometry.pose.orientation.p << std::endl;
    std::cout << "        y:" << rangedata->geometry.geometry.pose.orientation.y << std::endl;
    std::cout << "    Size3D:" << std::endl;
    std::cout << "        l:" << rangedata->geometry.geometry.size.l << std::endl;
    std::cout << "        w:" << rangedata->geometry.geometry.size.w << std::endl;
    std::cout << "        h:" << rangedata->geometry.geometry.size.h << std::endl;

    maxsize = rangedata->geometry.elementGeometries.length();
    std::cout << "  ElementGeometryList:" << std::endl;

    for (i = 0; i < maxsize; i++)
    {
        std::cout << "    " << i << std::endl;
        std::cout << "      Pose3D:" << std::endl;
        std::cout << "        Point3D:" << std::endl;
        std::cout << "          x:" << rangedata->geometry.elementGeometries[i].pose.position.x << std::endl;
        std::cout << "          y:" << rangedata->geometry.elementGeometries[i].pose.position.y << std::endl;
        std::cout << "          z:" << rangedata->geometry.elementGeometries[i].pose.position.z << std::endl;
        std::cout << "        Orientation3D:" << std::endl;
        std::cout << "          r:" << rangedata->geometry.elementGeometries[i].pose.orientation.r << std::endl;
        std::cout << "          p:" << rangedata->geometry.elementGeometries[i].pose.orientation.p << std::endl;
        std::cout << "          y:" << rangedata->geometry.elementGeometries[i].pose.orientation.y << std::endl;
        std::cout << "      Size3D:" << std::endl;
        std::cout << "          l:" << rangedata->geometry.elementGeometries[i].size.l << std::endl;
        std::cout << "          w:" << rangedata->geometry.elementGeometries[i].size.w << std::endl;
        std::cout << "          h:" << rangedata->geometry.elementGeometries[i].size.h << std::endl;
    }
    std::cout << "RangerConfig:" << std::endl;
    std::cout << "  minAngle  : " << rangedata->config.minAngle << std::endl;
    std::cout << "  maxAngle  : " << rangedata->config.maxAngle << std::endl;
    std::cout << "  angularRes: " << rangedata->config.angularRes << std::endl;
    std::cout << "  minRange  : " << rangedata->config.minRange << std::endl;
    std::cout << "  maxRange  : " << rangedata->config.maxRange << std::endl;
    std::cout << "  rangeRes  : " << rangedata->config.rangeRes << std::endl;
    std::cout << "  frequency : " << rangedata->config.frequency << std::endl;

}

RTC::ReturnCode_t RtcUrgViewer::onExecute(RTC::UniqueId ec_id)
{
    if (!g_window) return RTC::RTC_OK;

    // RangeData
    if (m_rangedataIn.isNew())
    {
        m_rangedataIn.read();

        // 読み出したデータをGUIにPushする(描画させる)
        g_window->pushRangeData(m_rangedata);

        dumpRangeData(&m_rangedata);
    }

    return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t RtcUrgViewer::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RtcUrgViewer::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RtcUrgViewer::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RtcUrgViewer::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RtcUrgViewer::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
    void RtcUrgViewerInit(RTC::Manager* manager)
    {
        coil::Properties profile(samplerangedatain_spec);
        manager->registerFactory(profile,
                                 RTC::Create<RtcUrgViewer>,
                                 RTC::Delete<RtcUrgViewer>);
    }
  
};
