#ifndef QRK_CONVERT_2D_H
#define QRK_CONVERT_2D_H

/*!
  \file
  \brief 2D conversion of the distance data

  \author Satofumi KAMIMURA

  $Id: convert2d.h 1715 2010-02-21 21:03:13Z satofumi $
*/

#include "Point.h"
#include "Position.h"
#include <vector>


namespace qrk
{
  class RangeSensor;


  /*!
    \brief Extract two dimensional plane from  RangeSensor data

    \param[out] points Group of data points after conversion
    \param[in] sensor Target sensor
    \param[in] data Measurement data
    \param[in] offset Offset during conversion
    \param[in] max_length Maximum distance up to which conversion is permitted (The value -1 means max distance.)

  */
  void convert2d(std::vector<qrk::Point<long> >& points,
                 const RangeSensor* sensor, const std::vector<long>& data,
                 const qrk::Position<long>& offset,
                 int max_length = -1);


  /*!
    \overload
  */
  void convert2d(std::vector<qrk::Point<long> >& points,
                 const RangeSensor* sensor, const std::vector<long>& data,
                 int max_length = -1);
}

#endif /* !CONVERT_2D_H */
