/*!
  \file
  \brief 待機関数

  \author Satofumi KAMIMURA

  $Id: system_delay.cpp 772 2009-05-05 06:57:57Z satofumi $
*/

#include "system_delay.h"
#include <QThread>


namespace
{
  class DelayThread : public QThread
  {
    int delay_msec_;

  public:
    DelayThread(int msec) : delay_msec_(msec)
    {
    }


    void run(void)
    {
      QThread::msleep(delay_msec_);
    }
  };
}


void qrk::system_delay(int msec)
{
  if (msec > 0) {
    DelayThread delay_thread(msec);
    delay_thread.run();
    delay_thread.wait();
  }
}
