// -*- C++ -*-
/*!
 * @file GlobalNavigationComp.cpp
 * @brief Entry Point of the Global Navigation RT-component
 * @date $Date$ 
 *
 */

#include <rtm/Manager.h>
#include <iostream>
#include <string>
#include "GlobalNavigationRTC.h"


/*! このコンポーネントの初期化関数.
 *
 *  @a GlobalNavigationRTCInit を経由して，ファクトリーへの追加，
 *  コンポーネントのインスタンス生成を行う
 *
 *  @param[in] manager RTCのManagerのインスタンス
 */
void MyModuleInit(RTC::Manager* manager)
{
  GlobalNavigationRTCInit(manager);
  RTC::RtcBase* comp;

  // Create a component
  comp = manager->createComponent("GlobalNavigationRTC");

  return;
}

int main (int argc, char** argv)
{
  RTC::Manager* manager;
  manager = RTC::Manager::init(argc, argv);

  // Initialize manager
  manager->init(argc, argv);

  // Set module initialization proceduer
  // This procedure will be invoked in activateManager() function.
  manager->setModuleInitProc(MyModuleInit);

  // Activate manager and register to naming service
  manager->activateManager();

  // run the manager in blocking mode
  // runManager(false) is the default.
  manager->runManager();

  // If you want to run the manager in non-blocking mode, do like this
  // manager->runManager(true);

  return 0;
}

/*
 * Local Variables:
 * mode: c++
 * c-basic-offset: 4
 * tab-width: 4
 * indent-tabs-mode: t
 * End:
 *
 */

