/*!
 * @file config_data.h
 * @brief Configuration Data for the MapViewer Component
 * @author SAGAMI, Tsuyoshi <sagami@brains.co.jp>
 */ 

#if !defined(CONFIG_DATA_HEADER_)
#define      CONFIG_DATA_HEADER_

#include <string>
#include <iosfwd>
/*! @class ConfigData
 *  @brief Holder for the configuration variables.
 *
 *  設定データを表すクラス。ファイルからの読み込み，値の保持を受け持つ
 */
class ConfigData {
public:
	ConfigData();				//!<コンストラクタ。各値をdefaultにする

	/*! ファイルからの読み込み
	 *  @param[in] filename ファイル名
	 *  @return 成功したかどうか
	 */
	bool readFromFile(const std::string& filename);

	//! 入力ポートの数を返す
	int numberOfInPorts() const { return n_inports_; }

	//!  プログラム開始時にデータを読み込むディレクトリ名を返す
	std::string startupDirectory() const { return startup_dirname_; }

	//! 偽色表示の際の閾値(低)を返す
	double potentialMin() const { return pot_min_; }
    //! 偽色表示の際の閾値(高)を返す
	double potentialMax() const { return pot_max_; }

private:
	int n_inports_;				//!< 入力ポートの数
	std::string startup_dirname_; //!< プログラム開始時に初期データをここから読む

	double pot_min_;			//!< 偽色表示の際，これ以下は最低値と見なす
	double pot_max_;			//!< 偽色表示の際，これ以上は最高値と見なす
public:
	// TAG_NAMES
	static const char INPUT_NUMBER[]; //!< 入力ポート用XMLタグ名 
	static const char STARTUP_DIRNAME[]; //!< 初期設定ディレレクトリタグ名
	static const char POTENTIAL_MIN[];   //!< ポテンシャル最小値タグ名 
	static const char POTENTIAL_MAX[];   //!< ポテンシャル最大値タグ名 
};

/*! @a ConfigData をストリームに出力する
 *  @param ost 出力ストリーム
 *  @param[in] cd 出力する@a ConfigData
 */
std::ostream& operator<<(std::ostream& ost, const ConfigData& cd);



#endif   /*! CONFIG_DATA_HEADER_ */
/*
 * Local Variables:
 * mode: c++
 * c-basic-offset: 4
 * tab-width: 4
 * indent-tabs-mode: t
 * End:
 *
 */
