/*!
 * @file main.cpp
 * @brief main file of MapViewer component
 */ 


#include <signal.h>
#include <rtm/Manager.h>
#include <iostream>
#include <string>
#include <string.h>
#include <errno.h>
#include "mapview_rtc.h"

using namespace std;

/*! このコンポーネントの初期化関数.
 *
 *  @a GlobalNavigationRTCInit を経由して，ファクトリーへの追加，
 *  コンポーネントのインスタンス生成を行う
 *
 *  @param[in] manager RTCのManagerのインスタンス
 */
void MyModuleInit(RTC::Manager* manager)
{
	MapViewRTCInit(manager);
	RTC::RtcBase* comp;

	// Create a component
	comp = manager->createComponent("MapViewRTC");

	return;
}

int main(int argc, char**argv)
{
	cout << "Welcome! This is MapViewer RTC\n";

	cout << "Creating RTC::Manager ... " << flush;
	RTC::Manager* manager = RTC::Manager::init(argc, argv);
	cout << "done.\n";

	cout << "Initialize manager ... " << flush;
	manager->init(argc, argv);
	cout << "done.\n";	

	cout << "Set module initialization proceduer ... " << flush;
	manager->setModuleInitProc(MyModuleInit);
	cout << "done.\n";	

	cout << "Activate manager and register to naming service ... " << flush;
	manager->activateManager();
	cout << "done.\n";	

	cout << "Ok. Let's run the manager in blocking mode ... " << flush;
	manager->runManager();

	cout << "Namárië! Nai hiruvalyë RTC.\n";

	return 0;
}

/*
 * Local Variables:
 * mode: c++
 * c-basic-offset: 4
 * tab-width: 4
 * indent-tabs-mode: t
 * End:
 *
 */
