/*!
 * @file map_layer_delegate.h
 * @brief `Delegate' class of the MapLayerListModel
 * @author SAGAMI, Tsuyoshi <sagami@brains.co.jp>
 */

#ifndef  MAP_LAYER_DELEGATE_HEADER_
#define  MAP_LAYER_DELEGATE_HEADER_

#include <QItemDelegate>
#include <QModelIndex>
#include <QObject>
#include <QSize>
#include <QSpinBox>

/*! @class MapLayerDelegate
 *  @brief 地図レイヤー情報のためのdelegateクラス。
 *  @see Qtのmodel/view/delegateフレームワーク
 * 
 *  Model/Viewの間に入り，@a MapLayerクラスとのデータやり取りと表示の仲立
 *  ちを行う。
 *
 */
class MapLayerDelegate : public QItemDelegate
{
	Q_OBJECT;
public:
	/*! コンストラクタ。visibility, opacity, nameをどの行に表示するかを指定
	 * @param[in] col_visibility visibilityをどの行に表示するか
	 * @param[in] col_opacity opacityをどの行に表示するか
	 * @param[in] col_name nameをどの行に表示するか
	 * @param[in] parent 親オブジェクト
	 */
	MapLayerDelegate(int col_visibility, int col_opacity, int col_name,
					 QObject* parent = 0);

	//! 項目の内容変更のためにエディタを起動する。
	QWidget *createEditor(QWidget *parent,
						  const QStyleOptionViewItem &option,
						  const QModelIndex &index) const;

	//! エディタのデータをセット。
	//! @see QAbstractItemData::setEditorData()
	void setEditorData(QWidget *editor, const QModelIndex &index) const;
	//! モデルのデータをセット。
	//! @see QAbstractItemData::setModelData
	void setModelData(QWidget *editor, QAbstractItemModel *model,
					  const QModelIndex &index) const;

	/*! エディタの大きさをitemに合わせる。
	 * @ee QAbstractItemData::updateEditorGeometry()
	 */
	void updateEditorGeometry(QWidget *editor,
							  const QStyleOptionViewItem &option,
							  const QModelIndex &index) const;
	//! 自身を描画する。
	//! @see QItemDelegate::paint()
	void paint(QPainter* painter,
			   const QStyleOptionViewItem& option,
			   const QModelIndex& index) const;

private:
	const int col_visibility_; //!< visibilityをどの行に表示するか
	const int col_opacity_;    //!< opacityをどの行に表示するか
	const int col_name_;       //!< nameをどの行に表示するか
};
#endif /*MAP_LAYER_DELEGATE_HEADER_*/

/*
 * Local Variables:
 * mode: c++
 * c-basic-offset: 4
 * tab-width: 4
 * indent-tabs-mode: t
 * End:
 *
 */
