/*!
 * @file mapview_rtc.h
 * @brief Class for RTC functionalities. 
 * @author SAGAMI, Tsuyoshi <sagami@brains.co.jp>
 */
#ifndef MAPVIEW_RTC_H
#define MAPVIEW_RTC_H

#include <vector>
#include <rtm/idl/BasicDataTypeSkel.h>
#include <rtm/Manager.h>
#include <rtm/DataFlowComponentBase.h>
#include <rtm/CorbaPort.h>
#include <rtm/DataInPort.h>
#include <rtm/DataOutPort.h>
#include <boost/shared_ptr.hpp>

// Service implementation headers
// <rtc-template block="service_impl_h">

// </rtc-template>

// Service Consumer stub headers
// <rtc-template block="consumer_stub_h">

// </rtc-template>

using namespace RTC;

class MapViewerGUI;

class MapViewRTC  : public RTC::DataFlowComponentBase
{
public:
	/*! コンポーネントのコンストラクタ.
	 *  @param[in] コンポーネントの管理を行うManagerへの参照 
	 */
	MapViewRTC(RTC::Manager* manager);
	~MapViewRTC();				//!< デストラクタ

	//! 初期化時にコールされる.
	virtual RTC::ReturnCode_t onInitialize();
	//! アクティベート後，定期的にコールされる.	
	virtual RTC::ReturnCode_t onExecute(RTC::UniqueId ec_id);
protected:

	//! 入力ポートにバインドされるTimedStringを格納するvector(shared_ptr使用)
	std::vector<boost::shared_ptr<TimedString> > m_ins;
	//! 入力ポートを格納するvector(shared_ptr使用)
	std::vector<boost::shared_ptr<InPort<TimedString> > > m_inIns;

	TimedString m_out;	//!< 出力ポートにバインドされるTimedString
	OutPort<TimedString, NullBuffer> m_outOut; //!< 出力ポート

private:
	std::string conf_filename_;	//!< 設定ファイル名
	boost::shared_ptr<MapViewerGUI> gui_; //!< GUIオブジェクトへのshared_ptr
};


extern "C"
{
	void MapViewRTCInit(RTC::Manager* manager);
};

#endif // MAPVIEW_RTC_H

/*
 * Local Variables:
 * mode: c++
 * c-basic-offset: 4
 * tab-width: 4
 * indent-tabs-mode: t
 * End:
 *
 */
