#ifndef _LOCALIZATION_H__
#define _LOCALIZATION_H__

#include <string>
#include <vector>

#include "xml_serdes.h"

/** ロボットの自己位置・速度
 */
class Localization{
public:
	Localization():
		time(0),
		coordinate(),
		pos_x(0),
		pos_y(0),
		pos_the(0),
		pos_err_x(0),
		pos_err_y(0),
		pos_err_the(0),
		vel_x(0),
		vel_y(0),
		vel_the(0)
	{};

	~Localization(){};

	double time;            ///< 取得時間(s)
	std::string coordinate; ///< 座標系(self or 9)

	float pos_x;            ///< x座標位置(m)
	float pos_y;            ///< y座標位置(m)
	float pos_the;          ///< 向き(rad)

	float pos_err_x;        ///< x座標誤差(m)
	float pos_err_y;        ///< y座標誤差(m)
	float pos_err_the;      ///< 向き誤差(rad)

	float vel_x;            ///< x座標速度(m/s)
	float vel_y;            ///< y座標速度(m/s)
	float vel_the;          ///< 回転速度(rad/s)

	// type名
	static const char TYPE_ID[]; ///< タイプID文字列

	// 送受信メソッド
	/** データをXMLとして書き出す
	 *
	 * @param [out] os 書き出し先ストリーム
	 * @retval 成功時0, 失敗時は負の値を返す
	 */
	int writeToXml(std::ostream& os) const
	{
		return XmlSerDes::writeToXmlSub(os, *this, TYPE_ID);
	}

	/** XMLからデータを読み出し自分自身を更新する
	 *
	 * @param [in] is 読み出し元ストリーム
	 * @retval 成功時0, 失敗時は負の値を返す
	 */
	int readFromXml(std::istream& is)
	{
		return XmlSerDes::readFromXmlSub(is, *this, TYPE_ID);
	}

	/**
	 * \overload int writeToXml(std::string& s) const
	 * @param [out] s 書き出し先文字列
	 */
	int writeToXml(std::string& s) const
	{
		std::ostringstream os(s);
		return writeToXml(os);
	}

	/** XMLからデータを読み出し自分自身を更新する
	 *
	 * \overload int readFromXml(const std::string& s)
	 * @param [in] s 読み出し元文字列
	 */
	int readFromXml(const std::string& s)
	{
		std::istringstream is(s);
		return readFromXml(is);
	}

private:
	// シリアライズメソッド
	friend class boost::serialization::access;
	template <class Archive>
	void serialize(Archive& ar, const unsigned int /* version */){
		using namespace boost::serialization;
		//using namespace XmlSerDes;

		ar & BOOST_SERIALIZATION_NVP(time);
		ar & BOOST_SERIALIZATION_NVP(coordinate);

		ar & BOOST_SERIALIZATION_NVP(pos_x);
		ar & BOOST_SERIALIZATION_NVP(pos_y);
		ar & BOOST_SERIALIZATION_NVP(pos_the);

		ar & BOOST_SERIALIZATION_NVP(pos_err_x);
		ar & BOOST_SERIALIZATION_NVP(pos_err_y);
		ar & BOOST_SERIALIZATION_NVP(pos_err_the);

		ar & BOOST_SERIALIZATION_NVP(vel_x);
		ar & BOOST_SERIALIZATION_NVP(vel_y);
		ar & BOOST_SERIALIZATION_NVP(vel_the);

	};
};

std::ostream& operator<<(std::ostream &os, Localization &loc);

#endif //_LOCALIZATION_H__
