#ifndef  _PATH_H__
#define  _PATH_H__

#include <string>
#include <vector>
#include <iostream>

#include "xml_serdes.h"
#include "navigation_data.h"


struct Point{
public:
	/** コンストラクタ
	 */
	Point():
		x(0.0),
		y(0.0),
		t(0.0)
	{};

	/** コンストラクタ
	 *
	 * @param [in] x x座標位置
	 * @param [in] y y座標位置
	 * @param [in] t 向き
	 */
	Point(float x_, float y_, float t_):
		x(x_),
		y(y_),
		t(t_)
	{};
		
	/** デストラクタ
	 */
	~Point(){};

	float x; ///< X[m]
	float y; ///< y[m]
	float t; ///< the[rad]

private:
	// シリアライズメソッド
	friend class boost::serialization::access;
	template <class Archive>
	void serialize(Archive& ar, const unsigned int /* version */){
		using namespace boost::serialization;

		ar & BOOST_SERIALIZATION_NVP(x);
		ar & BOOST_SERIALIZATION_NVP(y);
		ar & BOOST_SERIALIZATION_NVP(t);
	};
};

/**
 */
struct Node{
public:
	/** コンストラクタ
	 */
	Node():
		node(0.0, 0.0, 0.0),
		vel (0.0, 0.0, 0.0)
	{};

	/** コンストラクタ
	 *
	 * @param [in] x x座標位置
	 * @param [in] y y座標位置
	 * @param [in] t 向き
	 */
	Node(double x, double y, double t):
		node(x,   y,   t  ),
		vel (0.0, 0.0, 0.0)
	{};

	/** デストラクタ
	 */
	~Node(){};

	Point node; ///< 地点
	Point vel;  ///< 速度

private:
	// シリアライズメソッド
#if 1
	friend class boost::serialization::access;
	template <class Archive>
	void serialize(Archive& ar, const unsigned int /* version */){
		using namespace boost::serialization;

		ar & BOOST_SERIALIZATION_NVP(node);
		ar & BOOST_SERIALIZATION_NVP(vel);
	};
#else
	friend class boost::serialization::access;
	BOOST_SERIALIZATION_SPLIT_MEMBER();

	template <class Archive>
	void save(Archive& ar, const unsigned int /* version */) const{
		using namespace boost::serialization;
		std::string data_string;
		std::ostringstream oss;

		oss << "(" << node.x << ", " << node.y << ", " << node.t << "), ";
		oss << "(" << vel.x  << ", " << vel.y  << ", " << vel.t  << ")";

		data_string = oss.str();

		ar & make_nvp("path", data_string);
	}

	template <class Archive>
	void load(Archive& ar, const unsigned int /* version */){
		using namespace boost::serialization;
		char c;
		std::string data_string;
		ar & make_nvp("path", data_string);

		std::istringstream iss(data_string);

		iss >> c >> node.x >> c >> node.y >> c >> node.t >> c >> c;
		iss >> c >> vel.x  >> c >> vel.y  >> c >> vel.t  >> c;
	}
#endif

};

/** 経路情報
 */
struct Path{
public:
	/** コンストラクタ
	 */
	Path():
		time(0.0),
		coordinate(NavData::COORD_JGD9),
		path(0)
	{};

	/** デストラクタ
	 */
	~Path(){};

	double time;            ///< 取得時間(s)
	std::string coordinate; ///< 座標系(self or 9)

	std::vector<Node> path; ///< 地点と速度

	// type名
	static const char TYPE_ID[]; ///< タイプID文字列

	// 送受信メソッド
	/** データをXMLとして書き出す
	 *
	 * @param [out] os 書き出し先ストリーム
	 * @retval 成功時0, 失敗時は負の値を返す
	 */
	int writeToXml(std::ostream& os) const
	{
		return XmlSerDes::writeToXmlSub(os, *this, TYPE_ID);
	}

	/** XMLからデータを読み出し自分自身を更新する
	 *
	 * @param [in] is 読み出し元ストリーム
	 * @retval 成功時0, 失敗時は負の値を返す
	 */
	int readFromXml(std::istream& is)
	{
		return XmlSerDes::readFromXmlSub(is, *this, TYPE_ID);
	}

	/**
	 * \overload int writeToXml(std::string& s) const
	 * @param [out] s 書き出し先文字列
	 */
	int writeToXml(std::string& s) const
	{
		std::ostringstream os(s);
		return writeToXml(os);
	}

	/** XMLからデータを読み出し自分自身を更新する
	 *
	 * \overload int readFromXml(const std::string& s)
	 * @param [in] s 読み出し元文字列
	 */
	int readFromXml(const std::string& s)
	{
		std::istringstream is(s);
		return readFromXml(is);
	}

private:
	// シリアライズメソッド
	friend class boost::serialization::access;
	template <class Archive>
	void serialize(Archive& ar, const unsigned int /* version */){
		using namespace boost::serialization;

		ar & BOOST_SERIALIZATION_NVP(time);
		ar & BOOST_SERIALIZATION_NVP(coordinate);

		ar & BOOST_SERIALIZATION_NVP(path);

	};

};

std::ostream& operator<<(std::ostream &os, Path  &path);
std::ostream& operator<<(std::ostream &os, Node  &node);
std::ostream& operator<<(std::ostream &os, Point &point);

#endif //_PATH_H__
