#ifndef _CONFIG_HANDLER_HPP_
#define _CONFIG_HANDLER_HPP_

#include <xercesc/sax2/DefaultHandler.hpp>
#include <string>
#include <vector>
using namespace std;

class XmlHandler : public xercesc::DefaultHandler {
public:
	void startDocument();
	void startElement(const XMLCh* const uri, const XMLCh* const localname,
                    const XMLCh* const qname, const xercesc::Attributes& attrs);
	void endElement  (const XMLCh* const uri, const XMLCh* const localname,
                    const XMLCh* const qname);

	void characters(const XMLCh* const chars, const unsigned int length);

	string key;
	string attribute;
	vector<string> result;
	bool is_find;
private:
	int flag;
};

bool InitXmlParser(void);
void TerminateXmlParser(void);
bool XmlParser(string filename, string key, string attribute, vector<string> *result);
bool XmlParserForString(string data, string key, string attribute, vector<string> *result);

#endif
