/**
 * @file nes_posix_cond.h
 * @brief condition function interface define
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __NES_POSIX_COND_H_
#define __NES_POSIX_COND_H_

#ifdef NES_SE   /* Use Standard Extension */
#include <tkse/longlong.h>
#include <tkse/seio/sys/time.h>
#else           /* Use PMC Extension */
#include <btron/clk.h>
#include <unix/sys/time.h>
#include <btron/taskcomm.h>
#include <btron/proctask.h>
#endif
#include "nes_posix_pthread.h"

#ifdef __cplusplus
extern "C" {
#endif

struct queue;

/* define condtion varible attribute struct */
typedef struct
{
	int pshared;
	
	/*set the flg of condition can be deleted or not
	 *when value=1;if condition being used by thread,it cann't be deleted
	 *when value=0;if condition being used by thread,it can be deleted
	 */
	int busy_check;
	
} pthread_condattr_t;

/* define condtion varible struct */
typedef struct
{
	int iCond_id;//condition ID
	struct queue* myqueue;//save the taskID and the ptn of flg
	pthread_mutex_t lock;
	
	/*set the flg of condition can be deleted or not
	 *when value=1;if condition being used by thread,it cann't be deleted
	 *when value=0;if condition being used by thread,it can be deleted
	 */
	int busy_check;
	
} pthread_cond_t;

/* Function for handling threads.  */

/* init condtion varible */
IMPORT int nes_posix_pthread_cond_init(pthread_cond_t *cond, pthread_condattr_t *cond_attr);
/* init condtion varible attribute */
IMPORT int nes_posix_pthread_condattr_init(pthread_condattr_t * attr);
/* destoy condtion varible attribute */
IMPORT int nes_posix_pthread_condattr_destroy(pthread_condattr_t *attr);
/* destoy condtion varible */
IMPORT int nes_posix_pthread_cond_destroy(pthread_cond_t *cond);
/* atomatically unlocks the mutex and waits for the condition variable to be signaled */
IMPORT int nes_posix_pthread_cond_wait(pthread_cond_t *cond, pthread_mutex_t *mutex);
/* atomatically unlocks the mutex and waits for the condition variable to be signaled in some time*/
IMPORT int nes_posix_pthread_cond_timedwait(pthread_cond_t *cond, pthread_mutex_t *mutex, const struct timespec *abstime);
/* restarts one of the threads that are waitin on the condition variable */
IMPORT int nes_posix_pthread_cond_signal(pthread_cond_t *cond);
/* restarts all of the threads that are waitin on the condition variable */
IMPORT int nes_posix_pthread_cond_broadcast(pthread_cond_t *cond);

#ifdef __cplusplus
}
#endif

/*
 *Wangjianxiang @ NECsoft(JiNan). 2008/07/10 append
 */
#ifdef __cplusplus
 extern "C" {
#endif

IMPORT int pthread_cond_init(pthread_cond_t *cond, pthread_condattr_t *cond_attr);
IMPORT int pthread_condattr_init(pthread_condattr_t * attr);
IMPORT int pthread_condattr_destroy(pthread_condattr_t *attr);
IMPORT int pthread_cond_destroy(pthread_cond_t *cond);
IMPORT int pthread_cond_wait(pthread_cond_t *cond, pthread_mutex_t *mutex);
IMPORT int pthread_cond_timedwait(pthread_cond_t *cond, pthread_mutex_t *mutex, const struct timespec *abstime);
IMPORT int pthread_cond_signal(pthread_cond_t *cond);
IMPORT int pthread_cond_broadcast(pthread_cond_t *cond);

#ifdef __cplusplus
}
#endif

#endif

