/**
 * @file nes_posix_pipe.h
 * @brief This file is part of the posix library
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __NES_POSIX_PIPE_H__
#define __NES_POSIX_PIPE_H__

#include <typedef.h>

#ifdef __cplusplus
extern "C" { 
#endif
	/* create a pipe */
	IMPORT int nes_posix_pipe(int filedes[2]);

	/* read the data of pipe */
	IMPORT int nes_posix_pread(int flag, int cid, B *buf, int size);

	/* write data to the pipe */
	IMPORT int nes_posix_pwrite(int flag, int cid, B *buf, int size);

	/* delete the pipe */
	IMPORT int nes_posix_delpipe(int fd);

	/* get the pipe from parent process */
	IMPORT int nes_posix_getpipe(void);
#ifdef __cplusplus
} 
#endif
/*
 * Maxiaochen @ NECsoft (JiNan). 2008/07/10 append
*/

#ifdef __cplusplus
extern "C" { 
#endif
IMPORT int pipe(int filedes[2]);

IMPORT int pread(int flag, int cid, B* buf, int size);

IMPORT int pwrite(int flag, int cid, B* buf, int size);

IMPORT int delpipe(int fd);

IMPORT int getpipe(void);

#ifdef __cplusplus
} 
#endif
#endif

