/**
 * @file init_lib.c
 * @define implement of initital function of lib 
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <tkse/extension/proctask.h>

#include "init_lib.h"
#include "common.h"
#include "manager.h"
#include "tsd.h"
#include "once.h"

/*
 *	Debug marco define
 */
#ifdef PTHREAD_DEBUG
#ifdef PTHREAD_DEBUG_LEVEL
unsigned int __g_debug_level = PTHREAD_DEBUG_LEVEL;
#else
unsigned int __g_debug_level = 0;
#endif

#ifdef PTHREAD_DEBUG_MODULE
		irintf("%s:%d %d %d\n", __func__, __LINE__, err, nRet);
unsigned int __g_debug_module = PTHREAD_DEBUG_MODULE;
#else
unsigned int __g_debug_module = 0;
#endif

#endif // PTHREAD_DEBUG

int __g_finish_now = 0;				/* Global finish flag, used when main thread exit  */
extern pthread_t __g_main_thread;		/* manager.c */

/**********************************************************************/
/* Function name: __pthread_lib_init                                  */
/* Description: Init pthread lib, every module need init before use   */
/*              need do it's inital action here, equal Marco          */
/*              PTHREAD_INIT()                                        */
/* Return type: int   return 0 if init ok , else return error code    */
/* Argument - void:                                                   */
/**********************************************************************/
int __pthread_lib_init(void)
{
	int ret = 0;

	DP1(D_MODU_INTER, ("[%u] __pthread_lib_init in ...\n", pthread_self()));

	static int __lib_init_ok = 0;
	if( __lib_init_ok ) { /* Init already */ 
		return 0;
	}       
	__lib_init_ok = 1;
	        
	/* Init thread manager */
	if( (ret = __phread_init()) != 0 ) 
	{
		goto exit;
	}

	/* Init pthread once module */
	if( (ret = __once_init()) != 0 ) 
	{
		goto exit;
	}

	/* Init TSD module */
	if( (ret = __tsd_init()) != 0 ) 
	{
		goto exit;
	}

	/* Added by Wangyage @ NECSoft(JiNan) May 30 2006 */
	__g_main_thread = tkse_get_tid();
	atexit(__pthread_lib_finish);
	/* End added */

exit:
	DP1(D_MODU_INTER, ("[%u] __pthread_lib_init out ... [%u]\n", pthread_self(), ret));
	return ret;
}

/**********************************************************************/
/* Function name: __pthread_lib_finish                                */
/* Description: Init pthread lib, every module need init before use   */
/*              need do it's inital action here, equal Marco          */
/*              PTHREAD_INIT()                                        */
/* Return type: int   return 0 if finish ok , else return error code  */
/* Argument - void:                                                   */
/**********************************************************************/
void __pthread_lib_finish(void)
{
	int ret = 0;

	DP1(D_MODU_INTER, ("[%u] __pthread_lib_finish in ...\n", pthread_self()));

	__g_finish_now = 1;		/* Not permit pthread_exit do finish again */

	/* Finish thread manager */
	ret = __phread_finish();
	
	/* Finish pthread once module */
	ret = __once_finish();

	/* Finish pthread TSD module */
	ret = __tsd_finish();

	DP1(D_MODU_INTER, ("[%u] __pthread_lib_finish out ... [%u]\n", pthread_self(), ret));
	return;
}
