// -*- C++ -*-
/*!
 * @file  BorderShortOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "BorderShortOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* bordershortout_spec[] =
  {
    "implementation_id", "BorderShortOut",
    "type_name",         "BorderShortOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

BorderShortOut::BorderShortOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_ShortDataOut("ShortData", m_ShortData)

    // </rtc-template>
{
}

BorderShortOut::~BorderShortOut()
{
}


RTC::ReturnCode_t BorderShortOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("ShortData", m_ShortDataOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t BorderShortOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderShortOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderShortOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderShortOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderShortOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t BorderShortOut::onExecute(RTC::UniqueId ec_id)
{
  //TimedShort
  m_ShortData.data = -32768;
#ifndef __T_KERNEL__
  m_ShortDataOut.write();
#endif
  
  printf("TimedShort write\n");
  printf("TimedShort %d\n", m_ShortData.data);

#ifdef __T_KERNEL__
  m_ShortDataOut.write();
  sleep(3);
#endif
  
  m_ShortData.data = 32767;
#ifndef __T_KERNEL__
  m_ShortDataOut.write();
#endif
  
  printf("TimedShort write\n");
  printf("TimedShort %d\n", m_ShortData.data);
  
#ifdef __T_KERNEL__
  m_ShortDataOut.write();
  sleep(3);
#endif

  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t BorderShortOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderShortOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderShortOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderShortOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderShortOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void BorderShortOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(bordershortout_spec);
    manager->registerFactory(profile,
                             RTC::Create<BorderShortOut>,
                             RTC::Delete<BorderShortOut>);
  }
  
};



