// -*- C++ -*-
/*!
 * @file  MemleakStringIn.cpp * @brief InPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "MemleakStringIn.h"

// Module specification
// <rtc-template block="module_spec">
static const char* memleakstringin_spec[] =
  {
    "implementation_id", "MemleakStringIn",
    "type_name",         "MemleakStringIn",
    "description",       "InPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

MemleakStringIn::MemleakStringIn(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_dataIn("data", m_data)

    // </rtc-template>
{
#ifdef __T_KERNEL__
  m_stringCnt = 0;
#endif
}

MemleakStringIn::~MemleakStringIn()
{
}


RTC::ReturnCode_t MemleakStringIn::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  addInPort("data", m_dataIn);

  // Set OutPort buffer

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t MemleakStringIn::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakStringIn::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakStringIn::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakStringIn::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakStringIn::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t MemleakStringIn::onExecute(RTC::UniqueId ec_id)
{
  if( m_dataIn.isNew() )
  {
    m_dataIn.read();
#ifdef __T_KERNEL__
    m_stringCnt++;
    if(m_stringCnt > 100)
    {
      printf("TimedString %s\n", m_data.data);
      m_stringCnt = 0;
    }
#else
    printf("TimedString %s\n", m_data.data);
#endif    
  }
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t MemleakStringIn::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakStringIn::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakStringIn::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakStringIn::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakStringIn::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void MemleakStringInInit(RTC::Manager* manager)
  {
    coil::Properties profile(memleakstringin_spec);
    manager->registerFactory(profile,
                             RTC::Create<MemleakStringIn>,
                             RTC::Delete<MemleakStringIn>);
  }
  
};



