// -*- C++ -*-
/*!
 * @file  Process.h
 * @brief Process handling functions
 * @date  $Date$
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2010
 *     Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

#ifndef COIL_PROCESS_H
#define COIL_PROCESS_H

#include <stdlib.h>
#ifdef __T_KERNEL__
#include <tstring.h>
#include <btron/file.h>
#include <btron/message.h>
#include <btron/proctask.h>
#include <nes_posix_signal.h>
#else
#include <unistd.h>
#include <libgen.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#endif
#include <coil/stringutil.h>

namespace coil
{

  /*!
   * @if jp
   * @brief ץư
   * @else
   * @brief Launching a process
   * @endif
   */
  int launch_shell(std::string command)
  {
    signal(SIGCHLD, SIG_IGN);

#ifdef __T_KERNEL__
#ifdef DEBUG_T_KERNEL
    printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
    WERR er = 0;

    char* cfile = NULL;
    char cfilepath[ L_PATHNM ];
    char* coption = NULL;

    char ctmp[ L_PATHNM ];
    TC tctmp[ L_PATHNM ];

    LINK lnk;
    MESSAGE msg;

    // commandβ
    memset(ctmp, 0, sizeof(ctmp));
    strcpy(ctmp, command.c_str());

    coption = ctmp ;

    // оݥեΥ󥯼
    cfile = strtok(ctmp, " ");
    if( cfile == NULL ) return -1;

    memset( cfilepath, 0 , sizeof(cfilepath)); 
    sprintf(cfilepath, "/SYS/%s", cfile);

    eucstotcs( tctmp , (const UB *)cfilepath );

    er = b_get_lnk( tctmp, &lnk, F_NORM);
    if( er < 0 ) return -1;

    // ץ
    coption += strlen(cfile) + 1;
    memset(&msg, 0, sizeof(MESSAGE));

    if( *coption )
    {
      strcpy( (char*)msg.msg_body.ANYMSG.msg_str, coption );
      msg.msg_size = MSGSIZE( strlen(coption) + 1);
    }

    // ץ/¹
    er = b_cre_prc( &lnk, -1, &msg );
    if( er >= 0 ) return -1;

#ifdef DEBUG_T_KERNEL
    printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
    return 0;
#else
    pid_t pid;
    if((pid = fork()) < 0 )
      { // fork failed
        return -1; 
      }
    
    if (pid == 0) // I'm child process
      {
        //        signal(SIGCHLD, SIG_IGN);
        //        signal(SIGALRM, SIG_IGN);
        //        signal(SIGHUP , SIG_IGN);
        //        signal(SIGPIPE, SIG_IGN);
        //        signal(SIGTERM, SIG_IGN);
        setsid();
        //        close(0);
        //        close(1);
        //        close(2);
        //        open("/dev/null", O_RDWR);
        //        dup2(0, 1);
        //        dup2(0, 2);
        //        umask(0);

        coil::vstring vstr(::coil::split(command, " "));
        char* const * argv = ::coil::toArgv(vstr);

        execvp(vstr.front().c_str(), argv);

        return -1;
      }
    return 0;
#endif        
  }

  int daemon(int nochdir, int noclose)
  {
    return daemon(nochdir, noclose);
  }


}; // namespace coil
#endif // COIL_PROCESS_H
