/*
 * Decompiled with CFR 0.152.
 */
package minicmds.controller;

import java.io.FileNotFoundException;
import java.io.IOException;
import minicmds.exception.AppException;
import minicmds.model.CellPointer;
import minicmds.model.ExcelDoc;
import minicmds.model.ExcelGrepArgument;
import minicmds.model.SearchCondition;
import minicmds.view.ExcelGrepReport;

public class ExcelGrepController {
    private static final String PROGRAM_NAME = "ExcelGrep";
    private ExcelGrepArgument argument = new ExcelGrepArgument();
    private ExcelGrepReport report;

    public void run(String[] args) throws FileNotFoundException, IOException, AppException {
        try {
            this.argument.set(args);
        }
        catch (AppException e) {
            System.out.println(e.getMessage());
            this.argument.printUsage(this.getClass().getSimpleName());
            return;
        }
        if (this.argument.isVersionFlag()) {
            System.out.println("Version 0.1");
        } else if (this.argument.isHelpFlag()) {
            this.argument.printUsage(PROGRAM_NAME);
        } else {
            this.report = new ExcelGrepReport(this.argument);
            String[] path = this.argument.getPathArray();
            for (int i = 0; i < path.length; ++i) {
                ExcelDoc doc = new ExcelDoc(path[i]);
                doc.read();
                SearchCondition searchCondition = new SearchCondition(this.argument.getPattern(), doc);
                searchCondition.run();
                CellPointer[] cellArray = searchCondition.getCellList();
                this.report.print(cellArray);
            }
        }
    }
}

