/*
 * Decompiled with CFR 0.152.
 */
package minicmds.controller;

import java.io.FileNotFoundException;
import java.io.IOException;
import minicmds.exception.AppException;
import minicmds.model.ExcelDoc;
import minicmds.model.ExcelToTextArgument;
import minicmds.view.ExcelToTextReport;

public class ExcelToTextController {
    private static final String PROGRAM_NAME = "ExcelToText";
    private ExcelToTextArgument argument = new ExcelToTextArgument();
    private ExcelToTextReport report;

    public void run(String[] args) throws FileNotFoundException, IOException {
        try {
            boolean parseFlag = this.parseArgument(args);
            if (!parseFlag) {
                return;
            }
            if (this.argument.isVersionFlag()) {
                System.out.println("Version 0.1");
            } else if (this.argument.getInFileArray().length == 0) {
                this.argument.printUsage(PROGRAM_NAME);
            } else {
                this.convertAllFile();
            }
        }
        catch (AppException e) {
            System.err.println("\u30b7\u30b9\u30c6\u30e0\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
            System.err.println("\u3082\u3046\u4e00\u5ea6\u3001\u59cb\u3081\u304b\u3089\u3084\u308a\u76f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
    }

    private boolean parseArgument(String[] args) throws AppException {
        try {
            this.argument.set(args);
            return true;
        }
        catch (AppException e) {
            System.err.println("\u5f15\u6570\u304c\u9593\u9055\u3063\u3066\u3044\u307e\u3059\u3002");
            return false;
        }
    }

    private void convertAllFile() {
        this.report = new ExcelToTextReport(this.argument);
        String[] fileArray = this.argument.getInFileArray();
        for (int i = 0; i < fileArray.length; ++i) {
            this.convertOneFile(fileArray[i]);
        }
    }

    private void convertOneFile(String fileName) {
        ExcelDoc doc = new ExcelDoc(fileName);
        try {
            doc.read();
        }
        catch (FileNotFoundException e) {
            System.err.println(fileName + "\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
            return;
        }
        catch (IOException e) {
            System.err.println(fileName + "\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return;
        }
        this.report.print(doc);
    }
}

