/*
 * Decompiled with CFR 0.152.
 */
package minicmds.diff;

import java.io.PrintStream;
import java.util.List;
import minicmds.diff.Document;
import org.incava.util.diff.Difference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffWriter {
    private static final String TYPE_DEL = "d";
    private static final String TYPE_ADD = "a";
    private static final String TYPE_CHANGE = "c";
    private static final String PREFIX_DEL = "< ";
    private static final String PREFIX_ADD = "> ";
    private static final String SEP = "---";

    public void printDiffList(PrintStream ps, Document before, Document after, List<Difference> diffList) {
        for (Difference diff : diffList) {
            int delStart = diff.getDeletedStart();
            int delEnd = diff.getDeletedEnd();
            int addStart = diff.getAddedStart();
            int addEnd = diff.getAddedEnd();
            String type = delEnd != -1 ? (addEnd != -1 ? TYPE_CHANGE : TYPE_DEL) : TYPE_ADD;
            ps.print(this.getRange(before, delStart, delEnd));
            ps.print(type);
            ps.print(this.getRange(after, addStart, addEnd));
            ps.println();
            if (delEnd != -1) {
                this.printText(ps, before, PREFIX_DEL, delStart, delEnd);
            }
            if (delEnd != -1 && addEnd != -1) {
                ps.println(SEP);
            }
            if (addEnd == -1) continue;
            this.printText(ps, after, PREFIX_ADD, addStart, addEnd);
        }
    }

    private String getRange(Document doc, int start, int end) {
        StringBuffer sb = new StringBuffer();
        if (end == -1) {
            sb.append(this.getPosition(doc, start - 1));
        } else {
            sb.append(this.getPosition(doc, start));
            if (start != end) {
                sb.append("," + this.getPosition(doc, end));
            }
        }
        return sb.toString();
    }

    private String getPosition(Document doc, int index) {
        StringBuffer sb = new StringBuffer();
        if (doc.getType() == Document.Type.EXCEL) {
            if (index < 0) {
                sb.append(doc.getSheetName(0));
                sb.append("-0-0");
            } else {
                sb.append(doc.getSheetName(index));
                sb.append("-");
                sb.append(doc.getRow(index) + 1);
                sb.append("-");
                sb.append(doc.getColumn(index) + 1);
            }
        } else {
            sb.append(index + 1);
        }
        return sb.toString();
    }

    private void printText(PrintStream ps, Document doc, String prefix, int start, int end) {
        for (int i = start; i <= end; ++i) {
            ps.println(prefix + doc.get(i));
        }
    }
}

