/*
 * Decompiled with CFR 0.152.
 */
package minicmds.diff;

import java.io.FileInputStream;
import java.io.IOException;
import minicmds.diff.Document;
import minicmds.diff.Reader;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ExcelReader
extends Reader {
    public Document read(String path) throws IOException {
        FileInputStream is = new FileInputStream(path);
        POIFSFileSystem fs = new POIFSFileSystem(is);
        HSSFWorkbook book = new HSSFWorkbook(fs);
        Document doc = new Document(Document.Type.EXCEL);
        int sheet = 0;
        int row = 0;
        short column = 0;
        try {
            int numSheet = book.getNumberOfSheets();
            for (sheet = 0; sheet < numSheet; ++sheet) {
                HSSFSheet sheetHandler = book.getSheetAt(sheet);
                String sheetName = book.getSheetName(sheet);
                int rowNum = sheetHandler.getLastRowNum();
                if (sheetHandler.getRow(0) == null) {
                    rowNum = -1;
                }
                for (row = 0; row <= rowNum; ++row) {
                    HSSFRow hssfrow = sheetHandler.getRow(row);
                    short columnNum = hssfrow.getLastCellNum();
                    for (column = 0; column < columnNum; column = (short)(column + 1)) {
                        HSSFRichTextString cellvalue;
                        String value = "";
                        HSSFCell hssfcell = hssfrow.getCell(column);
                        if (hssfcell != null && (cellvalue = hssfcell.getRichStringCellValue()) != null) {
                            value = cellvalue.getString();
                        }
                        doc.add(sheetName, row, column, value);
                    }
                }
            }
        }
        catch (RuntimeException e) {
            System.err.println("Excel\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc\uff1apath=[" + path + "],sheet=" + sheet + ",row=" + row + ",column=" + column);
            e.printStackTrace();
            throw e;
        }
        return doc;
    }
}

