/*
 * Decompiled with CFR 0.152.
 */
package minicmds.model;

import java.util.ArrayList;
import java.util.Arrays;
import minicmds.exception.AppException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class ExcelGrepArgument {
    private static final String HELP_CHAR = "h";
    private static final String HELP_LONG = "help";
    private static final String LINE_NUMBER_CHAR = "n";
    private static final String RECURSIVE_CHAR = "r";
    private static final String VERSION_CHAR = "V";
    private CommandLine cmd = null;
    private CommandLineParser parser = new PosixParser();
    private Options options = new Options();
    private String pattern;
    private String[] pathArray;

    public ExcelGrepArgument() {
        Option helpFlag = new Option(HELP_CHAR, HELP_LONG, false, "\u4f7f\u7528\u65b9\u6cd5\u3092\u8868\u793a\u3057\u307e\u3059\u3002");
        Option lineNumberFlag = new Option(LINE_NUMBER_CHAR, "line-number", false, "\u5404\u51fa\u529b\u884c\u306e\u524d\u306b\u3001\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306b\u304a\u3051\u308b\u884c\u756a\u53f7\u3092\u8868\u793a\u3057\u307e\u3059\u3002");
        Option recursiveFlag = new Option(RECURSIVE_CHAR, "recursive", false, "\u5404\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4e0b\u306e\u3059\u3079\u3066\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u518d\u5e30\u7684\u306b\u8aad\u307f\u53d6\u308a\u307e\u3059\u3002");
        Option versionFlag = new Option(VERSION_CHAR, "version", false, "\u30d0\u30fc\u30b8\u30e7\u30f3\u756a\u53f7\u3092\u8868\u793a\u3057\u307e\u3059\u3002");
        this.options.addOption(helpFlag);
        this.options.addOption(lineNumberFlag);
        this.options.addOption(recursiveFlag);
        this.options.addOption(versionFlag);
    }

    public void printUsage(String programName) {
        HelpFormatter help = new HelpFormatter();
        help.printHelp(programName + " [\u30aa\u30d7\u30b7\u30e7\u30f3] \u30d1\u30bf\u30fc\u30f3 \u30d5\u30a1\u30a4\u30eb ...", "\u30aa\u30d7\u30b7\u30e7\u30f3\u5f15\u6570", this.options, "", false);
        System.out.println("\u5fc5\u9808\u5f15\u6570");
        System.out.println(" \u30d1\u30bf\u30fc\u30f3           \u56fa\u5b9a\u6587\u5b57\u5217\u3002\u30ef\u30a4\u30eb\u30c9\u30ab\u30fc\u30c9\u3084\u6b63\u898f\u8868\u73fe\u306f\u4e0d\u53ef\u3002");
        System.out.println(" \u30d5\u30a1\u30a4\u30eb           \u30d5\u30a1\u30a4\u30eb");
    }

    public void set(String[] argArray) throws AppException {
        ArrayList<String> pathList = new ArrayList<String>();
        try {
            this.cmd = this.parser.parse(this.options, argArray);
        }
        catch (ParseException e) {
            throw new AppException("\u5f15\u6570=" + Arrays.toString(argArray), e);
        }
        for (int i = 0; i < this.cmd.getArgs().length; ++i) {
            String arg = this.cmd.getArgs()[i];
            if (this.pattern == null) {
                this.pattern = arg;
                continue;
            }
            pathList.add(arg);
        }
        this.pathArray = new String[pathList.size()];
        pathList.toArray(this.pathArray);
    }

    public String getPattern() {
        return this.pattern;
    }

    public String[] getPathArray() {
        return this.pathArray;
    }

    public boolean isHelpFlag() {
        if (this.cmd.hasOption(HELP_CHAR)) {
            return true;
        }
        return this.cmd.getArgList().size() == 0;
    }

    public boolean isLineNumberFlag() {
        return this.cmd.hasOption(LINE_NUMBER_CHAR);
    }

    public boolean isVersionFlag() {
        return this.cmd.hasOption(VERSION_CHAR);
    }
}

