/*
 * Decompiled with CFR 0.152.
 */
package minicmds.model;

import java.util.Arrays;
import minicmds.exception.AppException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class ExcelToTextArgument {
    private static final String HELP_CHAR = "h";
    private static final String HELP_LONG = "help";
    private static final String LINE_NUMBER_CHAR = "n";
    private static final String LINE_NUMBER_LONG = "line-number";
    private static final String VERSION_CHAR = "V";
    private static final String VERSION_LONG = "version";
    private CommandLine cmd = null;
    private CommandLineParser parser = new PosixParser();
    private Options options = new Options();
    private String[] inFileArray;

    public ExcelToTextArgument() {
        Option helpFlag = new Option(HELP_CHAR, HELP_LONG, false, "\u4f7f\u7528\u65b9\u6cd5\u3092\u8868\u793a\u3057\u307e\u3059\u3002");
        Option lineNumberFlag = new Option(LINE_NUMBER_CHAR, LINE_NUMBER_LONG, false, "\u5404\u51fa\u529b\u884c\u306e\u524d\u306b\u3001\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306b\u304a\u3051\u308b\u884c\u756a\u53f7\u3092\u8868\u793a\u3057\u307e\u3059\u3002");
        Option versionFlag = new Option(VERSION_CHAR, VERSION_LONG, false, "\u30d0\u30fc\u30b8\u30e7\u30f3\u756a\u53f7\u3092\u8868\u793a\u3057\u307e\u3059\u3002");
        this.options.addOption(helpFlag);
        this.options.addOption(lineNumberFlag);
        this.options.addOption(versionFlag);
    }

    public void printUsage(String programName) {
        HelpFormatter help = new HelpFormatter();
        help.printHelp(programName + " [\u30aa\u30d7\u30b7\u30e7\u30f3] \u30d5\u30a1\u30a4\u30eb ...", "\u30aa\u30d7\u30b7\u30e7\u30f3\u5f15\u6570", this.options, "", false);
        System.out.println("\u5fc5\u9808\u5f15\u6570");
        System.out.println(" \u30d5\u30a1\u30a4\u30eb");
    }

    public void set(String[] args) throws AppException {
        try {
            this.cmd = this.parser.parse(this.options, args);
        }
        catch (ParseException e) {
            throw new AppException("\u5f15\u6570=" + Arrays.toString(args), e);
        }
        this.inFileArray = this.cmd.getArgs();
    }

    public String[] getInFileArray() {
        return (String[])this.inFileArray.clone();
    }

    public boolean isHelpFlag() {
        return this.cmd.hasOption(HELP_CHAR);
    }

    public boolean isLineNumberFlag() {
        return this.cmd.hasOption(LINE_NUMBER_CHAR);
    }

    public boolean isVersionFlag() {
        return this.cmd.hasOption(VERSION_CHAR);
    }
}

