/*
 * Decompiled with CFR 0.152.
 */
package minicmds.model;

import java.util.ArrayList;
import minicmds.exception.AppException;
import minicmds.model.CellPointer;
import minicmds.model.Document;

public class SearchCondition {
    private String pattern;
    private Document document;
    private CellPointer[] cellArray;

    public SearchCondition(String pattern, Document document) throws AppException {
        if (pattern == null || document == null) {
            throw new AppException("\u5f15\u6570\u30a8\u30e9\u30fc pattern=" + pattern + ",document=" + document);
        }
        this.pattern = pattern;
        this.document = document;
    }

    public void run() {
        ArrayList<CellPointer> cellList = new ArrayList<CellPointer>();
        int sheetSize = this.document.getSheetSize();
        for (int sheetCount = 0; sheetCount < sheetSize; ++sheetCount) {
            int rowSize = this.document.getRowSize(sheetCount);
            for (int rowCount = 0; rowCount < rowSize; ++rowCount) {
                int columnSize = this.document.getColumnSize(sheetCount, rowCount);
                for (int columnCount = 0; columnCount < columnSize; ++columnCount) {
                    String value = this.document.getCell(sheetCount, rowCount, columnCount);
                    if (value.indexOf(this.pattern) < 0) continue;
                    CellPointer cell = new CellPointer(this.document, sheetCount, rowCount, columnCount);
                    cellList.add(cell);
                }
            }
        }
        this.cellArray = new CellPointer[cellList.size()];
        cellList.toArray(this.cellArray);
    }

    public CellPointer[] getCellList() {
        return this.cellArray;
    }
}

