
#include "RxNumeric.h"

RxNumeric::RxNumeric()
	: RxObject(INT2FIX(0))
{
}

RxNumeric::RxNumeric(RxObject& Object)
	: RxObject(Object)
{
}

RxNumeric::RxNumeric(int value)
	: RxObject(INT2NUM(value))
{
}

RxNumeric::RxNumeric(signed long value)
	: RxObject(UINT2NUM(value))
{
}

RxNumeric::RxNumeric(unsigned long value)
	: RxObject(INT2NUM(value))
{
}

RxNumeric::RxNumeric(float value)
	: RxObject(::rb_float_new((double)value))
{
}

RxNumeric::RxNumeric(double value)
	: RxObject(::rb_float_new(value))
{
}

RxNumeric::~RxNumeric()
{
}


RxNumeric RxNumeric::operator+(int value) const    { return *this + RxNumeric(value); }
RxNumeric RxNumeric::operator+(long value) const   { return *this + RxNumeric(value); }
RxNumeric RxNumeric::operator+(float value) const  { return *this + RxNumeric(value); }
RxNumeric RxNumeric::operator+(double value) const { return *this + RxNumeric(value); }

RxNumeric
RxNumeric::operator+(RxNumeric& value) const
{
	static RxID method("+");
	return send(method, value);
}

RxNumeric RxNumeric::operator-(int value) const    { return *this - RxNumeric(value); }
RxNumeric RxNumeric::operator-(long value) const   { return *this - RxNumeric(value); }
RxNumeric RxNumeric::operator-(float value) const  { return *this - RxNumeric(value); }
RxNumeric RxNumeric::operator-(double value) const { return *this - RxNumeric(value); }

RxNumeric
RxNumeric::operator-(RxNumeric& value) const
{
	static RxID method("-");
	return send(method, value);
}

RxNumeric RxNumeric::operator*(int value) const    { return *this * RxNumeric(value); }
RxNumeric RxNumeric::operator*(long value) const   { return *this * RxNumeric(value); }
RxNumeric RxNumeric::operator*(float value) const  { return *this * RxNumeric(value); }
RxNumeric RxNumeric::operator*(double value) const { return *this * RxNumeric(value); }

RxNumeric
RxNumeric::operator*(RxNumeric& value) const
{
	static RxID method("*");
	return send(method, value);
}

RxNumeric RxNumeric::operator/(int value) const    { return *this / RxNumeric(value); }
RxNumeric RxNumeric::operator/(long value) const   { return *this / RxNumeric(value); }
RxNumeric RxNumeric::operator/(float value) const  { return *this / RxNumeric(value); }
RxNumeric RxNumeric::operator/(double value) const { return *this / RxNumeric(value); }

RxNumeric
RxNumeric::operator/(RxNumeric& value) const
{
	static RxID method("/");
	return send(method, value);
}

RxNumeric RxNumeric::operator%(int value) const    { return *this % RxNumeric(value); }
RxNumeric RxNumeric::operator%(long value) const   { return *this % RxNumeric(value); }
RxNumeric RxNumeric::operator%(float value) const  { return *this % RxNumeric(value); }
RxNumeric RxNumeric::operator%(double value) const { return *this % RxNumeric(value); }

RxNumeric
RxNumeric::operator%(RxNumeric& value) const
{
	static RxID method("%");
	return send(method, value);
}


RxString
RxNumeric::to_s() const
{
	static RxID method("to_s");
	return send(method);
}

RxNumeric
RxNumeric::to_i() const
{
	static RxID method("to_i");
	return send(method);
}

RxNumeric
RxNumeric::to_f() const
{
	static RxID method("to_f");
	return send(method);
}
