// $Id: RxNumeric.h,v 1.6 2002/08/16 07:15:11 yuya Exp $

#if !defined(AFX_RXNUMERIC_H__8842BA19_73EC_4DE4_BD3C_28E5BED53E70__INCLUDED_)
#define AFX_RXNUMERIC_H__8842BA19_73EC_4DE4_BD3C_28E5BED53E70__INCLUDED_

#include "rubyxx/RxBase.h"
#include "rubyxx/RxObject.h"
#include "rubyxx/RxString.h"

class RxNumeric : public RxObject
{

public:
	RxNumeric();
	RxNumeric(RxObject& obj);
	RxNumeric(int value);
	RxNumeric(signed long value);
	RxNumeric(unsigned long value);
	RxNumeric(float value);
	RxNumeric(double value);
	virtual ~RxNumeric();

public:
	virtual RxNumeric operator+(int value) const;
	virtual RxNumeric operator+(long value) const;
	virtual RxNumeric operator+(float value) const;
	virtual RxNumeric operator+(double value) const;
	virtual RxNumeric operator+(RxNumeric& value) const;

	virtual RxNumeric operator-(int value) const;
	virtual RxNumeric operator-(long value) const;
	virtual RxNumeric operator-(float value) const;
	virtual RxNumeric operator-(double value) const;
	virtual RxNumeric operator-(RxNumeric& value) const;

	virtual RxNumeric operator*(int value) const;
	virtual RxNumeric operator*(long value) const;
	virtual RxNumeric operator*(float value) const;
	virtual RxNumeric operator*(double value) const;
	virtual RxNumeric operator*(RxNumeric& value) const;

	virtual RxNumeric operator/(int value) const;
	virtual RxNumeric operator/(long value) const;
	virtual RxNumeric operator/(float value) const;
	virtual RxNumeric operator/(double value) const;
	virtual RxNumeric operator/(RxNumeric& value) const;

	virtual RxNumeric operator%(int value) const;
	virtual RxNumeric operator%(long value) const;
	virtual RxNumeric operator%(float value) const;
	virtual RxNumeric operator%(double value) const;
	virtual RxNumeric operator%(RxNumeric& value) const;

public:
	virtual RxNumeric to_i() const;
	virtual RxNumeric to_f() const;

};

#endif
