// $Id: RxArray.cpp,v 1.11 2002/08/18 15:35:44 yuya Exp $

#include "rubyxx/RxArray.h"

////////////////////////////////////////////////////////////////////////////////

RxArray::RxArray()
	: RxObject(::rb_ary_new())
{
}

RxArray::RxArray(RxObject& obj)
	: RxObject(obj)
{
}

RxArray::RxArray(int n, ...)
	: RxObject(::rb_ary_new2(n))
{
    va_list ar;

	va_start(ar, n);

	for ( int i = 0; i < n; i++ ) {
		(*this)[i] = va_arg(ar, RxObject);
	}

	va_end(ar);
}

RxArray::~RxArray()
{
}

////////////////////////////////////////////////////////////////////////////////

RxObject
RxArray::operator[](int idx) const
{
	return (*this)[RxNumeric(idx)];
}

RxObject
RxArray::operator[](RxObject idx) const
{
	return send("[]", idx);
}


RxObject
RxArray::assoc(RxObject key) const
{
	return send("assoc", key);
}

RxObject
RxArray::at(RxObject pos) const
{
	return send("at", pos);
}

RxObject
RxArray::clear() const
{
	return send("clear");
}

RxObject
RxArray::collect_() const
{
	return send("collect!");
}

RxObject
RxArray::compact() const
{
	return send("compact");
}

RxObject
RxArray::compact_() const
{
	return send("compact!");
}

RxObject
RxArray::concat(RxObject other) const
{
	return send("concat", other);
}

RxObject
RxArray::delete_(RxObject val) const
{
	return send("delete", val);
}

RxObject
RxArray::delete_at(RxObject pos) const
{
	return send("delete_at", pos);
}

RxObject
RxArray::delete_if() const
{
	return send("delete_if");
}

RxObject
RxArray::each() const
{
	return send("each");
}

RxObject
RxArray::each_index() const
{
	return send("each_index");
}

RxObject
RxArray::empty_() const
{
	return send("empty?");
}

RxObject
RxArray::fill(RxObject val) const
{
	return send("fill");
}

RxObject
RxArray::filter() const
{
	return send("filter");
}

RxObject
RxArray::first() const
{
	return send("first");
}

RxObject
RxArray::flatten() const
{
	return send("flatten");
}

RxObject
RxArray::flatten_() const
{
	return send("flatten!");
}

RxObject
RxArray::index(RxObject val) const
{
	return send("index", val);
}

RxObject
RxArray::indexes(RxObject index) const
{
	return send("indexes", index);
}

RxObject
RxArray::indices(RxObject index) const
{
	return send("indices", index);
}

RxObject
RxArray::join(RxObject sep) const
{
	return send("join", sep);
}

RxObject
RxArray::last() const
{
	return send("last");
}

RxObject
RxArray::length() const
{
	return send("length");
}

RxObject
RxArray::map_() const
{
	return send("map!");
}

RxObject
RxArray::nitems() const
{
	return send("nitems");
}

RxObject
RxArray::pack(RxObject template_) const
{
	return send("pack", template_);
}

RxObject
RxArray::pop() const
{
	return RxObject(::rb_ary_pop(m_vObject));
}

RxObject
RxArray::push(RxObject obj) const
{
	return RxObject(::rb_ary_push(m_vObject, obj.value()));
}

RxObject
RxArray::rassoc(RxObject obj) const
{
	return send("rassoc", obj);
}

RxObject
RxArray::reject_() const
{
	return send("reject!");
}

RxObject
RxArray::replace(RxObject another) const
{
	return send("replace", another);
}

RxObject
RxArray::reverse() const
{
	return send("reverse");
}

RxObject
RxArray::reverse_() const
{
	return send("reverse!");
}

RxObject
RxArray::reverse_each() const
{
	return send("reverse_each");
}

RxObject
RxArray::rindex(RxObject val) const
{
	return send("rindex", val);
}

RxObject
RxArray::shift() const
{
	return send("shift");
}

RxObject
RxArray::size() const
{
	return send("size");
}

RxObject
RxArray::slice(RxObject range) const
{
	return send("slice", range);
}

RxObject
RxArray::slice_(RxObject range) const
{
	return send("slice!", range);
}

RxObject
RxArray::sort_() const
{
	return send("sort!");
}

RxObject
RxArray::to_ary() const
{
	return send("to_ary");
}

RxObject
RxArray::uniq() const
{
	return send("uniq");
}

RxObject
RxArray::uniq_() const
{
	return send("uniq!");
}

RxObject
RxArray::unshift(RxObject obj) const
{
	return send("unshift", obj);
}

////////////////////////////////////////////////////////////////////////////////
