// $Id: RxNumeric.cpp,v 1.8 2002/08/18 15:35:44 yuya Exp $

#include "rubyxx/RxNumeric.h"

////////////////////////////////////////////////////////////////////////////////

RxNumeric::RxNumeric()
	: RxObject(INT2FIX(0))
{
}

RxNumeric::RxNumeric(RxObject& obj)
	: RxObject(obj)
{
}

RxNumeric::RxNumeric(int value)
	: RxObject(INT2NUM(value))
{
}

RxNumeric::RxNumeric(signed long value)
	: RxObject(UINT2NUM(value))
{
}

RxNumeric::RxNumeric(unsigned long value)
	: RxObject(INT2NUM(value))
{
}

RxNumeric::RxNumeric(float value)
	: RxObject(::rb_float_new((double)value))
{
}

RxNumeric::RxNumeric(double value)
	: RxObject(::rb_float_new(value))
{
}

RxNumeric::~RxNumeric()
{
}

////////////////////////////////////////////////////////////////////////////////

RxNumeric RxNumeric::operator+(int value) const    { return *this + RxNumeric(value); }
RxNumeric RxNumeric::operator+(long value) const   { return *this + RxNumeric(value); }
RxNumeric RxNumeric::operator+(float value) const  { return *this + RxNumeric(value); }
RxNumeric RxNumeric::operator+(double value) const { return *this + RxNumeric(value); }

RxNumeric
RxNumeric::operator+(RxNumeric& value) const
{
	return send("+", value);
}

RxNumeric RxNumeric::operator-(int value) const    { return *this - RxNumeric(value); }
RxNumeric RxNumeric::operator-(long value) const   { return *this - RxNumeric(value); }
RxNumeric RxNumeric::operator-(float value) const  { return *this - RxNumeric(value); }
RxNumeric RxNumeric::operator-(double value) const { return *this - RxNumeric(value); }

RxNumeric
RxNumeric::operator-(RxNumeric& value) const
{
	return send("-", value);
}

RxNumeric RxNumeric::operator*(int value) const    { return *this * RxNumeric(value); }
RxNumeric RxNumeric::operator*(long value) const   { return *this * RxNumeric(value); }
RxNumeric RxNumeric::operator*(float value) const  { return *this * RxNumeric(value); }
RxNumeric RxNumeric::operator*(double value) const { return *this * RxNumeric(value); }

RxNumeric
RxNumeric::operator*(RxNumeric& value) const
{
	return send("*", value);
}

RxNumeric RxNumeric::operator/(int value) const    { return *this / RxNumeric(value); }
RxNumeric RxNumeric::operator/(long value) const   { return *this / RxNumeric(value); }
RxNumeric RxNumeric::operator/(float value) const  { return *this / RxNumeric(value); }
RxNumeric RxNumeric::operator/(double value) const { return *this / RxNumeric(value); }

RxNumeric
RxNumeric::operator/(RxNumeric& value) const
{
	return send("/", value);
}

RxNumeric RxNumeric::operator%(int value) const    { return *this % RxNumeric(value); }
RxNumeric RxNumeric::operator%(long value) const   { return *this % RxNumeric(value); }
RxNumeric RxNumeric::operator%(float value) const  { return *this % RxNumeric(value); }
RxNumeric RxNumeric::operator%(double value) const { return *this % RxNumeric(value); }

RxNumeric
RxNumeric::operator%(RxNumeric& value) const
{
	return send("%", value);
}

////////////////////////////////////////////////////////////////////////////////

RxNumeric
RxNumeric::to_i() const
{
	return send("to_i");
}

RxNumeric
RxNumeric::to_f() const
{
	return send("to_f");
}

////////////////////////////////////////////////////////////////////////////////
