// $Id: RxTime.cpp,v 1.6 2002/08/18 15:35:44 yuya Exp $

#include "rubyxx/RxTime.h"

////////////////////////////////////////////////////////////////////////////////

RxTime::RxTime(time_t sec, time_t usec)
	: RxObject(::rb_time_new(sec, usec))
{
}

RxTime::RxTime(RxObject& obj)
	: RxObject(obj)
{
}

RxTime::~RxTime()
{
}

////////////////////////////////////////////////////////////////////////////////

RxObject
RxTime::asctime() const
{
	return send("asctime");
}

RxObject
RxTime::ctime() const
{
	return send("ctime");
}

RxObject
RxTime::day() const
{
	return send("day");
}

RxObject
RxTime::dst_() const
{
	return send("dst?");
}

RxObject
RxTime::gmt_() const
{
	return send("gmt?");
}

RxObject
RxTime::gmt_offset() const
{
	return send("gmt_offset");
}

RxObject
RxTime::gmtime() const
{
	return send("gmtime");
}

RxObject
RxTime::gmtoff() const
{
	return send("gmtoff");
}

RxObject
RxTime::hour() const
{
	return send("hour");
}

RxObject
RxTime::isdst() const
{
	return send("isdst");
}

RxObject
RxTime::localtime() const
{
	return send("localtime");
}

RxObject
RxTime::mday() const
{
	return send("mday");
}

RxObject
RxTime::mon() const
{
	return send("mon");
}

RxObject
RxTime::month() const
{
	return send("month");
}

RxObject
RxTime::sec() const
{
	return send("sec");
}

RxObject
RxTime::strftime() const
{
	return send("strftime");
}

RxObject
RxTime::to_f() const
{
	return send("to_f");
}

RxObject
RxTime::to_i() const
{
	return send("to_i");
}

RxObject
RxTime::tv_sec() const
{
	return send("tv_sec");
}

RxObject
RxTime::tv_usec() const
{
	return send("tv_usec");
}

RxObject
RxTime::usec() const
{
	return send("usec");
}

RxObject
RxTime::utc() const
{
	return send("utc");
}

RxObject
RxTime::utc_() const
{
	return send("utc?");
}

RxObject
RxTime::utc_offset() const
{
	return send("utc_offset");
}

RxObject
RxTime::wday() const
{
	return send("wday");
}

RxObject
RxTime::yday() const
{
	return send("yday");
}

RxObject
RxTime::year() const
{
	return send("year");
}

RxObject
RxTime::zone() const
{
	return send("zone");
}

////////////////////////////////////////////////////////////////////////////////
