// $Id: RxObject.cpp,v 1.1 2002/08/30 08:15:57 yuya Exp $

#include "rubyxx/RxObject.h"
#include "rubyxx/RxID.h"
#include "rubyxx/RxKernel.h"
#include "rubyxx/RxClass.h"
#include "rubyxx/RxString.h"
#include "rubyxx/RxNumeric.h"
#include "rubyxx/RxArray.h"

////////////////////////////////////////////////////////////////////////////////

VALUE RxObject::m_vGlobalVariable = 0;

////////////////////////////////////////////////////////////////////////////////

RxObject::RxObject()
{
	m_vObject = RxKernel::eval("Object.new").value();
	RxObject::register_global_variable(m_vObject);
}

RxObject::RxObject(const VALUE vObject)
{
	m_vObject = vObject;
	RxObject::register_global_variable(m_vObject);
}

RxObject::RxObject(const RxObject &Object)
{
	m_vObject = Object.m_vObject;
	RxObject::register_global_variable(m_vObject);
}

RxObject::~RxObject()
{
	RxObject::unregister_global_variable(m_vObject);
	m_vObject = 0;
}

////////////////////////////////////////////////////////////////////////////////

inline VALUE
RxObject::value() const
{
	return m_vObject;
}

////////////////////////////////////////////////////////////////////////////////

RxObject::operator bool() const
{
	return !(is_nil() || is_false());
}

bool
RxObject::operator==(RxObject obj) const
{
	return this->send("==", obj).is_true();
}

bool
RxObject::operator!=(RxObject obj) const
{
	return !(*this == obj);
}

bool
RxObject::operator>(RxObject obj) const
{
	return this->send(">", obj).is_true();
}

bool
RxObject::operator>=(RxObject obj) const
{
	return this->send(">=", obj).is_true();
}

bool
RxObject::operator<(RxObject obj) const
{
	return this->send("<", obj).is_true();
}

bool
RxObject::operator<=(RxObject obj) const
{
	return this->send("<=", obj).is_true();
}

////////////////////////////////////////////////////////////////////////////////

inline bool
RxObject::is_nil() const
{
	return (m_vObject == Qnil);
}

inline bool
RxObject::is_true() const
{
	return (m_vObject == Qtrue);
}

inline bool
RxObject::is_false() const
{
	return (m_vObject == Qfalse);
}

////////////////////////////////////////////////////////////////////////////////

RxObject
RxObject::send(RxID method_name) const
{
	return ::rb_funcall(m_vObject, method_name.id(), 0);
}

RxObject
RxObject::send(RxID method_name, RxObject param1) const
{
	return ::rb_funcall(m_vObject, method_name.id(), 1, (VALUE)param1.value());
}

RxObject
RxObject::send(RxID method_name, RxObject param1, RxObject param2) const
{
	return ::rb_funcall(m_vObject, method_name.id(), 2, (VALUE)param1.value(), (VALUE)param2.value());
}

RxObject
RxObject::apply(RxID mid, RxArray args) const
{
	return ::rb_apply(m_vObject, mid.id(), args.value());
}

RxObject
RxObject::apply2(RxID mid, RxObject arg_1, RxArray arg_n) const
{
	RxArray args;
	args.push(arg_1);
	args.concat(arg_n);
	return apply(mid, args);
}

RxObject
RxObject::class_() const
{
	return send("class");
}

RxObject
RxObject::clone() const
{
	return send("clone");
}

RxObject
RxObject::display() const
{
	return send("display");
}

RxObject
RxObject::dup_() const
{
	return send("dup");
}

RxObject
RxObject::eql() const
{
	return send("eql?");
}

RxObject
RxObject::equal() const
{
	return send("equal?");
}

RxObject
RxObject::extend() const
{
	return send("extend");
}

RxObject
RxObject::freeze() const
{
	return send("freeze");
}

RxObject
RxObject::frozen() const
{
	return send("frozen?");
}

RxNumeric
RxObject::hash() const
{
	return RxNumeric(send("hash"));
}

RxNumeric
RxObject::id() const
{
	return RxNumeric(send("id"));
}


RxString
RxObject::inspect() const
{
	return RxString(RxObject(::rb_inspect(m_vObject)));
}

RxObject
RxObject::instance_eval() const
{
	return send("instance_eval");
}

RxObject
RxObject::instance_of() const
{
	return send("instance_of?");
}

RxObject
RxObject::instance_variables() const
{
	return send("instance_variables");
}

RxObject
RxObject::is_a(RxObject obj) const
{
	return send("is_a?", obj);
}

RxObject
RxObject::kind_of(RxObject obj) const
{
	return send("kind_of?", obj);
}

RxObject
RxObject::method() const
{
	return send("method");
}

RxObject
RxObject::methods() const
{
	return send("methods");
}

RxObject
RxObject::private_methods() const
{
	return send("private_methods");
}

RxObject
RxObject::protected_methods() const
{
	return send("protected_methods");
}

RxObject
RxObject::public_methods() const
{
	return send("public_methods");
}

RxObject
RxObject::singleton_methods() const
{
	return send("singleton_methods");
}

RxObject
RxObject::taint() const
{
	return send("taint");
}

RxObject
RxObject::tainted() const
{
	return send("tainted");
}

RxObject
RxObject::to_a() const
{
	return send("to_a");
}

RxObject
RxObject::to_ary() const
{
	return send("to_ary");
}

RxObject
RxObject::to_hash() const
{
	return send("to_hash");
}

RxObject
RxObject::to_int() const
{
	return send("to_int");
}

RxString
RxObject::to_s() const
{
	return send("to_s");
}

RxString
RxObject::to_str() const
{
	return send("to_str");
}

RxClass
RxObject::type() const
{
	return RxClass(send("type"));
}

RxObject
RxObject::untaint() const
{
	return send("untaint");
}

////////////////////////////////////////////////////////////////////////////////

RxClass
RxObject::meta()
{
	return RxObject(rb_cObject);
}

RxObject
RxObject::new_()
{
	return meta().send("new");
}

////////////////////////////////////////////////////////////////////////////////

void
RxObject::register_global_variable(VALUE value)
{
	if ( !FIXNUM_P(value) ) {
		if ( !m_vGlobalVariable ) {
			m_vGlobalVariable = ::rb_hash_new();
			::rb_global_variable(&m_vGlobalVariable);
		}

		VALUE key   = INT2NUM(value);
		VALUE entry = ::rb_hash_aref(m_vGlobalVariable, key);

		if ( entry == Qnil ) {
			entry = rb_ary_new3(2, value, INT2FIX(1));
			::rb_hash_aset(m_vGlobalVariable, key, entry);
		} else {
			VALUE obj    = ::rb_ary_entry(entry, 0);
			VALUE count  = ::rb_ary_entry(entry, 1);
			VALUE count2 = ::rb_funcall(count, ::rb_intern("+"), 1, INT2FIX(1));
			::rb_ary_store(entry, 1, count2);
		}
	}
}

void
RxObject::unregister_global_variable(VALUE value)
{
	if ( !FIXNUM_P(value) ) {
		VALUE key   = INT2NUM(value);
		VALUE entry = ::rb_hash_aref(m_vGlobalVariable, key);

		VALUE count  = ::rb_ary_entry(entry, 1);
		VALUE count2 = ::rb_funcall(count, ::rb_intern("-"), 1, INT2FIX(1));

		if ( FIX2INT(count2) <= 0 ) {
			::rb_funcall(m_vGlobalVariable, ::rb_intern("delete"), 1, key);
		} else {
			::rb_ary_store(entry, 1, count2);
		}
	}
}

////////////////////////////////////////////////////////////////////////////////
