/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : DrawMode.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/18
 *    Last                 : 2007/10/14
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <unistd.h>
//#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "intl.h"

#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "culcfunc.h"
#include "Dimension.h"
#include "etc.h"
#include "global.h"
#include "Draw.h"
#include "Select.h"
#include "Dimension.h"
#include "InputBox.h"
#include "MsgBox.h"
#include "Mouse.h"
#include "Ellipse.h"
#include "sagcad.h"
#include "CulcInputDlg.h"
#define _DRAWMODE_
#include "DrawMode.h"





/* -------------------------------------------------------------------
 * 点->点 
 * 
 * 
 */
int p_p(void)
{
	int Ret;
	char str[256];
	double x, y;
	CAD cad;




	/* 数値入力ダイアログボックス表示 */
	strcpy(str, "");
	Ret = CulcInputBox(MainWindow, _("The relative point") , _("X The coordinates") , _("(Relative)") , str);
	if (Ret == -1) return 0;
	x = atof(str);

	/* 数値入力ダイアログボックス表示 */
	strcpy(str, "");
	Ret = CulcInputBox(MainWindow, _("The relative point") , _("Y The coordinates") , _("(Relative)") , str);
	if (Ret == -1) return 0;
	y = atof(str);

	/* 点データを登録 */
	cad.code = 0;
	cad.layer = NowLayer;
	cad.style = NowStyle;
	cad.color = NowColor;
	cad.sx = select_search_num(1)->select->diagram_point.cad_point->sx + x;
	cad.sy = select_search_num(1)->select->diagram_point.cad_point->sy + y;
	cad.ex = 0;
	cad.ey = 0;
	cad.cx = 0;
	cad.cy = 0;
	cad.r  = 0;
	cad.OnScreen = 0;
	undo_index_plus();
	cad_list_add_first_with_undo(&cad, &cad_list_info);
	SelectCadDraw(drawing_area, &cad, SCD_ORG);

	return 1;
}



/* -------------------------------------------------------------------
 * 点と点で点   ２点が違う   中点
 * 
 * 
 */
int pp_p(void)
{
	struct RtnDat rtn;
	CAD cad;


	rtn.sx[1] = select_search_num(1)->select->diagram_point.cad_point->sx;
	rtn.sy[1] = select_search_num(1)->select->diagram_point.cad_point->sy;
	rtn.ex[1] = select_search_num(2)->select->diagram_point.cad_point->sx;
	rtn.ey[1] = select_search_num(2)->select->diagram_point.cad_point->sy;
	rtn.sx[2] = 1;
	rtn.ex[2] = 1;
	ppp(&rtn);

	/* 点データを登録 */
	cad.code = 0;
	cad.layer = NowLayer;
	cad.style = NowStyle;
	cad.color = NowColor;
	cad.sx = rtn.sx[3];
	cad.sy = rtn.sy[3];
	cad.ex = 0;
	cad.ey = 0;
	cad.cx = 0;
	cad.cy = 0;
	cad.r  = 0;
	cad.OnScreen = 0;
	undo_index_plus();
	cad_list_add_first_with_undo(&cad, &cad_list_info);
	SelectCadDraw(drawing_area, &cad, SCD_ORG);

	return 1;
}



/* -------------------------------------------------------------------
 * 点と線で点   最近点
 * 
 * 
 */
int pl_p(void)
{
	struct RtnDat rtn;
	CAD cad;


	if (select_search_num(1)->select->diagram_point.cad_point->code == 0) {
		rtn.sx[2] = select_search_num(1)->select->diagram_point.cad_point->sx;
		rtn.sy[2] = select_search_num(1)->select->diagram_point.cad_point->sy;
		rtn.sx[1] = select_search_num(2)->select->diagram_point.cad_point->sx;
		rtn.sy[1] = select_search_num(2)->select->diagram_point.cad_point->sy;
		rtn.ex[1] = select_search_num(2)->select->diagram_point.cad_point->ex;
		rtn.ey[1] = select_search_num(2)->select->diagram_point.cad_point->ey;
	}
	if (select_search_num(2)->select->diagram_point.cad_point->code == 0) {
		rtn.sx[2] = select_search_num(2)->select->diagram_point.cad_point->sx;
		rtn.sy[2] = select_search_num(2)->select->diagram_point.cad_point->sy;
		rtn.sx[1] = select_search_num(1)->select->diagram_point.cad_point->sx;
		rtn.sy[1] = select_search_num(1)->select->diagram_point.cad_point->sy;
		rtn.ex[1] = select_search_num(1)->select->diagram_point.cad_point->ex;
		rtn.ey[1] = select_search_num(1)->select->diagram_point.cad_point->ey;
	}
	plp(&rtn);

	/* 点データを登録 */
	cad.code = 0;
	cad.layer = NowLayer;
	cad.style = NowStyle;
	cad.color = NowColor;
	cad.sx = rtn.ex[2];
	cad.sy = rtn.ey[2];
	cad.ex = 0;
	cad.ey = 0;
	cad.cx = 0;
	cad.cy = 0;
	cad.r  = 0;
	cad.OnScreen = 0;
	undo_index_plus();
	cad_list_add_first_with_undo(&cad, &cad_list_info);
	SelectCadDraw(drawing_area, &cad, SCD_ORG);

	return 1;
}



/* -------------------------------------------------------------------
 * 点と円で点   最近点
 * 
 * 
 */
int pc_p(void)
{
	struct RtnDat rtn;
	CAD point, circle, cad;


	if ((select_search_num(1)->select->diagram_point.cad_point->code == 0 && select_search_num(2)->select->diagram_point.cad_point->code == 2)
		|| (select_search_num(1)->select->diagram_point.cad_point->code == 0 && select_search_num(2)->select->diagram_point.cad_point->code == 4)) 
	{
		if (select_search_num(2)->select->diagram_point.cad_point->cx == select_search_num(1)->select->diagram_point.cad_point->sx 
			&& select_search_num(2)->select->diagram_point.cad_point->cy == select_search_num(1)->select->diagram_point.cad_point->sy) 
		{
			MsgBox("SagCAD", "Error !", _("The point and the center is the same point.") , NULL, NULL, "OK");
			return 0;
		}
		point = *select_search_num(1)->select->diagram_point.cad_point;
		circle = *select_search_num(2)->select->diagram_point.cad_point;
	}

	else if ((select_search_num(1)->select->diagram_point.cad_point->code == 2 && select_search_num(2)->select->diagram_point.cad_point->code == 0)
		|| (select_search_num(1)->select->diagram_point.cad_point->code == 4 && select_search_num(2)->select->diagram_point.cad_point->code == 0))
	{
		if (select_search_num(1)->select->diagram_point.cad_point->cx == select_search_num(2)->select->diagram_point.cad_point->sx 
			&& select_search_num(1)->select->diagram_point.cad_point->cy == select_search_num(2)->select->diagram_point.cad_point->sy)
		{
			MsgBox("SagCAD", "Error !", _("The point and the center is the same point.") , NULL, NULL, "OK");
			return 0;
		}
		point = *select_search_num(2)->select->diagram_point.cad_point;
		circle = *select_search_num(1)->select->diagram_point.cad_point;
	}


	/* 円の中心から点に向かう線の角度Ａを求める。*/
	rtn.sx[1] = circle.cx;
	rtn.sy[1] = circle.cy;
	rtn.ex[1] = point.sx;
	rtn.ey[1] = point.sy;
	la(&rtn);

	/* 円の中心から角度Ａに半径の距離にある点 */
	rtn.l = circle.r;
	pap(&rtn);
	/* (rtn.ex[1],rtn.ey[1]) */

	/* 点データを登録 */
	cad.code = 0;
	cad.layer = NowLayer;
	cad.style = NowStyle;
	cad.color = NowColor;
	cad.sx = rtn.ex[1];
	cad.sy = rtn.ey[1];
	cad.ex = 0;
	cad.ey = 0;
	cad.cx = 0;
	cad.cy = 0;
	cad.r  = 0;
	cad.OnScreen = 0;
	undo_index_plus();
	cad_list_add_first_with_undo(&cad, &cad_list_info);
	SelectCadDraw(drawing_area, &cad, SCD_ORG);

	return 1;
}



/* -------------------------------------------------------------------
 * 線と線で点   l_p   ２線が同一   線の端点
 * 
 * 
 */
int l_p(void)
{
	CAD cad;


	/* 点データを登録 */
	cad.code = 0;
	cad.layer = NowLayer;
	cad.style = NowStyle;
	cad.color = NowColor;
	cad.sx = select_search_num(1)->select->diagram_point.cad_point->sx;
	cad.sy = select_search_num(1)->select->diagram_point.cad_point->sy;
	cad.ex = 0;
	cad.ey = 0;
	cad.cx = 0;
	cad.cy = 0;
	cad.r  = 0;
	cad.OnScreen = 0;
	undo_index_plus();
	cad_list_add_first_with_undo(&cad, &cad_list_info);
	SelectCadDraw(drawing_area, &cad, SCD_ORG);

	cad.code = 0;
	cad.layer = NowLayer;
	cad.style = NowStyle;
	cad.color = NowColor;
	cad.sx = select_search_num(1)->select->diagram_point.cad_point->ex;
	cad.sy = select_search_num(1)->select->diagram_point.cad_point->ey;
	cad.ex = 0;
	cad.ey = 0;
	cad.cx = 0;
	cad.cy = 0;
	cad.r  = 0;
	cad.OnScreen = 0;
	cad_list_add_first_with_undo(&cad, &cad_list_info);
	SelectCadDraw(drawing_area, &cad, SCD_ORG);

	return 1;
}



/* -------------------------------------------------------------------
 * 線と線で点   ll_p   ２線が違う   ２直線の交点
 * 
 * 
 */
int ll_p(void)
{
	struct RtnDat rtn;
	CAD cad;


	rtn.sx[1] = select_search_num(1)->select->diagram_point.cad_point->sx;
	rtn.sy[1] = select_search_num(1)->select->diagram_point.cad_point->sy;
	rtn.ex[1] = select_search_num(1)->select->diagram_point.cad_point->ex;
	rtn.ey[1] = select_search_num(1)->select->diagram_point.cad_point->ey;
	rtn.sx[2] = select_search_num(2)->select->diagram_point.cad_point->sx;
	rtn.sy[2] = select_search_num(2)->select->diagram_point.cad_point->sy;
	rtn.ex[2] = select_search_num(2)->select->diagram_point.cad_point->ex;
	rtn.ey[2] = select_search_num(2)->select->diagram_point.cad_point->ey;
	llp(&rtn);

	if (rtn.type == 0) {
		MsgBox("SagCAD", _("There is not a point of intersection.") , _("(2 straight lines are parallel)") , NULL, NULL, "OK");
		return 0;
	}
	
	/* 点データを登録 */
	cad.code = 0;
	cad.layer = NowLayer;
	cad.style = NowStyle;
	cad.color = NowColor;
	cad.sx = rtn.sx[3];
	cad.sy = rtn.sy[3];
	cad.ex = 0;
	cad.ey = 0;
	cad.cx = 0;
	cad.cy = 0;
	cad.r  = 0;
	cad.OnScreen = 0;
	undo_index_plus();
	cad_list_add_first_with_undo(&cad, &cad_list_info);
	SelectCadDraw(drawing_area, &cad, SCD_ORG);

	return 1;
}



/* -------------------------------------------------------------------
 * 線と円で点   lc_p   円と直線の交点
 * 
 * 
 */
int lc_p(void)
{
	struct RtnDat rtn;
	CAD cad;


	if (select_search_num(1)->select->diagram_point.cad_point->code == 1) {
		rtn.sx[1] = select_search_num(1)->select->diagram_point.cad_point->sx;
		rtn.sy[1] = select_search_num(1)->select->diagram_point.cad_point->sy;
		rtn.ex[1] = select_search_num(1)->select->diagram_point.cad_point->ex;
		rtn.ey[1] = select_search_num(1)->select->diagram_point.cad_point->ey;
		rtn.cx[1] = select_search_num(2)->select->diagram_point.cad_point->cx;
		rtn.cy[1] = select_search_num(2)->select->diagram_point.cad_point->cy;
		rtn.r[1] = select_search_num(2)->select->diagram_point.cad_point->r;
	}
	if (select_search_num(2)->select->diagram_point.cad_point->code == 1) {
		rtn.sx[1] = select_search_num(2)->select->diagram_point.cad_point->sx;
		rtn.sy[1] = select_search_num(2)->select->diagram_point.cad_point->sy;
		rtn.ex[1] = select_search_num(2)->select->diagram_point.cad_point->ex;
		rtn.ey[1] = select_search_num(2)->select->diagram_point.cad_point->ey;
		rtn.cx[1] = select_search_num(1)->select->diagram_point.cad_point->cx;
		rtn.cy[1] = select_search_num(1)->select->diagram_point.cad_point->cy;
		rtn.r[1] = select_search_num(1)->select->diagram_point.cad_point->r;
	}
	lcp(&rtn);
	
	if (rtn.type == 0) {
		MsgBox("SagCAD", _("There is not a point of intersection.") , " " , NULL, NULL, "OK");
		return 0;
	}
	/* 点データを登録 */
	cad.code = 0;
	cad.layer = NowLayer;
	cad.style = NowStyle;
	cad.color = NowColor;
	cad.sx = rtn.sx[2];
	cad.sy = rtn.sy[2];
	cad.ex = 0;
	cad.ey = 0;
	cad.cx = 0;
	cad.cy = 0;
	cad.r  = 0;
	cad.OnScreen = 0;
	undo_index_plus();
	cad_list_add_first_with_undo(&cad, &cad_list_info);
	SelectCadDraw(drawing_area, &cad, SCD_ORG);


	if (rtn.type == 2) {
		/* 点データを登録 */
		cad.code = 0;
		cad.layer = NowLayer;
		cad.style = NowStyle;
		cad.color = NowColor;
		cad.sx = rtn.sx[3];
		cad.sy = rtn.sy[3];
		cad.ex = 0;
		cad.ey = 0;
		cad.cx = 0;
		cad.cy = 0;
		cad.r  = 0;
		cad.OnScreen = 0;
		cad_list_add_first_with_undo(&cad, &cad_list_info);
		SelectCadDraw(drawing_area, &cad, SCD_ORG);
	}

	if (rtn.type == 1) {
		//MsgBox("注意　！", "交点が１個です。", " " , NULL, NULL, "OK");
	}
	return 1;
}



/* -------------------------------------------------------------------
 * 円と円で点   c_p   ２円が同一   中心点
 * 
 * 
 */
int c_p(void)
{
	CAD cad;


	/* 点データを登録 */
	cad.code = 0;
	cad.layer = NowLayer;
	cad.style = NowStyle;
	cad.color = NowColor;
	cad.sx = select_search_num(1)->select->diagram_point.cad_point->cx;
	cad.sy = select_search_num(1)->select->diagram_point.cad_point->cy;
	cad.ex = 0;
	cad.ey = 0;
	cad.cx = 0;
	cad.cy = 0;
	cad.r  = 0;
	cad.OnScreen = 0;
	undo_index_plus();
	cad_list_add_first_with_undo(&cad, &cad_list_info);
	SelectCadDraw(drawing_area, &cad, SCD_ORG);

	return 1;
}



/* -------------------------------------------------------------------
 * 円と円で点   cc_p   ２円が違う   ２円の交点
 * 
 * 
 */
int cc_p(void)
{
	struct RtnDat rtn;
	CAD cad;


	rtn.cx[1] = select_search_num(1)->select->diagram_point.cad_point->cx;
	rtn.cy[1] = select_search_num(1)->select->diagram_point.cad_point->cy;
	rtn.r[1] = select_search_num(1)->select->diagram_point.cad_point->r;
	rtn.cx[2] = select_search_num(2)->select->diagram_point.cad_point->cx;
	rtn.cy[2] = select_search_num(2)->select->diagram_point.cad_point->cy;
	rtn.r[2] = select_search_num(2)->select->diagram_point.cad_point->r;
	ccp(&rtn);

	if (rtn.type == 0) {
		MsgBox("SagCAD", _("There is not a point of intersection.") , " " , NULL, NULL, "OK");
		return 0;
	}
	
	/* 点データを登録 */
	cad.code = 0;
	cad.layer = NowLayer;
	cad.style = NowStyle;
	cad.color = NowColor;
	cad.sx = rtn.sx[1];
	cad.sy = rtn.sy[1];
	cad.ex = 0;
	cad.ey = 0;
	cad.cx = 0;
	cad.cy = 0;
	cad.r  = 0;
	cad.OnScreen = 0;
	undo_index_plus();
	cad_list_add_first_with_undo(&cad, &cad_list_info);
	SelectCadDraw(drawing_area, &cad, SCD_ORG);

	if (rtn.type == 2) {
		/* 点データを登録 */
		cad.code = 0;
		cad.layer = NowLayer;
		cad.style = NowStyle;
		cad.color = NowColor;
		cad.sx = rtn.sx[2];
		cad.sy = rtn.sy[2];
		cad.ex = 0;
		cad.ey = 0;
		cad.cx = 0;
		cad.cy = 0;
		cad.r  = 0;
		cad.OnScreen = 0;
		cad_list_add_first_with_undo(&cad, &cad_list_info);
		SelectCadDraw(drawing_area, &cad, SCD_ORG);
	}
	
	if (rtn.type == 1) {
		//MsgBox("注意　！", "交点が１個です。", " " , NULL, NULL, "OK");
	}
	return 1;
}



/* -------------------------------------------------------------------
 * 楕円と線で点   le_p
 * 
 * 
 */
int le_p(void)
{
	struct RtnDat rtn;
	CAD cad;
	SELECT *sel_1, *sel_2, *sel;


	sel_1 = select_search_num(1)->select;
	sel_2 = select_search_num(2)->select;

	/* sel_1 が楕円となるようにする */
	if (sel_1->index == 2) {
		sel = sel_1;
		sel_1 = sel_2;
		sel_2 = sel;
	}


	//ellipse.cx = sel_1->diagram_point.ellipse_point->cx;
	
	rtn.sx[1] = sel_2->diagram_point.cad_point->sx;
	rtn.sy[1] = sel_2->diagram_point.cad_point->sy;
	rtn.ex[1] = sel_2->diagram_point.cad_point->ex;
	rtn.ey[1] = sel_2->diagram_point.cad_point->ey;

	lep(&rtn, *sel_1->diagram_point.ellipse_point, 7);
	
	if (rtn.type == 0) {
		MsgBox("SagCAD", _("There is not a point of intersection.") , " " , NULL, NULL, "OK");
		return 0;
	}
	/* 点データを登録 */
	cad.code = 0;
	cad.layer = NowLayer;
	cad.style = NowStyle;
	cad.color = NowColor;
	cad.sx = rtn.sx[2];
	cad.sy = rtn.sy[2];
	cad.ex = 0;
	cad.ey = 0;
	cad.cx = 0;
	cad.cy = 0;
	cad.r  = 0;
	cad.OnScreen = 0;
	undo_index_plus();
	cad_list_add_first_with_undo(&cad, &cad_list_info);
	SelectCadDraw(drawing_area, &cad, SCD_ORG);


	if (rtn.type == 2) {
		/* 点データを登録 */
		cad.code = 0;
		cad.layer = NowLayer;
		cad.style = NowStyle;
		cad.color = NowColor;
		cad.sx = rtn.sx[3];
		cad.sy = rtn.sy[3];
		cad.ex = 0;
		cad.ey = 0;
		cad.cx = 0;
		cad.cy = 0;
		cad.r  = 0;
		cad.OnScreen = 0;
		cad_list_add_first_with_undo(&cad, &cad_list_info);
		SelectCadDraw(drawing_area, &cad, SCD_ORG);
	}

	if (rtn.type == 1) {
		//MsgBox("注意　！", "交点が１個です。", " " , NULL, NULL, "OK");
	}
	return 1;
}



/* -------------------------------------------------------------------
 * 楕円と円で点   ce_p
 * 
 * 
 */
int ce_p(void)
{
	struct RtnDat rtn;
	ELLIPSE ellipse;
	CAD cad;
	SELECT *sel_1, *sel_2, *sel;
	int i;


	sel_1 = select_search_num(1)->select;
	sel_2 = select_search_num(2)->select;

	/* sel_1 が楕円となるようにする */
	if (sel_1->index == 2) {
		sel = sel_1;
		sel_1 = sel_2;
		sel_2 = sel;
	}


	ellipse.cx = sel_2->diagram_point.cad_point->cx;
	ellipse.cy = sel_2->diagram_point.cad_point->cy;
	ellipse.dx = sel_2->diagram_point.cad_point->r;
	ellipse.dy = 0;
	ellipse.k  = 1;
	ellipse.sa = 0;
	ellipse.ea = 360;
	ellipse_on_ellipse(&rtn, *sel_1->diagram_point.ellipse_point, ellipse);


	if (rtn.type == 0) {
		MsgBox("SagCAD", _("There is not a point of intersection.") , " " , NULL, NULL, "OK");
		return 0;
	}
	/* 点データを登録 */
	if (rtn.type > 0) {
		undo_index_plus();
		for (i = 1 ; i < rtn.type + 1 ; i++) {
			cad.code = 0;
			cad.layer = NowLayer;
			cad.style = NowStyle;
			cad.color = NowColor;
			cad.sx = rtn.sx[i];
			cad.sy = rtn.sy[i];
			cad.ex = 0;
			cad.ey = 0;
			cad.cx = 0;
			cad.cy = 0;
			cad.r  = 0;
			cad.OnScreen = 0;
			cad_list_add_first_with_undo(&cad, &cad_list_info);
			SelectCadDraw(drawing_area, &cad, SCD_ORG);
		}
		UpDate();
	}
	return 1;
}



/* -------------------------------------------------------------------
 * 楕円と楕円で点   ee_p
 * 
 * 
 */
int ee_p(void)
{
	struct RtnDat rtn;
	CAD cad;
	SELECT *sel_1, *sel_2;
	int i;


	sel_1 = select_search_num(1)->select;
	sel_2 = select_search_num(2)->select;

	ellipse_on_ellipse(&rtn, *sel_1->diagram_point.ellipse_point, *sel_2->diagram_point.ellipse_point);

	if (rtn.type == 0) {
		MsgBox("SagCAD", _("There is not a point of intersection.") , " " , NULL, NULL, "OK");
		return 0;
	}
	/* 点データを登録 */
	if (rtn.type > 0) {
		undo_index_plus();
		for (i = 1 ; i < rtn.type + 1 ; i++) {
			cad.code = 0;
			cad.layer = NowLayer;
			cad.style = NowStyle;
			cad.color = NowColor;
			cad.sx = rtn.sx[i];
			cad.sy = rtn.sy[i];
			cad.ex = 0;
			cad.ey = 0;
			cad.cx = 0;
			cad.cy = 0;
			cad.r  = 0;
			cad.OnScreen = 0;
			cad_list_add_first_with_undo(&cad, &cad_list_info);
			SelectCadDraw(drawing_area, &cad, SCD_ORG);
		}
		UpDate();
	}
	return 1;
}



/* ---------------------------------------------------------------------
 * 点コマンドを選択したとき
 * 
 */
int CreatePoint(GtkWidget *widget)
{
	SELECT *sel_1, *sel_2, *sel;


	sel_1 = select_search_num(1)->select;
	sel_2 = select_search_num(2)->select;



	/* 点,線,円弧,円のみのとき */
	if (sel_1->index == 2 
		&& 
		sel_2->index == 2 ) 
	{

		/* 点と点 */
		if (	sel_1->diagram_point.cad_point->code == 0 
				&& 
				sel_2->diagram_point.cad_point->code == 0
			) 
		{
			/* ２点が同一   p_p   相対点 */
			if (sel_1->diagram_point.cad_point 
					== sel_2->diagram_point.cad_point 
				|| 
				(
				sel_1->diagram_point.cad_point->sx 
					== sel_2->diagram_point.cad_point->sx 
				&& 
				sel_1->diagram_point.cad_point->sy 
					== sel_2->diagram_point.cad_point->sy
				)	) 
			{
				p_p();
				return 1;
			}
			/* ２点が違う   pp_p   中点 */
			if (sel_1->diagram_point.cad_point != sel_2->diagram_point.cad_point) {
				pp_p();
				return 1;
			}
		}


		/* 点と線   pl_p   最近点 */
		else if (	(
					sel_1->diagram_point.cad_point->code == 0 
					&& 
					sel_2->diagram_point.cad_point->code == 1
					) 
					|| 
					(
					sel_1->diagram_point.cad_point->code == 1 
					&& 
					sel_2->diagram_point.cad_point->code == 0
					)	) 
		{
			pl_p();
			return 1;
		}


		/* 点と円   pc_p   最近点 */
		else if (	(
					sel_1->diagram_point.cad_point->code == 0 
					&& 
					sel_2->diagram_point.cad_point->code == 2
					)
					|| 
					(
					sel_1->diagram_point.cad_point->code == 0 
					&& 
					sel_2->diagram_point.cad_point->code == 4
					)
					|| 
					(
					sel_1->diagram_point.cad_point->code == 2 
					&& 
					sel_2->diagram_point.cad_point->code == 0
					)
					|| 
					(
					sel_1->diagram_point.cad_point->code == 4 
					&& 
					sel_2->diagram_point.cad_point->code == 0
					)	)
		{
			pc_p();
			return 1;
		}


		/* 線と線 */
		else if (sel_1->diagram_point.cad_point->code == 1 
				 && 
				 sel_2->diagram_point.cad_point->code == 1) 
		{
			/* ２線が同一   l_p   線の端点 */
			if (sel_1->diagram_point.cad_point == sel_2->diagram_point.cad_point) 
			{
				l_p();
				return 1;
			}

			/* ２線が違う   ll_p   ２直線の交点 */
			if (sel_1->diagram_point.cad_point != sel_2->diagram_point.cad_point) 
			{
				ll_p();
				return 1;
			}
		}


		/* 線と円   lc_p   円と直線の交点 */
		else if (	(
					sel_1->diagram_point.cad_point->code == 1 
					&& 
					sel_2->diagram_point.cad_point->code == 2
					) 
					|| 
					(
					sel_1->diagram_point.cad_point->code == 2 
					&& 
					sel_2->diagram_point.cad_point->code == 1
					)
					|| 
					(
					sel_1->diagram_point.cad_point->code == 1 
					&& 
					sel_2->diagram_point.cad_point->code == 4
					)
					|| 
					(
					sel_1->diagram_point.cad_point->code == 4 
					&& 
					sel_2->diagram_point.cad_point->code == 1
					)	) 
		{
			lc_p();
			return 1;
		}


		/* 円と円 */
		else if (	(
					sel_1->diagram_point.cad_point->code == 2 
					&& 
					sel_2->diagram_point.cad_point->code == 2
					) 
					|| 
					(
					sel_1->diagram_point.cad_point->code == 4 
					&& 
					sel_2->diagram_point.cad_point->code == 4
					) 
					|| 
					(
					sel_1->diagram_point.cad_point->code == 2 
					&& 
					sel_2->diagram_point.cad_point->code == 4
					) 
					|| 
					(
					sel_1->diagram_point.cad_point->code == 4 
					&& 
					sel_2->diagram_point.cad_point->code == 2
					)	) 
		{
			/* ２円が同一   c_p   中心点 */
			if (sel_1->diagram_point.cad_point == sel_2->diagram_point.cad_point) {
				c_p();
				return 1;
			}

			/* ２円が違う   cc_p   ２円の交点 */
			if (sel_1->diagram_point.cad_point != sel_2->diagram_point.cad_point) {
				cc_p();
				return 1;
			}
		}
	}



	/* 楕円があるとき */
	else if (sel_1->index == 16 
			|| 
			sel_2->index == 16 ) 
	{
		/* sel_1 が楕円となるようにする */
		if (sel_1->index == 2) {
			sel = sel_1;
			sel_1 = sel_2;
			sel_2 = sel;
		}


		/* 楕円と点 */
		if (sel_2->index == 2) {
			if (sel_2->diagram_point.cad_point->code == 0) {
				// 無し
				return 0;
			}
		}

		/* 楕円と線 */
		if (sel_2->index == 2) {
			if (sel_2->diagram_point.cad_point->code == 1) {
				le_p();
				return 1;
			}
		}

		/* 楕円と円(円弧) */
		if (sel_2->index == 2) {
			if (sel_2->diagram_point.cad_point->code == 2 || sel_2->diagram_point.cad_point->code == 4) {
				ce_p();
				return 1;
			}
		}

		/* 楕円と楕円 */
		if (sel_2->index == 16) {
			ee_p();
			return 1;
		}
	}



	return 0;
}





/* ---------------------------------------------------------------------
 * 点と点で線   p_l   ２点が同一   角度と長さ
 * 
 */
int p_l(void)
{
	int Ret;
	struct RtnDat rtn;
	CAD cad;
	char str[256];


	/* 数値入力ダイアログボックス表示 */
	strcpy(str, "");
	Ret = CulcInputBox(MainWindow, 
					   _("It makes a line with point and angle.") , 
					   "Angle (DEG)", 
					   "", 
					   str);
	if (Ret == -1) return 0;
	rtn.angle = atof(str);

	rtn.sx[1] = select_search_num(1)->select->diagram_point.cad_point->sx;
	rtn.sy[1] = select_search_num(1)->select->diagram_point.cad_point->sy;
	rtn.l = sagcad_system.Length;
	pap(&rtn);
	
	/* 線データを登録 */
	cad.code = 1;
	cad.layer = NowLayer;
	cad.style = NowStyle;
	cad.color = NowColor;
	cad.sx = rtn.sx[1];
	cad.sy = rtn.sy[1];
	cad.ex = rtn.ex[1];
	cad.ey = rtn.ey[1];
	cad.cx = 0;
	cad.cy = 0;
	cad.r  = 0;
	cad.OnScreen = 0;
	undo_index_plus();
	cad_list_add_first_with_undo(&cad, &cad_list_info);
	SelectCadDraw(drawing_area, &cad, SCD_ORG);
//	LineDraw(drawing_area, cad.sx, cad.sy, cad.ex, cad.ey, NowStyle, NowColor);

	return 1;
}



/* ---------------------------------------------------------------------
 * 点と点で線   pp_l   ２点が違う   ２点を始点と終点とする直線
 * 
 */
int pp_l(void)
{
	CAD cad;


	/* 線データを登録 */
	cad.code = 1;
	cad.layer = NowLayer;
	cad.style = NowStyle;
	cad.color = NowColor;
	cad.sx = select_search_num(1)->select->diagram_point.cad_point->sx;
	cad.sy = select_search_num(1)->select->diagram_point.cad_point->sy;
	cad.ex = select_search_num(2)->select->diagram_point.cad_point->sx;
	cad.ey = select_search_num(2)->select->diagram_point.cad_point->sy;
	cad.cx = 0;
	cad.cy = 0;
	cad.r  = 0;
	cad.OnScreen = 0;
	undo_index_plus();
	cad_list_add_first_with_undo(&cad, &cad_list_info);
	SelectCadDraw(drawing_area, &cad, SCD_ORG);
//	LineDraw(drawing_area, cad.sx, cad.sy, cad.ex, cad.ey, NowStyle, NowColor);

	return 1;
}



/* ---------------------------------------------------------------------
 * 点と線で線   pl_l   点を通る直線に平行な直線
 * 
 */
int pl_l(void)
{
	int Ret;
	struct RtnDat rtn;
	CAD cad;
	SELECT DumySelect;
	char str[256];
	double Angle1, Angle2;


	if (select_search_num(2)->select->diagram_point.cad_point->code == 0) {
		DumySelect = *select_search_num(1)->select;
		*select_search_num(1)->select = *select_search_num(2)->select;
		*select_search_num(2)->select = DumySelect;
	}
	
	/* 数値入力ダイアログボックス表示 */
	strcpy(str, "");
	Ret = CulcInputBox(MainWindow, _("Makes a line with point and line.") , _("Input an angle (DEG)") , "", str);
	if (Ret == -1) return 0;
	Angle1 = atof(str);

	/* 選択直線の角度 */
	rtn.sx[1] = select_search_num(2)->select->diagram_point.cad_point->sx;
	rtn.sy[1] = select_search_num(2)->select->diagram_point.cad_point->sy;
	rtn.ex[1] = select_search_num(2)->select->diagram_point.cad_point->ex;
	rtn.ey[1] = select_search_num(2)->select->diagram_point.cad_point->ey;
	la(&rtn);
	Angle2 = rtn.angle;

	rtn.angle = Angle1 + Angle2;
	if (rtn.angle > 360)	rtn.angle = rtn.angle - 360;
	if (rtn.angle < 0)		rtn.angle = rtn.angle + 360;
	
	/* 選択点からAngle1+Angle2の角度の線 */
	rtn.sx[1] = select_search_num(1)->select->diagram_point.cad_point->sx;
	rtn.sy[1] = select_search_num(1)->select->diagram_point.cad_point->sy;
	rtn.l = sagcad_system.Length;
	pap(&rtn);
	
	/* 線データを登録 */
	cad.code = 1;
	cad.layer = NowLayer;
	cad.style = NowStyle;
	cad.color = NowColor;
	cad.sx = select_search_num(1)->select->diagram_point.cad_point->sx;
	cad.sy = select_search_num(1)->select->diagram_point.cad_point->sy;
	cad.ex = rtn.ex[1];
	cad.ey = rtn.ey[1];
	cad.cx = 0;
	cad.cy = 0;
	cad.r  = 0;
	cad.OnScreen = 0;
	undo_index_plus();
	cad_list_add_first_with_undo(&cad, &cad_list_info);
	SelectCadDraw(drawing_area, &cad, SCD_ORG);
//	LineDraw(drawing_area, cad.sx, cad.sy, cad.ex, cad.ey, NowStyle, NowColor);

	return 1;
}



/* ---------------------------------------------------------------------
 * 点と円で線   pc_l   点を通る円の接線
 * 
 */
int pc_l(void)
{
	struct RtnDat rtn;
	CAD point, circle, cad;


	if (select_search_num(1)->select->diagram_point.cad_point->code == 0) {
		point = *select_search_num(1)->select->diagram_point.cad_point;
		circle = *select_search_num(2)->select->diagram_point.cad_point;
	}
	if (select_search_num(2)->select->diagram_point.cad_point->code == 0) {
		point = *select_search_num(2)->select->diagram_point.cad_point;
		circle = *select_search_num(1)->select->diagram_point.cad_point;
	}

	rtn.sx[1] = point.sx;
	rtn.sy[1] = point.sy;
	rtn.cx[1] = circle.cx;
	rtn.cy[1] = circle.cy;
	rtn.r[1] = circle.r;
	pcl(&rtn);
	
	if (rtn.type == 0) return 0;
	else if (rtn.type == 2) {
		OnlyOneCAD[1].code = 1;
		OnlyOneCAD[1].sx = sg(rtn.sx[1], 6);
		OnlyOneCAD[1].sy = sg(rtn.sy[1], 6);
		OnlyOneCAD[1].ex = sg(rtn.ex[1], 6);
		OnlyOneCAD[1].ey = sg(rtn.ey[1], 6);
		OnlyOneCAD[2].code = 1;
		OnlyOneCAD[2].sx = sg(rtn.sx[1], 6);
		OnlyOneCAD[2].sy = sg(rtn.sy[1], 6);
		OnlyOneCAD[2].ex = sg(rtn.ex[2], 6);
		OnlyOneCAD[2].ey = sg(rtn.ey[2], 6);
		OnlyOneIndex = 1;
		OnlyOneEntry = 2;
		OnlyOne_mode = 210;
		OnlyOneKeepReturnFunc = ReturnFunc;
		ReturnFunc = MouseRet_OnlyOne;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		OnlyOne(3);
		return 1;
	}
	else if (rtn.type == 1) {
		/* 線データを登録 */
		cad.code = 1;
		cad.layer = NowLayer;
		cad.style = NowStyle;
		cad.color = NowColor;
		cad.sx = rtn.sx[1];
		cad.sy = rtn.sy[1];
		cad.ex = rtn.ex[1];
		cad.ey = rtn.ey[1];
		cad.cx = 0;
		cad.cy = 0;
		cad.r  = 0;
		cad.OnScreen = 0;
		undo_index_plus();
		cad_list_add_first_with_undo(&cad, &cad_list_info);
		SelectCadDraw(drawing_area, &cad, SCD_ORG);
//		LineDraw(drawing_area, cad.sx, cad.sy, cad.ex, cad.ey, NowStyle, NowColor);

		return 1;
	}
	return 0;
}



/* ---------------------------------------------------------------------
 * 線と線で線   l_l   ２線が同一   直線のオフセット
 * 
 */
int l_l(void)
{
	int Ret;
	struct RtnDat rtn;
	char str[256];


	/* 数値入力ダイアログボックス表示 */
	strcpy(str, "");
	Ret = CulcInputBox(MainWindow, 
					   _("Makes an offset line by the line and the offset.") , 
					   _("Input an offset.") , 
					   "", 
					   str);
	if (Ret == -1) return 0;
	rtn.l = atof(str);

	rtn.sx[1] = select_search_num(1)->select->diagram_point.cad_point->sx;
	rtn.sy[1] = select_search_num(1)->select->diagram_point.cad_point->sy;
	rtn.ex[1] = select_search_num(1)->select->diagram_point.cad_point->ex;
	rtn.ey[1] = select_search_num(1)->select->diagram_point.cad_point->ey;
	lo(&rtn);

	OnlyOneCAD[1].code = 1;
	OnlyOneCAD[1].sx = sg(rtn.sx[2], 6);
	OnlyOneCAD[1].sy = sg(rtn.sy[2], 6);
	OnlyOneCAD[1].ex = sg(rtn.ex[2], 6);
	OnlyOneCAD[1].ey = sg(rtn.ey[2], 6);
	OnlyOneCAD[2].code = 1;
	OnlyOneCAD[2].sx = sg(rtn.sx[3], 6);
	OnlyOneCAD[2].sy = sg(rtn.sy[3], 6);
	OnlyOneCAD[2].ex = sg(rtn.ex[3], 6);
	OnlyOneCAD[2].ey = sg(rtn.ey[3], 6);
	OnlyOneIndex = 1;
	OnlyOneEntry = 2;
	OnlyOneKeepReturnFunc = ReturnFunc;
	ReturnFunc = MouseRet_OnlyOne;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	OnlyOne_mode = 210;
	OnlyOne(3);
	return 1;
}



/* ---------------------------------------------------------------------
 * 線と線で線   ll_l   ２線が違う   ２等分線
 * 
 */
int ll_l(void)
{
	struct RtnDat rtn;
	CAD cad;


	rtn.sx[1] = select_search_num(1)->select->diagram_point.cad_point->sx;
	rtn.sy[1] = select_search_num(1)->select->diagram_point.cad_point->sy;
	rtn.ex[1] = select_search_num(1)->select->diagram_point.cad_point->ex;
	rtn.ey[1] = select_search_num(1)->select->diagram_point.cad_point->ey;
	rtn.sx[2] = select_search_num(2)->select->diagram_point.cad_point->sx;
	rtn.sy[2] = select_search_num(2)->select->diagram_point.cad_point->sy;
	rtn.ex[2] = select_search_num(2)->select->diagram_point.cad_point->ex;
	rtn.ey[2] = select_search_num(2)->select->diagram_point.cad_point->ey;
	lll(&rtn);
	if (rtn.type == 0) {
		MsgBox("SagCAD", "Error !", _("2 straight lines are parallel.") , NULL, NULL, "OK");
		return 0;
	}
	/* 線データを登録 */
	cad.code = 1;
	cad.layer = NowLayer;
	cad.style = NowStyle;
	cad.color = NowColor;
	cad.sx = rtn.sx[3];
	cad.sy = rtn.sy[3];
	cad.ex = rtn.ex[3];
	cad.ey = rtn.ey[3];
	cad.cx = 0;
	cad.cy = 0;
	cad.r  = 0;
	cad.OnScreen = 0;
	undo_index_plus();
	cad_list_add_first_with_undo(&cad, &cad_list_info);
	SelectCadDraw(drawing_area, &cad, SCD_ORG);

	return 1;
}



/* ---------------------------------------------------------------------
 * 線と円で線   lc_l   円に接し、直線に平行な直線 (1)
 * 
 */
int lc_l(void)
{
	struct RtnDat rtn;
	CAD sen, circle;


	if (select_search_num(1)->select->diagram_point.cad_point->code == 1) {
		sen = *select_search_num(1)->select->diagram_point.cad_point;
		circle = *select_search_num(2)->select->diagram_point.cad_point;
	}
	else if (select_search_num(2)->select->diagram_point.cad_point->code == 1) {
		sen = *select_search_num(2)->select->diagram_point.cad_point;
		circle = *select_search_num(1)->select->diagram_point.cad_point;
	}

	/* LA	直線の角度 */
	rtn.sx[1] = sen.sx;
	rtn.sy[1] = sen.sy;
	rtn.ex[1] = sen.ex;
	rtn.ey[1] = sen.ey;
	la(&rtn);
	
	/* CAL	 円に接する角度Ａの接線 */
	rtn.cx[1] = circle.cx;
	rtn.cy[1] = circle.cy;
	rtn.r[1] = circle.r;
	rtn.l = sagcad_system.Length;
	cal(&rtn);
	
	OnlyOneCAD[1].code = 1;
	OnlyOneCAD[1].sx = sg(rtn.sx[1], 6);
	OnlyOneCAD[1].sy = sg(rtn.sy[1], 6);
	OnlyOneCAD[1].ex = sg(rtn.ex[1], 6);
	OnlyOneCAD[1].ey = sg(rtn.ey[1], 6);
	OnlyOneCAD[2].code = 1;
	OnlyOneCAD[2].sx = sg(rtn.sx[2], 6);
	OnlyOneCAD[2].sy = sg(rtn.sy[2], 6);
	OnlyOneCAD[2].ex = sg(rtn.ex[2], 6);
	OnlyOneCAD[2].ey = sg(rtn.ey[2], 6);
	
	if (rtn.type != 0) {
		OnlyOneIndex = 1;
		OnlyOneEntry = rtn.type;
		OnlyOneKeepReturnFunc = ReturnFunc;
		ReturnFunc = MouseRet_OnlyOne;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		OnlyOne_mode = 210;
		OnlyOne(3);
	}

	return 1;
}



/* ---------------------------------------------------------------------
 * 円と円で線   cc_l   ２円が違う  ２円に接する接線 (1)
 * 
 */
int cc_l(void)
{
	struct RtnDat rtn;

	rtn.cx[1]	= select_search_num(1)->select->diagram_point.cad_point->cx;
	rtn.cy[1]	= select_search_num(1)->select->diagram_point.cad_point->cy;
	rtn.r[1]	= select_search_num(1)->select->diagram_point.cad_point->r;
	rtn.cx[2]	= select_search_num(2)->select->diagram_point.cad_point->cx;
	rtn.cy[2]	= select_search_num(2)->select->diagram_point.cad_point->cy;
	rtn.r[2]	= select_search_num(2)->select->diagram_point.cad_point->r;
	ccl(&rtn);

	OnlyOneCAD[1].code = 1;
	OnlyOneCAD[1].sx = sg(rtn.sx[1], 6);
	OnlyOneCAD[1].sy = sg(rtn.sy[1], 6);
	OnlyOneCAD[1].ex = sg(rtn.ex[1], 6);
	OnlyOneCAD[1].ey = sg(rtn.ey[1], 6);
	OnlyOneCAD[2].code = 1;
	OnlyOneCAD[2].sx = sg(rtn.sx[2], 6);
	OnlyOneCAD[2].sy = sg(rtn.sy[2], 6);
	OnlyOneCAD[2].ex = sg(rtn.ex[2], 6);
	OnlyOneCAD[2].ey = sg(rtn.ey[2], 6);
	OnlyOneCAD[3].code = 1;
	OnlyOneCAD[3].sx = sg(rtn.sx[3], 6);
	OnlyOneCAD[3].sy = sg(rtn.sy[3], 6);
	OnlyOneCAD[3].ex = sg(rtn.ex[3], 6);
	OnlyOneCAD[3].ey = sg(rtn.ey[3], 6);
	OnlyOneCAD[4].code = 1;
	OnlyOneCAD[4].sx = sg(rtn.sx[4], 6);
	OnlyOneCAD[4].sy = sg(rtn.sy[4], 6);
	OnlyOneCAD[4].ex = sg(rtn.ex[4], 6);
	OnlyOneCAD[4].ey = sg(rtn.ey[4], 6);

	if (rtn.type != 0) {
		OnlyOneIndex = 1;
		OnlyOneEntry = rtn.type;
		OnlyOneKeepReturnFunc = ReturnFunc;
		ReturnFunc = MouseRet_OnlyOne;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		OnlyOne_mode = 210;
		OnlyOne(3);
	}

	return 1;
}



/* ---------------------------------------------------------------------
 * 円と円で線   c_l   ２円が同一   円に角度 ANGLE で接する接線
 * 
 */
int c_l(void)
{
	int Ret;
	struct RtnDat rtn;
	char str[256];


	/* 数値入力ダイアログボックス表示 */
	strcpy(str, "");
	Ret = CulcInputBox(MainWindow, 
					   _("Makes a tangent by the circle and the angle.") , 
					   _("Input an angle (DEG)") , 
					   "", 
					   str);
	if (Ret == -1) return 0;
	rtn.angle = atof(str);

	/* CAL	 円に接する角度Ａの接線 */
	rtn.cx[1] = select_search_num(1)->select->diagram_point.cad_point->cx;
	rtn.cy[1] = select_search_num(1)->select->diagram_point.cad_point->cy;
	rtn.r[1] = select_search_num(1)->select->diagram_point.cad_point->r;
	rtn.l = sagcad_system.Length;
	cal(&rtn);
	
	OnlyOneCAD[1].code = 1;
	OnlyOneCAD[1].sx = sg(rtn.sx[1], 6);
	OnlyOneCAD[1].sy = sg(rtn.sy[1], 6);
	OnlyOneCAD[1].ex = sg(rtn.ex[1], 6);
	OnlyOneCAD[1].ey = sg(rtn.ey[1], 6);
	OnlyOneCAD[2].code = 1;
	OnlyOneCAD[2].sx = sg(rtn.sx[2], 6);
	OnlyOneCAD[2].sy = sg(rtn.sy[2], 6);
	OnlyOneCAD[2].ex = sg(rtn.ex[2], 6);
	OnlyOneCAD[2].ey = sg(rtn.ey[2], 6);
	
	if (rtn.type != 0) {
		OnlyOneIndex = 1;
		OnlyOneEntry = rtn.type;
		OnlyOneKeepReturnFunc = ReturnFunc;
		ReturnFunc = MouseRet_OnlyOne;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		OnlyOne_mode = 210;
		OnlyOne(3);
	}

	return 1;
}



/* -------------------------------------------------------------------
 * 点と楕円で線   pe_l
 */
int pe_l(void)
{
	struct RtnDat rtn;
	SELECT *sel_1, *sel_2, *sel;
	int i;


	sel_1 = select_search_num(1)->select;
	sel_2 = select_search_num(2)->select;

	/* sel_1 が楕円となるようにする */
	if (sel_1->index == 2) {
		sel = sel_1;
		sel_1 = sel_2;
		sel_2 = sel;
	}

	rtn.sx[1] = sel_2->diagram_point.cad_point->sx;
	rtn.sy[1] = sel_2->diagram_point.cad_point->sy;

	pel(&rtn, *sel_1->diagram_point.ellipse_point);

	if (rtn.type == 0) {
		MsgBox("SagCAD", "Error !", _("It thinks that the point is in the ellipse.") , NULL, NULL, "OK");
		return 0;
	}

	if (rtn.type > 0) {
		for (i = 1 ; i < rtn.type + 1 ; i++) {
			OnlyOneCAD[i].code = 1;
			OnlyOneCAD[i].layer = NowLayer;
			OnlyOneCAD[i].style = NowStyle;
			OnlyOneCAD[i].color = NowColor;
			OnlyOneCAD[i].sx = sg(rtn.sx[1], 6);
			OnlyOneCAD[i].sy = sg(rtn.sy[1], 6);
			OnlyOneCAD[i].ex = sg(rtn.ex[i], 6);
			OnlyOneCAD[i].ey = sg(rtn.ey[i], 6);
			OnlyOneCAD[i].cx = 0;
			OnlyOneCAD[i].cy = 0;
			OnlyOneCAD[i].r  = 0;
			OnlyOneCAD[i].OnScreen = 0;
		}
		OnlyOneIndex = 1;
		OnlyOneEntry = rtn.type;
		OnlyOneKeepReturnFunc = ReturnFunc;
		ReturnFunc = MouseRet_OnlyOne;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		OnlyOne_mode = 210;
		OnlyOne(3);
	}
	return 1;
}



/* -------------------------------------------------------------------
 * 円と楕円で線   ce_l
 */
int ce_l(void)
{
	struct RtnDat rtn;
	SELECT *sel_1, *sel_2, *sel;
	ELLIPSE ellipse;
	int i;


	sel_1 = select_search_num(1)->select;
	sel_2 = select_search_num(2)->select;

	/* sel_1 が楕円となるようにする */
	if (sel_1->index == 2) {
		sel = sel_1;
		sel_1 = sel_2;
		sel_2 = sel;
	}

	ellipse.cx = sel_2->diagram_point.cad_point->cx;
	ellipse.cy = sel_2->diagram_point.cad_point->cy;
	ellipse.dx = sel_2->diagram_point.cad_point->r;
	ellipse.dy = 0;
	ellipse.k  = 1;
	ellipse.sa = 0;
	ellipse.ea = 360;

	ellipse_to_ellipse(&rtn, *sel_1->diagram_point.ellipse_point, ellipse);

	if (rtn.type == 0) {
		MsgBox("SagCAD", "Error !", _("It thinks that the point is in the ellipse.") , NULL, NULL, "OK");
		return 0;
	}

	if (rtn.type > 0) {
		for (i = 1 ; i < rtn.type + 1 ; i++) {
			OnlyOneCAD[i].code = 1;
			OnlyOneCAD[i].layer = NowLayer;
			OnlyOneCAD[i].style = NowStyle;
			OnlyOneCAD[i].color = NowColor;
			OnlyOneCAD[i].sx = sg(rtn.sx[i], 6);
			OnlyOneCAD[i].sy = sg(rtn.sy[i], 6);
			OnlyOneCAD[i].ex = sg(rtn.ex[i], 6);
			OnlyOneCAD[i].ey = sg(rtn.ey[i], 6);
			OnlyOneCAD[i].cx = 0;
			OnlyOneCAD[i].cy = 0;
			OnlyOneCAD[i].r  = 0;
			OnlyOneCAD[i].OnScreen = 0;
		}
		OnlyOneIndex = 1;
		OnlyOneEntry = rtn.type;
		OnlyOneKeepReturnFunc = ReturnFunc;
		ReturnFunc = MouseRet_OnlyOne;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		OnlyOne_mode = 210;
		OnlyOne(3);
	}
	return 1;
}



/* -------------------------------------------------------------------
 * 楕円と楕円で線   ee_l
 */
int ee_l(void)
{
	struct RtnDat rtn;
	SELECT *sel_1, *sel_2;
	int i;


	sel_1 = select_search_num(1)->select;
	sel_2 = select_search_num(2)->select;

	ellipse_to_ellipse(&rtn, *sel_1->diagram_point.ellipse_point, *sel_2->diagram_point.ellipse_point);

	if (rtn.type == 0) {
		MsgBox("SagCAD", "Error !", _("Tangent not found.") , NULL, NULL, "OK");
		return 0;
	}

	if (rtn.type > 0) {
		for (i = 1 ; i < rtn.type + 1 ; i++) {
			OnlyOneCAD[i].code = 1;
			OnlyOneCAD[i].layer = NowLayer;
			OnlyOneCAD[i].style = NowStyle;
			OnlyOneCAD[i].color = NowColor;
			OnlyOneCAD[i].sx = sg(rtn.sx[i], 6);
			OnlyOneCAD[i].sy = sg(rtn.sy[i], 6);
			OnlyOneCAD[i].ex = sg(rtn.ex[i], 6);
			OnlyOneCAD[i].ey = sg(rtn.ey[i], 6);
			OnlyOneCAD[i].cx = 0;
			OnlyOneCAD[i].cy = 0;
			OnlyOneCAD[i].r  = 0;
			OnlyOneCAD[i].OnScreen = 0;
		}
		OnlyOneIndex = 1;
		OnlyOneEntry = rtn.type;
		OnlyOneKeepReturnFunc = ReturnFunc;
		ReturnFunc = MouseRet_OnlyOne;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		OnlyOne_mode = 210;
		OnlyOne(3);
	}
	return 1;
}





/* ---------------------------------------------------------------------
 * 線コマンドを選択したとき
 * 
 */
int CreateLine(GtkWidget *widget)
{
//#define CREATELINE
	SELECT *sel_1, *sel_2, *sel;
	int debug = 0;


#ifdef CREATELINE
	debug = 1;
#endif

	if (debug > 0) g_print("DrawMode.c : CreateLine() : 線コマンド in\n");


	sel_1 = select_search_num(1)->select;
	sel_2 = select_search_num(2)->select;


	/* 点,線,円弧,円のみのとき */
	if (sel_1->index == 2 
		&& 
		sel_2->index == 2 ) 
	{

		/* 点と点で線 */
		if (	sel_1->diagram_point.cad_point->code == 0 
				&& 
				sel_2->diagram_point.cad_point->code == 0
			) 
		{
			/* ２点が同一   p_l   角度と長さ */
			if (	sel_1->diagram_point.cad_point 
						== sel_2->diagram_point.cad_point 
					|| 
					(
					sel_1->diagram_point.cad_point->sx 
						== sel_2->diagram_point.cad_point->sx 
					&& 
					sel_1->diagram_point.cad_point->sy 
						== sel_2->diagram_point.cad_point->sy
					)
				) 
			{
				p_l();
				return 1;
			}
			/* ２点が違う   pp_l   ２点を始点と終点とする直線 */
			if (sel_1->diagram_point.cad_point 
					!= sel_2->diagram_point.cad_point) 
			{
				pp_l();
				return 1;
			}
		}


		/* 点と線で線   pl_l   点を通る直線に平行な直線 */
		else if (	(
					sel_1->diagram_point.cad_point->code == 0 
					&& 
					sel_2->diagram_point.cad_point->code == 1
					) 
					|| 
					(
					sel_1->diagram_point.cad_point->code == 1 
					&& 
					sel_2->diagram_point.cad_point->code == 0
					)
				) 
		{
			pl_l();
			return 1;
		}


		/* 点と円で線   pc_l   点を通る円の接線 (1) */
		else if (	(
					sel_1->diagram_point.cad_point->code == 0 
					&& 
					sel_2->diagram_point.cad_point->code == 2
					)
					|| 
					(
					sel_1->diagram_point.cad_point->code == 0 
					&& 
					sel_2->diagram_point.cad_point->code == 4
					)
				) 
		{
			pc_l();
			return 1;
		}

		/* 点と円で線   pc_l   点を通る円の接線 (2) */
		else if (	(
					sel_1->diagram_point.cad_point->code == 2 
					&& 
					sel_2->diagram_point.cad_point->code == 0
					)
					|| 
					(
					sel_1->diagram_point.cad_point->code == 4 
					&& 
					sel_2->diagram_point.cad_point->code == 0
					)
				)
		{
			pc_l();
			return 1;
		}


		// if (cad[MODE200).code = 0 && cad[MODE201).code = 4){}
		// if (cad[MODE200).code = 4 && cad[MODE201).code = 0){}


		/* 線と線で線 */
		else if (sel_1->diagram_point.cad_point->code == 1 
				 && 
				 sel_2->diagram_point.cad_point->code == 1
				 ) 
		{
			/* ２線が同一   l_l   直線のオフセット */
			if (sel_1->diagram_point.cad_point == sel_2->diagram_point.cad_point) {
				l_l();
				return 1;
			}
			/* ２線が違う  ll_l   ２等分線 */
			if (sel_1->diagram_point.cad_point != sel_2->diagram_point.cad_point) {
				ll_l();
				return 1;
			}
		}


		/* 線と円で線   lc_l   円に接し、直線に平行な直線 (1) */
		else if (	(
					sel_1->diagram_point.cad_point->code == 1 
					&& 
					sel_2->diagram_point.cad_point->code == 2
					)
					|| 
					(
					sel_1->diagram_point.cad_point->code == 1 
					&& 
					sel_2->diagram_point.cad_point->code == 4
					)
				)
		{
			lc_l();
			return 1;
		}


		/* 線と円で線  円に接し、直線に平行な直線 (2) */
		else if (	(
					sel_1->diagram_point.cad_point->code == 2 
					&& 
					sel_2->diagram_point.cad_point->code == 1
					) 
					|| 
					(
					sel_1->diagram_point.cad_point->code == 4 
					&& 
					sel_2->diagram_point.cad_point->code == 1
					)
				)
		{
			lc_l();
			return 1;
		}


		/* 円と円で線 */
		/* ２円が違う  ２円に接する接線 (1) */
	//	if ((sel_1->diagram_point.cad_point->code == 2 && sel_2->diagram_point.cad_point->code == 4)
	//		|| (sel_1->diagram_point.cad_point->code == 4 && sel_2->diagram_point.cad_point->code == 2))
	//	{
	//	}


		/* ２円が違う  ２円に接する接線 (2) */
		else if (	(
					sel_1->diagram_point.cad_point->code == 2 
					&& 
					sel_2->diagram_point.cad_point->code == 2
					)
					|| 
					(
					sel_1->diagram_point.cad_point->code == 4 
					&& 
					sel_2->diagram_point.cad_point->code == 4
					)
					|| 
					(
					sel_1->diagram_point.cad_point->code == 2 
					&& 
					sel_2->diagram_point.cad_point->code == 4
					)
					|| 
					(
					sel_1->diagram_point.cad_point->code == 4 
					&& 
					sel_2->diagram_point.cad_point->code == 2
					)
				)
		{
			/* ２円が同一  円に角度ANGLEで接する接線 */
			if (sel_1->diagram_point.cad_point == sel_2->diagram_point.cad_point) {
				if (debug > 0) g_print("２円が同一  円に角度ANGLEで接する接線\n");
				c_l();
			}
			/* ２円が違う  ２円に接する接線 */
			if (sel_1->diagram_point.cad_point != sel_2->diagram_point.cad_point) {
				if (debug > 0) g_print("２円が違う  ２円に接する接線\n");
				cc_l();
			}
		}
	}



	/* 楕円があるとき */
	else if (sel_1->index == 16 || sel_2->index == 16 ) {
		/* sel_1 が楕円となるようにする */
		if (sel_1->index == 2) {
			sel = sel_1;
			sel_1 = sel_2;
			sel_2 = sel;
		}

		/* 楕円と点 */
		if (sel_2->index == 2) {
			if (sel_2->diagram_point.cad_point->code == 0) {
				pe_l();
				return 1;
			}
		}

		/* 楕円と線 */
		if (sel_2->index == 2) {
			if (sel_2->diagram_point.cad_point->code == 1) {
				// 無し
				return 0;
			}
		}

		/* 楕円と円(円弧) */
		if (sel_2->index == 2) {
			if (sel_2->diagram_point.cad_point->code == 2 || sel_2->diagram_point.cad_point->code == 4) {
				ce_l();
				return 1;
			}
		}

		/* 楕円と楕円 */
		if (sel_2->index == 16) {
			ee_l();
			return 1;
		}
	}



	return 0;
}





/* ---------------------------------------------------------------------
 * 点と点で円   ２点が同一   p_c   点を中心とする半径Ｒの円
 * 
 */
int p_c(void)
{
	int Ret;
	struct RtnDat rtn;
	CAD cad;
	char str[256];


	/* 数値入力ダイアログボックス表示 */
	strcpy(str, "");
	Ret = CulcInputBox(MainWindow, 
					   _("Makes a circle by the circle and the radius."), 
					   _("Input a radius.") , 
					   "", 
					   str);
	if (Ret == -1) return 0;
	rtn.r[1] = atof(str);

	/* 円データを登録 */
	cad.code = 4;
	cad.layer = NowLayer;
	cad.style = NowStyle;
	cad.color = NowColor;
	cad.sx = 0;
	cad.sy = 0;
	cad.ex = 0;
	cad.ey = 0;
	cad.cx = select_search_num(1)->select->diagram_point.cad_point->sx;
	cad.cy = select_search_num(1)->select->diagram_point.cad_point->sy;
	cad.r  = rtn.r[1];
	cad.OnScreen = 0;
	undo_index_plus();
	cad_list_add_first_with_undo(&cad, &cad_list_info);
	SelectCadDraw(drawing_area, &cad, SCD_ORG);

	return 1;
}



/* ---------------------------------------------------------------------
 * 点と点で円   ２点が違う   pp_c   ２点を通る半径Ｒの円
 * 
 */
int pp_c(void)
{
	int Ret;
	struct RtnDat rtn;
	CAD cad;
	char str[256];


	rtn.sx[1] = select_search_num(1)->select->diagram_point.cad_point->sx;
	rtn.sy[1] = select_search_num(1)->select->diagram_point.cad_point->sy;
	rtn.sx[2] = select_search_num(2)->select->diagram_point.cad_point->sx;
	rtn.sy[2] = select_search_num(2)->select->diagram_point.cad_point->sy;

	/* 数値入力ダイアログボックス表示 */
	strcpy(str, "");
	Ret = CulcInputBox(MainWindow, 
					   _("The circle with the radius R which passes two points.") , 
					   _("Input a radius."), 
					   "", 
					   str);
	if (Ret == -1) return 0;
	rtn.r[1] = atof(str);

	ppc(&rtn);

	if (rtn.type == 1) {
		/* 円データを登録 */
		cad.code = 4;
		cad.layer = NowLayer;
		cad.style = NowStyle;
		cad.color = NowColor;
		cad.sx = 0;
		cad.sy = 0;
		cad.ex = 0;
		cad.ey = 0;
		cad.cx = rtn.cx[1];
		cad.cy = rtn.cy[1];
		cad.r  = rtn.r[1];
		cad.OnScreen = 0;
		undo_index_plus();
		cad_list_add_first_with_undo(&cad, &cad_list_info);
		SelectCadDraw(drawing_area, &cad, SCD_ORG);
		return 1;
	}

	else if (rtn.type == 2) {
		OnlyOneCAD[1].code =	4;
		OnlyOneCAD[1].cx =		sg(rtn.cx[1],6);
		OnlyOneCAD[1].cy =		sg(rtn.cy[1],6);
		OnlyOneCAD[1].r =		sg(rtn.r[1],6);
		OnlyOneCAD[2].code =	4;
		OnlyOneCAD[2].cx =		sg(rtn.cx[2],6);
		OnlyOneCAD[2].cy =		sg(rtn.cy[2],6);
		OnlyOneCAD[2].r =		sg(rtn.r[1],6);
		OnlyOneIndex = 1;
		OnlyOneEntry = 2;
		OnlyOneKeepReturnFunc = ReturnFunc;
		ReturnFunc = MouseRet_OnlyOne;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		OnlyOne_mode = 210;
		OnlyOne(3);
		return 1;
	}
	else if (rtn.type == 0) {
		return 0;
	}

	return 0;
}



/* ---------------------------------------------------------------------
 * 点と線で円   pl_c   １点を通り、直線に接する半径Ｒの円 (1)
 * 
 */
int pl_c(void)
{
	int Ret;
	struct RtnDat rtn;
	CAD cad, point, sen;
	char str[256];


	if (select_search_num(1)->select->diagram_point.cad_point->code == 0) {
		point = *select_search_num(1)->select->diagram_point.cad_point;
		sen = *select_search_num(2)->select->diagram_point.cad_point;
	}
	else if (select_search_num(2)->select->diagram_point.cad_point->code == 0) {
		point = *select_search_num(2)->select->diagram_point.cad_point;
		sen = *select_search_num(1)->select->diagram_point.cad_point;
	}

	/* PLC		１点を通り直線に接する円 */
	/* 数値入力ダイアログボックス表示 */
	strcpy(str, "");
	Ret = CulcInputBox(MainWindow, 
					   _("Circle with the radius R which comes in touch with a straight line through the point"), 
					   _("Input a radius."), 
					   "", 
					   str);
	if (Ret == -1) return 0;
	rtn.r[3] = atof(str);

	rtn.sx[1] = point.sx;
	rtn.sy[1] = point.sy;
	rtn.sx[2] = sen.sx;
	rtn.sy[2] = sen.sy;
	rtn.ex[2] = sen.ex;
	rtn.ey[2] = sen.ey;
	plc(&rtn);
	
	if (rtn.type == 0) {
		MsgBox("SagCAD", "Error !", _("It thinks that radius R is small.") , NULL, NULL, "OK");
		return 0;
	}
	
	if (rtn.type == 1) {
		/* 円データを登録 */
		cad.code = 4;
		cad.layer = NowLayer;
		cad.style = NowStyle;
		cad.color = NowColor;
		cad.sx = 0;
		cad.sy = 0;
		cad.ex = 0;
		cad.ey = 0;
		cad.cx = rtn.cx[3];
		cad.cy = rtn.cy[3];
		cad.r  = rtn.r[3];
		cad.OnScreen = 0;
		undo_index_plus();
		cad_list_add_first_with_undo(&cad, &cad_list_info);
		SelectCadDraw(drawing_area, &cad, SCD_ORG);
		return 1;
	}
	
	if (rtn.type == 2) {
		OnlyOneCAD[1].code = 4;
		OnlyOneCAD[1].cx = sg(rtn.cx[3],6);
		OnlyOneCAD[1].cy = sg(rtn.cy[3],6);
		OnlyOneCAD[1].r = sg(rtn.r[3],6);
		OnlyOneCAD[2].code = 4;
		OnlyOneCAD[2].cx = sg(rtn.cx[4],6);
		OnlyOneCAD[2].cy = sg(rtn.cy[4],6);
		OnlyOneCAD[2].r = sg(rtn.r[4],6);
		/* 円選択 */
		OnlyOneIndex = 1;
		OnlyOneEntry = 2;
		OnlyOneKeepReturnFunc = ReturnFunc;
		ReturnFunc = MouseRet_OnlyOne;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		OnlyOne_mode = 210;
		OnlyOne(3);
		return 1;
	}
	return 0;
}



/* ---------------------------------------------------------------------
 * 点と円で円   pc_c   １点を通り、円に接する円
 * 
 */
int pc_c(void)
{
	int Ret;
	struct RtnDat rtn;
	CAD point, circle;
	char str[256];


	if (select_search_num(1)->select->diagram_point.cad_point->code == 0) {
		point = *select_search_num(1)->select->diagram_point.cad_point;
		circle = *select_search_num(2)->select->diagram_point.cad_point;
	}
	else if (select_search_num(2)->select->diagram_point.cad_point->code == 0) {
		point = *select_search_num(2)->select->diagram_point.cad_point;
		circle = *select_search_num(1)->select->diagram_point.cad_point;
	}


	/* PCC		１点を通り円に接する円 */
	/* 数値入力ダイアログボックス表示 */
	strcpy(str, "");
	Ret = CulcInputBox(MainWindow, 
					   _("Circle with the radius R which comes in touch with a circle through the point") , 
					   _("Input a radius.") , 
					   "", 
					   str);
	if (Ret == -1) return 0;
	rtn.r[2] = atof(str);

	rtn.sx[1] = point.sx;
	rtn.sy[1] = point.sy;
	rtn.cx[1] = circle.cx;
	rtn.cy[1] = circle.cy;
	rtn.r[1] = circle.r;
	
	pcc(&rtn);
	if (rtn.type != 0) {
		OnlyOneCAD[1].code = 4;
		OnlyOneCAD[1].cx = sg(rtn.cx[2], 6);
		OnlyOneCAD[1].cy = sg(rtn.cy[2], 6);
		OnlyOneCAD[1].r = sg(rtn.r[2],6);
		if (rtn.type >= 2) {
			OnlyOneCAD[2].code = 4;
			OnlyOneCAD[2].cx = sg(rtn.cx[3], 6);
			OnlyOneCAD[2].cy = sg(rtn.cy[3], 6);
			OnlyOneCAD[2].r = sg(rtn.r[3], 6);
		}
		if (rtn.type >= 3) {
			OnlyOneCAD[3].code = 4;
			OnlyOneCAD[3].cx = sg(rtn.cx[4], 6);
			OnlyOneCAD[3].cy = sg(rtn.cy[4], 6);
			OnlyOneCAD[3].r = sg(rtn.r[4], 6);
		}
		if (rtn.type == 4) {
			OnlyOneCAD[4].code = 4;
			OnlyOneCAD[4].cx = sg(rtn.cx[5], 6);
			OnlyOneCAD[4].cy = sg(rtn.cy[5], 6);
			OnlyOneCAD[4].r = sg(rtn.r[5], 6);
		}
		/* 円選択 */
		OnlyOneIndex = 1;
		OnlyOneEntry = rtn.type;
		OnlyOneKeepReturnFunc = ReturnFunc;
		ReturnFunc = MouseRet_OnlyOne;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		OnlyOne_mode = 210;
		OnlyOne(3);
		return 1;
	}
	else if (rtn.type == 0) {
		MsgBox("SagCAD", "Error !", _("It thinks that radius R is different.") , NULL, NULL, "OK");
		return 0;
	}

	return 0;
}



/* ---------------------------------------------------------------------
 * 線と線で円   ll_c   ２線が違う   ２直線に接する半径Ｒの円
 * 
 */
int ll_c(void)
{
	int Ret;
	struct RtnDat rtn;
	char str[256];


	/* 数値入力ダイアログボックス表示 */
	strcpy(str, "");
	Ret = CulcInputBox(MainWindow, 
					   _("Circle with the radius R which comes in touch with 2 straight lines") , 
					   _("Input a radius.") , 
					   "" , 
					   str);
	if (Ret == -1) return 0;
	rtn.r[1] = atof(str);

	rtn.sx[1] = select_search_num(1)->select->diagram_point.cad_point->sx;
	rtn.sy[1] = select_search_num(1)->select->diagram_point.cad_point->sy;
	rtn.ex[1] = select_search_num(1)->select->diagram_point.cad_point->ex;
	rtn.ey[1] = select_search_num(1)->select->diagram_point.cad_point->ey;
	rtn.sx[2] = select_search_num(2)->select->diagram_point.cad_point->sx;
	rtn.sy[2] = select_search_num(2)->select->diagram_point.cad_point->sy;
	rtn.ex[2] = select_search_num(2)->select->diagram_point.cad_point->ex;
	rtn.ey[2] = select_search_num(2)->select->diagram_point.cad_point->ey;
	llc(&rtn);

	if (rtn.type == 0) {
		MsgBox("SagCAD", "Error !", _("2 straight lines are parallel.") , NULL, NULL, "OK");
		return 0;
	}

	OnlyOneCAD[1].code = 4;
	OnlyOneCAD[1].cx = sg(rtn.cx[1],6);
	OnlyOneCAD[1].cy = sg(rtn.cy[1],6);
	OnlyOneCAD[1].r = sg(rtn.r[1],6);
	OnlyOneCAD[2].code = 4;
	OnlyOneCAD[2].cx = sg(rtn.cx[2],6);
	OnlyOneCAD[2].cy = sg(rtn.cy[2],6);
	OnlyOneCAD[2].r = sg(rtn.r[1],6);
	OnlyOneCAD[3].code = 4;
	OnlyOneCAD[3].cx = sg(rtn.cx[3],6);
	OnlyOneCAD[3].cy = sg(rtn.cy[3],6);
	OnlyOneCAD[3].r = sg(rtn.r[1],6);
	OnlyOneCAD[4].code = 4;
	OnlyOneCAD[4].cx = sg(rtn.cx[4],6);
	OnlyOneCAD[4].cy = sg(rtn.cy[4],6);
	OnlyOneCAD[4].r = sg(rtn.r[1],6);
	/* 円選択 */
	OnlyOneIndex = 1;
	OnlyOneEntry = 4;
	OnlyOneKeepReturnFunc = ReturnFunc;
	ReturnFunc = MouseRet_OnlyOne;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	OnlyOne_mode = 210;
	OnlyOne(3);
	return 1;
}



/* ---------------------------------------------------------------------
 * 線と円で円   lc_c   直線と円に接する半径Ｒの円
 * 
 */
int lc_c(void)
{
	int Ret;
	struct RtnDat rtn;
	CAD cad, sen, circle;
	char str[256];
	int i;

	if (select_search_num(1)->select->diagram_point.cad_point->code == 1) {
		sen = *select_search_num(1)->select->diagram_point.cad_point;
		circle = *select_search_num(2)->select->diagram_point.cad_point;
	}
	else if (select_search_num(2)->select->diagram_point.cad_point->code == 1) {
		sen = *select_search_num(2)->select->diagram_point.cad_point;
		circle = *select_search_num(1)->select->diagram_point.cad_point;
	}

	/* LCC		直線と円に接する円 */
	/* 数値入力ダイアログボックス表示 */
	strcpy(str, "");
	Ret = CulcInputBox(MainWindow, 
					   _("The circle of the radius R which touches a straight line and a circle") , 
					   _("Input a radius.") , 
					   "", 
					   str);
	if (Ret == -1) return 0;
	rtn.r[2] = atof(str);

	rtn.sx[1] = sen.sx;
	rtn.sy[1] = sen.sy;
	rtn.ex[1] = sen.ex;
	rtn.ey[1] = sen.ey;
	rtn.cx[1] = circle.cx;
	rtn.cy[1] = circle.cy;
	rtn.r[1] = circle.r;
	lcc(&rtn);

	if (rtn.type > 1) {
		i = 1;
		while (i <= rtn.type) {
			OnlyOneCAD[i].code = 4;
			OnlyOneCAD[i].cx = sg(rtn.cx[i+1],6);
			OnlyOneCAD[i].cy = sg(rtn.cy[i+1],6);
			OnlyOneCAD[i].r = sg(rtn.r[i+1],6);
			i++;
		}
		/* 円選択 */
		OnlyOneIndex = 1;
		OnlyOneEntry = rtn.type;
		OnlyOneKeepReturnFunc = ReturnFunc;
		ReturnFunc = MouseRet_OnlyOne;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		OnlyOne_mode = 210;
		OnlyOne(3);
		return 1;
	}

	else if (rtn.type == 1) {
		/* 円データを登録 */
		cad.code = 4;
		cad.layer = NowLayer;
		cad.style = NowStyle;
		cad.color = NowColor;
		cad.sx = 0;
		cad.sy = 0;
		cad.ex = 0;
		cad.ey = 0;
		cad.cx = rtn.cx[2];
		cad.cy = rtn.cy[2];
		cad.r  = rtn.r[2];
		cad.OnScreen = 0;
		undo_index_plus();
		cad_list_add_first_with_undo(&cad, &cad_list_info);
		SelectCadDraw(drawing_area, &cad, SCD_ORG);
		return 1;
	}
	else if (rtn.type == 0) {
		MsgBox("SagCAD", "Eror !", _("It thinks that radius R is different.") , NULL, NULL, "OK");
		return 0;
	}

	return 0;
}



/* ---------------------------------------------------------------------
 * 円と円で円   c_c   ２円が同一   同心円
 * 
 */
int c_c(void)
{
	int Ret;
	struct RtnDat rtn, PAPH, LAH;
	char str[256];
	double sx, sy, ex, ey;
	CAD cad;


	/* 数値入力ダイアログボックス表示 */
	strcpy(str, "");
	Ret = CulcInputBox(MainWindow, 
					   _("Concentric circle") , 
					   _("Input a radius.") , 
					   "", 
					   str);
	if (Ret == -1) return 0;
	rtn.r[1] = atof(str);


	/* マイナス値ならば元になる円の半径の差 */
	if (rtn.r[1] < 0) {
		rtn.r[1] = -1 * rtn.r[1];
		
		/* ---	--- */
		if (select_search_num(1)->select->diagram_point.cad_point->r > rtn.r[1]) {
			if(select_search_num(1)->select->diagram_point.cad_point->code == 4) {
				OnlyOneCAD[1].code = 4;
				OnlyOneCAD[1].cx = select_search_num(1)->select->diagram_point.cad_point->cx;
				OnlyOneCAD[1].cy = select_search_num(1)->select->diagram_point.cad_point->cy;
				OnlyOneCAD[1].r = select_search_num(1)->select->diagram_point.cad_point->r + rtn.r[1];
				OnlyOneCAD[2].code = 4;
				OnlyOneCAD[2].cx = select_search_num(1)->select->diagram_point.cad_point->cx;
				OnlyOneCAD[2].cy = select_search_num(1)->select->diagram_point.cad_point->cy;
				OnlyOneCAD[2].r = select_search_num(1)->select->diagram_point.cad_point->r - rtn.r[1];
			}
			else {
				/* --- [1] --- */
				OnlyOneCAD[1].code = 2;
				OnlyOneCAD[1].cx = select_search_num(1)->select->diagram_point.cad_point->cx;
				OnlyOneCAD[1].cy = select_search_num(1)->select->diagram_point.cad_point->cy;
				OnlyOneCAD[1].r = select_search_num(1)->select->diagram_point.cad_point->r + rtn.r[1];

				/* SA */
				LAH.sx[1] = select_search_num(1)->select->diagram_point.cad_point->cx;
				LAH.sy[1] = select_search_num(1)->select->diagram_point.cad_point->cy;
				LAH.ex[1] = select_search_num(1)->select->diagram_point.cad_point->sx;
				LAH.ey[1] = select_search_num(1)->select->diagram_point.cad_point->sy;
				la(&LAH);
				/* LAH.angle */
				PAPH.sx[1] = select_search_num(1)->select->diagram_point.cad_point->cx;
				PAPH.sy[1] = select_search_num(1)->select->diagram_point.cad_point->cy;
				PAPH.angle = LAH.angle;
				PAPH.l = select_search_num(1)->select->diagram_point.cad_point->r + rtn.r[1];
				pap(&PAPH);
				/* PAPH.ex[1] , PAPH.ey[1] */
				OnlyOneCAD[1].sx = PAPH.ex[1];
				OnlyOneCAD[1].sy = PAPH.ey[1];
				
				/* EA */
				LAH.sx[1] = select_search_num(1)->select->diagram_point.cad_point->cx;
				LAH.sy[1] = select_search_num(1)->select->diagram_point.cad_point->cy;
				LAH.ex[1] = select_search_num(1)->select->diagram_point.cad_point->ex;
				LAH.ey[1] = select_search_num(1)->select->diagram_point.cad_point->ey;
				la(&LAH);
				/* LAH.angle */
				PAPH.sx[1] = select_search_num(1)->select->diagram_point.cad_point->cx;
				PAPH.sy[1] = select_search_num(1)->select->diagram_point.cad_point->cy;
				PAPH.angle = LAH.angle;
				PAPH.l = select_search_num(1)->select->diagram_point.cad_point->r + rtn.r[1];
				pap(&PAPH);
				/* PAPH.ex[1] , PAPH.ey[1] */
				OnlyOneCAD[1].ex = PAPH.ex[1];
				OnlyOneCAD[1].ey = PAPH.ey[1];
				
				
				/* --- [2] --- */
				OnlyOneCAD[2].code = 2;
				OnlyOneCAD[2].cx = select_search_num(1)->select->diagram_point.cad_point->cx;
				OnlyOneCAD[2].cy = select_search_num(1)->select->diagram_point.cad_point->cy;
				OnlyOneCAD[2].r = select_search_num(1)->select->diagram_point.cad_point->r - rtn.r[1];

				/* SA */
				LAH.sx[1] = select_search_num(1)->select->diagram_point.cad_point->cx;
				LAH.sy[1] = select_search_num(1)->select->diagram_point.cad_point->cy;
				LAH.ex[1] = select_search_num(1)->select->diagram_point.cad_point->sx;
				LAH.ey[1] = select_search_num(1)->select->diagram_point.cad_point->sy;
				la(&LAH);
				/* LAH.angle */
				PAPH.sx[1] = select_search_num(1)->select->diagram_point.cad_point->cx;
				PAPH.sy[1] = select_search_num(1)->select->diagram_point.cad_point->cy;
				PAPH.angle = LAH.angle;
				PAPH.l = select_search_num(1)->select->diagram_point.cad_point->r - rtn.r[1];
				pap(&PAPH);
				/* PAPH.ex[1] , PAPH.ey[1] */
				OnlyOneCAD[2].sx = PAPH.ex[1];
				OnlyOneCAD[2].sy = PAPH.ey[1];
				
				/* EA */
				LAH.sx[1] = select_search_num(1)->select->diagram_point.cad_point->cx;
				LAH.sy[1] = select_search_num(1)->select->diagram_point.cad_point->cy;
				LAH.ex[1] = select_search_num(1)->select->diagram_point.cad_point->ex;
				LAH.ey[1] = select_search_num(1)->select->diagram_point.cad_point->ey;
				la(&LAH);
				/* LAH.angle */
				PAPH.sx[1] = select_search_num(1)->select->diagram_point.cad_point->cx;
				PAPH.sy[1] = select_search_num(1)->select->diagram_point.cad_point->cy;
				PAPH.angle = LAH.angle;
				PAPH.l = select_search_num(1)->select->diagram_point.cad_point->r - rtn.r[1];
				pap(&PAPH);
				/* PAPH.ex[1] , PAPH.ey[1] */
				OnlyOneCAD[2].ex = PAPH.ex[1];
				OnlyOneCAD[2].ey = PAPH.ey[1];
			}
			/* 円選択 */
			OnlyOneIndex = 1;
			OnlyOneEntry = 2;
			OnlyOneKeepReturnFunc = ReturnFunc;
			ReturnFunc = MouseRet_OnlyOne;
			(*ReturnFunc)(drawing_area, 1, 0, 0);
			OnlyOne_mode = 210;
			OnlyOne(3);
			return 1;
		}


		/* 大きい方しかないとき */
		else if (select_search_num(1)->select->diagram_point.cad_point->r <= rtn.r[1]) {
			/* 円データを登録 */
			if(select_search_num(1)->select->diagram_point.cad_point->code == 4) {
				/* 円データを登録 */
				cad.code = 4;
				cad.layer = NowLayer;
				cad.style = NowStyle;
				cad.color = NowColor;
				cad.sx = 0;
				cad.sy = 0;
				cad.ex = 0;
				cad.ey = 0;
				cad.cx = select_search_num(1)->select->diagram_point.cad_point->cx;
				cad.cy = select_search_num(1)->select->diagram_point.cad_point->cy;
				cad.r  = select_search_num(1)->select->diagram_point.cad_point->r + rtn.r[1];
				cad.OnScreen = 0;
				undo_index_plus();
				cad_list_add_first_with_undo(&cad, &cad_list_info);
				SelectCadDraw(drawing_area, &cad, SCD_ORG);
			}

			/* 円弧データを登録 */
			else if(select_search_num(1)->select->diagram_point.cad_point->code == 2) {
				/* SA */
				LAH.sx[1] = select_search_num(1)->select->diagram_point.cad_point->cx;
				LAH.sy[1] = select_search_num(1)->select->diagram_point.cad_point->cy;
				LAH.ex[1] = select_search_num(1)->select->diagram_point.cad_point->sx;
				LAH.ey[1] = select_search_num(1)->select->diagram_point.cad_point->sy;
				la(&LAH);
				/* LAH.angle */
				PAPH.sx[1] = select_search_num(1)->select->diagram_point.cad_point->cx;
				PAPH.sy[1] = select_search_num(1)->select->diagram_point.cad_point->cy;
				PAPH.angle = LAH.angle;
				PAPH.l = select_search_num(1)->select->diagram_point.cad_point->r + rtn.r[1];
				pap(&PAPH);
				/* PAPH.ex[1] , PAPH.ey[1] */
				sx = PAPH.ex[1];
				sy = PAPH.ey[1];
				
				/* EA */
				LAH.sx[1] = select_search_num(1)->select->diagram_point.cad_point->cx;
				LAH.sy[1] = select_search_num(1)->select->diagram_point.cad_point->cy;
				LAH.ex[1] = select_search_num(1)->select->diagram_point.cad_point->ex;
				LAH.ey[1] = select_search_num(1)->select->diagram_point.cad_point->ey;
				la(&LAH);
				/* LAH.angle */
				PAPH.sx[1] = select_search_num(1)->select->diagram_point.cad_point->cx;
				PAPH.sy[1] = select_search_num(1)->select->diagram_point.cad_point->cy;
				PAPH.angle = LAH.angle;
				PAPH.l = select_search_num(1)->select->diagram_point.cad_point->r + rtn.r[1];
				pap(&PAPH);
				/* PAPH.ex[1] , PAPH.ey[1] */
				ex = PAPH.ex[1];
				ey = PAPH.ey[1];

				/* 円データを登録 */
				cad.code = 4;
				cad.layer = NowLayer;
				cad.style = NowStyle;
				cad.color = NowColor;
				cad.sx = sx;
				cad.sy = sy;
				cad.ex = ex;
				cad.ey = ey;
				cad.cx = select_search_num(1)->select->diagram_point.cad_point->cx;
				cad.cy = select_search_num(1)->select->diagram_point.cad_point->cy;
				cad.r  = select_search_num(1)->select->diagram_point.cad_point->r + rtn.r[1];
				cad.OnScreen = 0;
				undo_index_plus();
				cad_list_add_first_with_undo(&cad, &cad_list_info);
				SelectCadDraw(drawing_area, &cad, SCD_ORG);
			}
			return 1;
		}
	}
	/* 円データを登録 */
	cad.code = 4;
	cad.layer = NowLayer;
	cad.style = NowStyle;
	cad.color = NowColor;
	cad.sx = 0;
	cad.sy = 0;
	cad.ex = 0;
	cad.ey = 0;
	cad.cx = select_search_num(1)->select->diagram_point.cad_point->cx;
	cad.cy = select_search_num(1)->select->diagram_point.cad_point->cy;
	cad.r  = rtn.r[1];
	cad.OnScreen = 0;
	undo_index_plus();
	cad_list_add_first_with_undo(&cad, &cad_list_info);
	SelectCadDraw(drawing_area, &cad, SCD_ORG);

	return 1;
}



/* ---------------------------------------------------------------------
 * 円と円で円   cc_c   ２円が違う   ２円に接する円
 * 
 */
int cc_c(void)
{
	int Ret;
	struct RtnDat rtn;
	CAD cad;
	char str[256];
	int i;


	if (sg(select_search_num(1)->select->diagram_point.cad_point->cx, 6) == sg(select_search_num(2)->select->diagram_point.cad_point->cx, 6)
		&& sg(select_search_num(1)->select->diagram_point.cad_point->cy, 6) == sg(select_search_num(2)->select->diagram_point.cad_point->cy, 6)) 
	{
		MsgBox("SagCAD", "Error !", "In spite of being different data, center of circle is the same." , NULL, NULL, "OK");
		return 0;
	}

	/* CCC		２円に接する円 */
	/* 数値入力ダイアログボックス表示 */
	strcpy(str, "");
	Ret = CulcInputBox(MainWindow, 
					   _("Circle which touches 2 circle") , 
					   _("Input a radius.") , 
					   "", 
					   str);
	if (Ret == -1) return 0;
	rtn.r[3] = atof(str);

	rtn.cx[1] = select_search_num(1)->select->diagram_point.cad_point->cx;
	rtn.cy[1] = select_search_num(1)->select->diagram_point.cad_point->cy;
	rtn.r[1] = select_search_num(1)->select->diagram_point.cad_point->r;
	rtn.cx[2] = select_search_num(2)->select->diagram_point.cad_point->cx;
	rtn.cy[2] = select_search_num(2)->select->diagram_point.cad_point->cy;
	rtn.r[2] = select_search_num(2)->select->diagram_point.cad_point->r;
	ccc(&rtn);
	
	if (rtn.type > 1) {
		i = 1;
		while (i <= rtn.type) {
			OnlyOneCAD[i].code	= 4;
			OnlyOneCAD[i].cx	= sg(rtn.cx[i + 2], 6);
			OnlyOneCAD[i].cy	= sg(rtn.cy[i + 2], 6);
			OnlyOneCAD[i].r		= sg(rtn.r[i + 2], 6);
			i++;
		}
		
		/* 円選択 */
		OnlyOneIndex = 1;
		OnlyOneEntry = rtn.type;
		OnlyOneKeepReturnFunc = ReturnFunc;
		ReturnFunc = MouseRet_OnlyOne;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		OnlyOne_mode = 210;
		OnlyOne(3);
		return 1;
	}
	else if (rtn.type == 1) {
		/* 円データを登録 */
		cad.code = 4;
		cad.layer = NowLayer;
		cad.style = NowStyle;
		cad.color = NowColor;
		cad.sx = 0;
		cad.sy = 0;
		cad.ex = 0;
		cad.ey = 0;
		cad.cx = rtn.cx[3];
		cad.cy = rtn.cy[3];
		cad.r  = rtn.r[3];
		cad.OnScreen = 0;
		undo_index_plus();
		cad_list_add_first_with_undo(&cad, &cad_list_info);
		SelectCadDraw(drawing_area, &cad, SCD_ORG);

		return 1;
	}
	else if (rtn.type == 0) {
		MsgBox("SagCAD", "Error !", _("It thinks that radius R is different.") , NULL, NULL, "OK");
		return 0;
	}

	return 0;
}



/* ---------------------------------------------------------------------
 * 円コマンドを選択したとき
 * 
 */
int CreateCircle(GtkWidget *widget)
{
	SELECT *sel_1, *sel_2, *sel;


	sel_1 = select_search_num(1)->select;
	sel_2 = select_search_num(2)->select;


	/* 点,線,円弧,円のみのとき */
	if (sel_1->index == 2 
		&& 
		sel_2->index == 2 ) 
	{

		/* 点と点で円 */
		if (sel_1->diagram_point.cad_point->code == 0 
			&& 
			sel_2->diagram_point.cad_point->code == 0
			) 
		{
			/* ２点が同一   p_c   点を中心とする半径Ｒの円 */
			if (	(
					sel_1->diagram_point.cad_point->sx 
						== sel_2->diagram_point.cad_point->sx
					) 
					&& 
					(
					sel_1->diagram_point.cad_point->sy 
						== sel_2->diagram_point.cad_point->sy
					) 
				) 
			{
				p_c();
				return 1;
			}
			/* ２点が違う   pp_c   ２点を通る半径Ｒの円 */
			else {
				pp_c();
				return 1;
			}
		}


		/* 点と線で円   pl_c   １点を通り、直線に接する半径Ｒの円 */
		else if (	(
					sel_1->diagram_point.cad_point->code == 0 
					&& 
					sel_2->diagram_point.cad_point->code == 1
					)
					|| 
					(
					sel_1->diagram_point.cad_point->code == 1 
					&& 
					sel_2->diagram_point.cad_point->code == 0
					) 
				) 
		{
			pl_c();
			return 1;
		}


		/* 点と円で円   pc_c   １点を通り、円に接する円 */
		else if (	(
						(
						sel_1->diagram_point.cad_point->code == 0 
						&& 
						sel_2->diagram_point.cad_point->code == 2
						) 
						|| 
						(
						sel_1->diagram_point.cad_point->code == 0 
						&& 
						sel_2->diagram_point.cad_point->code == 4
						)
					)
					|| 
					(
						(
						sel_1->diagram_point.cad_point->code == 2 
						&& 
						sel_2->diagram_point.cad_point->code == 0
						) 
						|| 
						(
						sel_1->diagram_point.cad_point->code == 4 
						&& 
						sel_2->diagram_point.cad_point->code == 0
						)
					) 
				) 
		{
			pc_c();
			return 1;
		}


		/* 線と線で円 */
		else if (sel_1->diagram_point.cad_point->code == 1 
				 && sel_2->diagram_point.cad_point->code == 1
				 ) 
		{
			/* ２線が同一   無し */
			if (sel_1->diagram_point.cad_point == sel_2->diagram_point.cad_point) {
				return 0;
			}
			/* ２線が違う   ll_c   ２直線に接する半径Ｒの円 */
			if (sel_1->diagram_point.cad_point != sel_2->diagram_point.cad_point) {
				ll_c();
				return 1;
			}
		}


		/* 線と円で円   lc_c   直線と円に接する半径Ｒの円 */
		else if (
					(
						(
						sel_1->diagram_point.cad_point->code == 1 
						&& 
						sel_2->diagram_point.cad_point->code == 2
						) 
						|| 
						(
						sel_1->diagram_point.cad_point->code == 1 
						&& 
						sel_2->diagram_point.cad_point->code == 4
						)
					)
					|| 
					(
						(
						sel_1->diagram_point.cad_point->code == 2 
						&& 
						sel_2->diagram_point.cad_point->code == 1
						) 
						|| 
						(
						sel_1->diagram_point.cad_point->code == 4 
						&& 
						sel_2->diagram_point.cad_point->code == 1
						)
					) 
				) 
		{
			lc_c();
			return 1;
		}


		/* 円と円で円 */
		else if (
					(
					sel_1->diagram_point.cad_point->code == 2 
					&& 
					sel_2->diagram_point.cad_point->code == 4
					)
					|| 
					(
					sel_1->diagram_point.cad_point->code == 4 
					&& 
					sel_2->diagram_point.cad_point->code == 2
					)
					|| 
					(
					sel_1->diagram_point.cad_point->code == 2 
					&& 
					sel_2->diagram_point.cad_point->code == 2
					)
					|| 
					(
					sel_1->diagram_point.cad_point->code == 4 
					&& 
					sel_2->diagram_point.cad_point->code == 4
					)
				)
		{
			/* ２円が同一   c_c   同心円 */
			if (sg(sel_1->diagram_point.cad_point->cx, 6) 
					== sg(sel_2->diagram_point.cad_point->cx, 6)
				&& 
				sg(sel_1->diagram_point.cad_point->cy, 6) 
					== sg(sel_2->diagram_point.cad_point->cy, 6)
				)
			{
				if (sg(sel_1->diagram_point.cad_point->r, 6) 
						== sg(sel_2->diagram_point.cad_point->r, 6)) 
				{
					c_c();
					return 1;
				}
				else {
					MsgBox("SagCAD", 
						   _("It is concentric circle but it isn't possible to do "), 
						   _("the specification of offset (-) because R is different."), 
						   NULL, NULL, "OK");
					return 0;
				}
			}
			/* ２円が違う   cc_c   ２円に接する円 */
			else {
				cc_c();
				return 1;
			}
		}
	}



	/* 楕円があるとき */
	else if (sel_1->index == 16 
			|| 
			sel_2->index == 16 ) 
	{
		/* sel_1 が楕円となるようにする */
		if (sel_1->index == 2) {
			sel = sel_1;
			sel_1 = sel_2;
			sel_2 = sel;
		}


		/* 楕円と点 */
		if (sel_2->index == 2) {
			if (sel_2->diagram_point.cad_point->code == 0) {
				
				
				
			}
		}


		/* 楕円と線 */
		if (sel_2->index == 2) {
			if (sel_2->diagram_point.cad_point->code == 1) {
				
				
				
			}
		}


		/* 楕円と円(円弧) */
		if (sel_2->index == 2) {
			if (sel_2->diagram_point.cad_point->code == 2 || sel_2->diagram_point.cad_point->code == 4) {
				
				
				
			}
		}


		/* 楕円と楕円 */
		if (sel_2->index == 16) {
			
			
			
		}


	}



	return 0;
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : sagcad
 *    Source               : DrawMode.c
 * ====================================================================
 */
