/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : EllipseSetDlg.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/04/19
 *    Last                 : 2007/10/24
 * ====================================================================
 */
#ifndef __ELLIPSESETDLG_H__
#define __ELLIPSESETDLG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */

struct _ELLIPSE_SET_DLG
{
	gint value;		/* OK:1   CANCEL:0 */

	gdouble cx;		/* 中心Ｘ */
	gdouble cy;		/* 中心Ｙ */
	gdouble long_r;	/* 長軸の半径 */
	gdouble k;		/* 短軸の％ */
	gdouble angle;	/* 傾き */
	gdouble sa;		/* 開始角 */
	gdouble ea;		/* 終了角 */

	GtkWidget *cx_entry;
	GtkWidget *cy_entry;
	GtkWidget *long_r_entry;
	GtkWidget *k_entry;
	GtkWidget *angle_entry;
	GtkWidget *sa_entry;
	GtkWidget *ea_entry;

	GtkWidget *parent;
	GtkWidget *dialog;
};
typedef struct _ELLIPSE_SET_DLG ELLIPSE_SET_DLG;








/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _ELLIPSESETDLG_
#define   GLOBAL
/* 初期値設定 */
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
/* 初期値設定の代入部分を無くす */
#define   GLOBAL_VAL(v)  /* */
#endif




#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _ELLIPSESETDLG_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */

/* 楕円作成 */
gint EllipseSetDialog(ELLIPSE_SET_DLG *ellipse_set_dlg);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __ELLIPSESETDLG_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : EllipseSetDlg.h
 * ====================================================================
 */
