/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : EnvSetDlg.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/03/01
 *    Last                 : 2007/10/24
 * ====================================================================
 */

#ifndef __ENVSETDLG_H__
#define __ENVSETDLG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */

struct _ENVSET_DLG
{
	int Value;	// -1:CANCEL  0:OK
	
	/* User */
	char user_name[40];
	char user_company[40];
	GtkWidget *entry_user_name;
	GtkWidget *entry_user_company;

	/* Folder */
	char KeepCadPath[256];
	char NcPath[256];
	char BrowserPath[256];
	GtkWidget *entry_cad_path;
	GtkWidget *entry_nc_path;
	GtkWidget *entry_browser_path;

	/* Command */
	char print_command[256];
	char editor_command[256];
	char browser_command[256];
	GtkWidget *entry_p_command;
	GtkWidget *entry_e_command;
	GtkWidget *entry_b_command;

	/* System */
	int system_WinMode;	/* 0:WM にまかせる   1:設定値   2:前回終了時の設定 */
	int system_win_x_pos;
	int system_win_y_pos;
	int system_win_width;
	int system_win_height;
	float system_Search;
	float system_Wait;
//	float system_MaxLayer;
	float system_Splits;
	float system_ZoomMag;
	float system_ViewX;
	float system_FilletRC;
	float system_Length;
	GtkWidget *entry_system_WinMode;	/* 0:WM にまかせる   1:設定値   2:前回終了時の設定 */
	GtkWidget *entry_system_win_x_pos;
	GtkWidget *entry_system_win_y_pos;
	GtkWidget *entry_system_win_width;
	GtkWidget *entry_system_win_height;
	GtkWidget *entry_system_Search;
	GtkWidget *entry_system_Wait;
//	GtkWidget *entry_system_MaxLayer;
	GtkWidget *entry_system_Splits;
	GtkWidget *entry_system_ZoomMag;
	GtkWidget *entry_system_ViewX;
	GtkWidget *entry_system_FilletRC;
	GtkWidget *entry_system_Length;
	/* Dimension */
	float dimension_FontHeight;
	float dimension_FontLetterSpace;
	float dimension_FontWordSpace;
	float dimension_FontOverLineLength;
	char dimension_Font1[256];
	char dimension_Font2[256];
	float dimension_DimensionArrowLength;
	float dimension_DimensionArrowAngle;
	float dimension_DimensionOverArrowLength;
	float dimension_DimensionOverLength;
	float dimension_DimensionUnderLength;
	GtkWidget *entry_dimension_FontHeight;
	GtkWidget *entry_dimension_FontLetterSpace;
	GtkWidget *entry_dimension_FontWordSpace;
	GtkWidget *entry_dimension_FontOverLineLength;
	GtkWidget *entry_dimension_Font1;
	GtkWidget *entry_dimension_Font2;
	GtkWidget *entry_dimension_DimensionArrowLength;
	GtkWidget *entry_dimension_DimensionArrowAngle;
	GtkWidget *entry_dimension_DimensionOverArrowLength;
	GtkWidget *entry_dimension_DimensionOverLength;
	GtkWidget *entry_dimension_DimensionUnderLength;
	/* SystemColor */
	long BackColor;
	long SelectColor;
	long DimensionColor;
	long CamColor;
	long PrinterRectColor;
	long FirstCenterLine;
	GtkWidget *entry_system_color_BackColor;
	GtkWidget *entry_system_color_SelectColor;
	GtkWidget *entry_system_color_DimensionColor;
	GtkWidget *entry_system_color_CamColor;
	GtkWidget *entry_system_color_PrinterRectColor;
	GtkWidget *entry_system_color_FirstCenterLine;
	/* Color */
	long color_name[25];
	GtkWidget *entry_color_name[25];
	/* Style */
	int style_max[7];
	int style_min[7];
	int style_DisplayWidth[7];
	int style_PrinterWidth[7];
	GtkWidget *entry_style_max[7];
	GtkWidget *entry_style_min[7];
	GtkWidget *entry_style_DisplayWidth[7];
	GtkWidget *entry_style_PrinterWidth[7];



	GtkWidget *parent;
	GtkWidget *dialog;
};
typedef struct _ENVSET_DLG ENVSET_DLG;



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _ENVSETDLG_
#define   GLOBAL
/* 初期値設定 */
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
/* 初期値設定の代入部分を無くす */
#define   GLOBAL_VAL(v)  /* */
#endif




#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _ENVSETDLG_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */

gint EnvSetDialog(ENVSET_DLG *envset_dlg);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __ENVSETDLG_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : EnvSetDlg.h
 * ====================================================================
 */
