/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : GridCopyDlg.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/02/20
 *    Last                 : 2007/10/11
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

#include "culcfunc.h"
#define _GRIDCOPYDLG_
#include "GridCopyDlg.h"





static gint gridcopy_dlg_delete_event(GtkWidget *widget, GdkEventAny *event, gpointer data)
{
	return TRUE;
}

static gint gridcopy_dlg_focus_out(GtkWidget *widget, GdkEventFocus *event, gpointer data)
{
#ifdef G_OS_WIN32
	gtk_window_present(GTK_WINDOW(widget));
#endif
	return FALSE;
}

/* -------------------------------------------------------------------
 * CANCEL
 */
void gridcopy_dlg_cancel_pushed(GtkWidget *widget, GRIDCOPY_DLG *gridcopy_dlg)
{
	gridcopy_dlg->value = -1;
	gridcopy_dlg->x_pitch = 0;
	gridcopy_dlg->y_pitch = 0;
	gridcopy_dlg->x_repeats = 0;
	gridcopy_dlg->y_repeats = 0;
}



/* -------------------------------------------------------------------
 * OK
 */
void gridcopy_dlg_ok_pushed(GtkWidget *widget, GRIDCOPY_DLG *gridcopy_dlg)
{
	char str[256];


	/* テキストエントリーから文字列を取得 */
	if (gridcopy_dlg->x_pitch_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(gridcopy_dlg->x_pitch_entry)));
		gridcopy_dlg->x_pitch = atof(str);
	}

	if (gridcopy_dlg->y_pitch_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(gridcopy_dlg->y_pitch_entry)));
		gridcopy_dlg->y_pitch = atof(str);
	}

	if (gridcopy_dlg->x_repeats_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(gridcopy_dlg->x_repeats_entry)));
		gridcopy_dlg->x_repeats = atoi(str);
	}

	if (gridcopy_dlg->y_repeats_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(gridcopy_dlg->y_repeats_entry)));
		gridcopy_dlg->y_repeats = atoi(str);
	}
	gridcopy_dlg->value = 0;

}



/* -------------------------------------------------------------------
 * キーが押されたイベント
 * key_press_event
 */
static gint gridcopy_dlg_key_press_event(GtkWidget *widget, GdkEventKey *event, GRIDCOPY_DLG *gridcopy_dlg)
{
//	g_print("sagcad.c : gridcopy_dlg_key_press_event  state:%d  keyval:0x%x  length:%d  string:%s\n", 
//			event->state, event->keyval, event->length, event->string);


	if (event->keyval == 0xff0d || event->keyval == 0xff8d) {		/* Enter */
		/* フォーカス x_pitch_entry で Enter ならフォーカスを y_pitch_entry に移す */
		if (GTK_WIDGET( gridcopy_dlg->x_pitch_entry) == GTK_WINDOW(gridcopy_dlg->dialog)->focus_widget) {
			gtk_window_set_focus(GTK_WINDOW(gridcopy_dlg->dialog), 
						gridcopy_dlg->y_pitch_entry);
			gtk_editable_select_region( GTK_EDITABLE(gridcopy_dlg->y_pitch_entry), 
						0, GTK_ENTRY(gridcopy_dlg->y_pitch_entry)->text_length);
		}
		/* フォーカス y_pitch_entry で Enter ならフォーカスを x_repeats_entry に移す */
		else if (GTK_WIDGET(gridcopy_dlg->y_pitch_entry) == GTK_WINDOW(gridcopy_dlg->dialog)->focus_widget) {
			gtk_window_set_focus(GTK_WINDOW(gridcopy_dlg->dialog), gridcopy_dlg->x_repeats_entry);
			gtk_editable_select_region( GTK_EDITABLE(gridcopy_dlg->x_repeats_entry), 0, 
									 GTK_ENTRY(gridcopy_dlg->x_repeats_entry)->text_length);
		}
		/* フォーカス x_repeats_entry で Enter ならフォーカスを y_repeats_entry に移す */
		else if (GTK_WIDGET(gridcopy_dlg->x_repeats_entry) == GTK_WINDOW(gridcopy_dlg->dialog)->focus_widget) {
			gtk_window_set_focus(GTK_WINDOW(gridcopy_dlg->dialog), gridcopy_dlg->y_repeats_entry);
			gtk_editable_select_region( GTK_EDITABLE(gridcopy_dlg->y_repeats_entry), 0, 
									 GTK_ENTRY(gridcopy_dlg->y_repeats_entry)->text_length);
		}
		/* フォーカス y_repeats_entry で Enter なら終わり */
		else if (GTK_WIDGET(gridcopy_dlg->y_repeats_entry) == GTK_WINDOW(gridcopy_dlg->dialog)->focus_widget) {
			gridcopy_dlg_ok_pushed(widget, gridcopy_dlg);
			gtk_main_quit();
		}
	}
	return FALSE; 
}



/* -------------------------------------------------------------------
 * コピー【移動/複写】設定
 * 
 */
gint GridCopyDialog(GRIDCOPY_DLG *gridcopy_dlg)
{
	char str[256];

//	GtkWidget *dialog;
	GtkWidget *main_vbox;
		GtkWidget *hbox;
			GtkWidget *label_vbox;
				GtkWidget *null_label;
				GtkWidget *pitch_label;
				GtkWidget *repeats_label;
			GtkWidget *x_entry_vbox;
				GtkWidget *x_label;
//				GtkWidget *x_pitch_entry;
//				GtkWidget *x_repeats_entry;
			GtkWidget *y_entry_vbox;
				GtkWidget *y_label;
//				GtkWidget *y_pitch_entry;
//				GtkWidget *y_repeats_entry;
		GtkWidget *separator;
		GtkWidget *action_hbox;
			GtkWidget *cancel_buttun;
			GtkWidget *ok_buttun;

//g_print("GridCopyDialog() : start !\n");

	/* ダイアログ(gridcopy_dlg->dialog)生成 */
	gridcopy_dlg->dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position(GTK_WINDOW(gridcopy_dlg->dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(gridcopy_dlg->dialog),  _("Procession Copy Setting") );
	/* ダイアログを最前面に表示する */
	gtk_window_set_modal(GTK_WINDOW(gridcopy_dlg->dialog), TRUE);
	/* メインウィンドウを操作できないように設定 */
	gtk_window_set_transient_for(GTK_WINDOW(gridcopy_dlg->dialog), GTK_WINDOW(gridcopy_dlg->parent));
	g_signal_connect(G_OBJECT(gridcopy_dlg->dialog), "delete_event",
			 G_CALLBACK(gridcopy_dlg_delete_event), gridcopy_dlg);
	g_signal_connect( G_OBJECT(gridcopy_dlg->dialog), "key_press_event",
						G_CALLBACK(gridcopy_dlg_key_press_event), gridcopy_dlg);
	g_signal_connect(G_OBJECT(gridcopy_dlg->dialog), "focus_out_event",
			 G_CALLBACK(gridcopy_dlg_focus_out), NULL);

	/* ダイアログの中にまず、パッキングボックス(main_vbox)を作成 */
	main_vbox = gtk_vbox_new(0, 5);
	gtk_container_add(GTK_CONTAINER(gridcopy_dlg->dialog), main_vbox);
	gtk_container_set_border_width(GTK_CONTAINER(gridcopy_dlg->dialog), 5);
	gtk_widget_show(main_vbox);

	/* -----------------------------------------------------
	 * パッキングボックス(main_vbox) に入れる
	 * パッキングボックス(hbox & action_hbox) を作成し
	 * 格納する
	 */
	/* パッキングボックス(hbox) */
	hbox = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), hbox, TRUE, TRUE, 0);
	gtk_widget_show(hbox);

	/* セパレーター(separator) */
	separator = gtk_hseparator_new();
	gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
	gtk_widget_show(separator);

	/* パッキングボックス(action_hbox) */
	action_hbox = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start( GTK_BOX(main_vbox), action_hbox, TRUE, TRUE, 0);
	gtk_widget_show(action_hbox);

		/* -----------------------------------------------------
		 * パッキングボックス(hbox) に入れる
		 * パッキングボックス(label_vbox & entry_vbox) を作成し
		 * 格納する
		 */
		/* パッキングボックス(label_vbox) */
		label_vbox = gtk_vbox_new(FALSE, 2);
		gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), label_vbox, TRUE, TRUE, 0);
		gtk_widget_show(label_vbox);

		/* パッキングボックス(x_entry_vbox) */
		x_entry_vbox = gtk_vbox_new(FALSE, 2);
		gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), x_entry_vbox, TRUE, TRUE, 0);
		gtk_widget_show(x_entry_vbox);

		/* パッキングボックス(y_entry_vbox) */
		y_entry_vbox = gtk_vbox_new(FALSE, 2);
		gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), y_entry_vbox, TRUE, TRUE, 0);
		gtk_widget_show(y_entry_vbox);

			/* -----------------------------------------------------
			 * パッキングボックス(label_vbox) に入れる
			 * ラベル(x_pitch_label & y_pitch_label & repeats_label) を作成し
			 * 格納する
			 */
			null_label = gtk_label_new("");
			gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), null_label, TRUE, TRUE, 0);
			gtk_widget_show(null_label);

			pitch_label = gtk_label_new( _("Pitch") );
			gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), pitch_label, TRUE, TRUE, 0);
			gtk_widget_show(pitch_label);

			repeats_label = gtk_label_new( _("Number of times") );
			gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), repeats_label, TRUE, TRUE, 0);
			gtk_widget_show(repeats_label);


			/* -----------------------------------------------------
			 * パッキングボックス(x_entry_vbox) に入れる
			 * ウィジェット(x_label & gridcopy_dlg->x_pitch_entry & gridcopy_dlg->x_repeats_entry) を作成し
			 * 格納する
			 */
			/* ラベル */
			x_label = gtk_label_new( _("X") );
			gtk_box_pack_start((GtkBox *)GTK_BOX(x_entry_vbox), x_label, TRUE, TRUE, 0);
			gtk_widget_show(x_label);

			/* テキストエントリー生成 */
			gridcopy_dlg->x_pitch_entry = gtk_entry_new();
			gtk_box_pack_start((GtkBox *)GTK_BOX(x_entry_vbox), gridcopy_dlg->x_pitch_entry, TRUE, TRUE, 1);
			/* 初期値設定 */
			FloatOut_n(str, gridcopy_dlg->x_pitch, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(gridcopy_dlg->x_pitch_entry), str);
			//g_signal_connect (G_OBJECT(entry), "activate", G_CALLBACK(entry_callback), NULL);
			gtk_widget_show(gridcopy_dlg->x_pitch_entry);


			/* テキストエントリー生成 */
			gridcopy_dlg->x_repeats_entry = gtk_entry_new();
			gtk_box_pack_start((GtkBox *)GTK_BOX(x_entry_vbox), gridcopy_dlg->x_repeats_entry, TRUE, TRUE, 1);
			/* 初期値設定 */
			sprintf(str, "%d", gridcopy_dlg->x_repeats);
			gtk_entry_set_text(GTK_ENTRY(gridcopy_dlg->x_repeats_entry), str);
			gtk_widget_show(gridcopy_dlg->x_repeats_entry);



			/* -----------------------------------------------------
			 * パッキングボックス(y_entry_vbox) に入れる
			 * ウィジェット(y_label & gridcopy_dlg->y_pitch_entry & gridcopy_dlg->y_repeats_entry) を作成し
			 * 格納する
			 */
			/* ラベル */
			y_label = gtk_label_new( _("Y") );
			gtk_box_pack_start((GtkBox *)GTK_BOX(y_entry_vbox), y_label, TRUE, TRUE, 0);
			gtk_widget_show(y_label);

			/* テキストエントリー生成 */
			gridcopy_dlg->y_pitch_entry = gtk_entry_new();
			gtk_box_pack_start((GtkBox *)GTK_BOX(y_entry_vbox), gridcopy_dlg->y_pitch_entry, TRUE, TRUE, 1);
			/* 初期値設定 */
			FloatOut_n(str, gridcopy_dlg->y_pitch, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(gridcopy_dlg->y_pitch_entry), str);
			gtk_widget_show(gridcopy_dlg->y_pitch_entry);


			/* テキストエントリー生成 */
			gridcopy_dlg->y_repeats_entry = gtk_entry_new();
			gtk_box_pack_start((GtkBox *)GTK_BOX(y_entry_vbox), gridcopy_dlg->y_repeats_entry, TRUE, TRUE, 1);
			/* 初期値設定 */
			sprintf(str, "%d", gridcopy_dlg->y_repeats);
			gtk_entry_set_text(GTK_ENTRY(gridcopy_dlg->y_repeats_entry), str);
			gtk_widget_show(gridcopy_dlg->y_repeats_entry);



		/* -----------------------------------------------------
		 * パッキングボックス(action_hbox) に入れる
		 * ボタン(cancel_buttun & ok_buttun) を作成し
		 * 格納する
		 */
		/* CANCELボタンの生成 */
		cancel_buttun = gtk_button_new_with_label("CANCEL");
		gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), cancel_buttun, TRUE, TRUE, 2);
		g_signal_connect( G_OBJECT(cancel_buttun), "clicked", G_CALLBACK(gridcopy_dlg_cancel_pushed), gridcopy_dlg);
		g_signal_connect( G_OBJECT(cancel_buttun), "clicked", G_CALLBACK(gtk_main_quit), NULL);
		gtk_widget_show(cancel_buttun);

		/* OKボタンの生成 */
		ok_buttun = gtk_button_new_with_label("OK");
		gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), ok_buttun, TRUE, TRUE, 2);
		g_signal_connect(G_OBJECT(ok_buttun), "clicked", G_CALLBACK(gridcopy_dlg_ok_pushed), gridcopy_dlg);
		g_signal_connect(G_OBJECT(ok_buttun), "clicked", G_CALLBACK(gtk_main_quit), NULL);
		gtk_widget_show(ok_buttun);


	/*  フォーカスを x_pitch_entry に設定 */
	gtk_window_set_focus(GTK_WINDOW(gridcopy_dlg->dialog), gridcopy_dlg->x_pitch_entry);
	//GTK_WINDOW(gridcopy_dlg->dialog)->focus_widget = GTK_WIDGET(gridcopy_dlg->x_pitch_entry);
	gtk_editable_select_region( GTK_EDITABLE(gridcopy_dlg->x_pitch_entry), 0, 
							 GTK_ENTRY(gridcopy_dlg->x_pitch_entry)->text_length);




	/* ダイアログを可視状態へ */
	gtk_widget_show(gridcopy_dlg->dialog);
	/* メインイベントループ */
	gtk_main();
	gtk_widget_destroy(gridcopy_dlg->dialog);
	return gridcopy_dlg->value; 
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : GridCopyDlg.c
 * ====================================================================
 */
