/* ====================================================================
 * ===  Copyright (C) 1998-2006 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_Dimension.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2006 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2006/05/25
 * ====================================================================
 */
#ifndef __LIST_DIMENSION_H__
#define __LIST_DIMENSION_H__

//#include <>
#include "types.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef    _LIST_DIMENSION_
#define   GLOBAL
// 
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// ʬ̵
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL DIMENSION_LIST *p_dimension_list;
	GLOBAL DIMENSION_LIST_INFO dimension_list_info;


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef  _LIST_DIMENSION_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */
int init_dimension(DIMENSION *dimension);
/*  */
DIMENSION_LIST *r_dimension_list_add_first(DIMENSION *add_dimension, DIMENSION_LIST_INFO *p_dimension_list_info);
/* DIMENSION Data ꥹȤκǽɲ */
DIMENSION_LIST *dimension_list_add_first(DIMENSION *add_dimension, DIMENSION_LIST_INFO *p_dimension_list_info);
/* DIMENSION Data ꥹȤκǽɲäơ Undo Baffer ˽ */
DIMENSION_LIST *dimension_list_add_first_with_undo(DIMENSION *add_dimension, DIMENSION_LIST_INFO *p_dimension_list_info);

/* DIMENSION Data ꥹȤκǸɲ */
DIMENSION_LIST *dimension_list_add_last(DIMENSION *add_dimension, DIMENSION_LIST_INFO *p_dimension_list_info);
/* DIMENSION Data ꥹȤκǸɲá Undo Baffer ˽ */
DIMENSION_LIST *dimension_list_add_last_with_undo(DIMENSION *add_dimension, DIMENSION_LIST_INFO *p_dimension_list_info);

/* DIMENSION Data κǽ (κǤϤʤ) */
int dimension_list_delete(DIMENSION_LIST *del_List, DIMENSION_LIST_INFO *p_dimension_list_info);
/* DIMENSION Data κǽ (κǤϤʤUndo Buffer ذܤ) */
int dimension_list_delete_Undo(DIMENSION_LIST *del_List, DIMENSION_LIST_INFO *p_dimension_list_info);

/* DIMENSION Data ѹ */
DIMENSION_LIST *dimension_list_edit(DIMENSION_LIST *point, DIMENSION *change_dimension, DIMENSION_LIST_INFO *p_dimension_list_info);
/* DIMENSION Data ѹ롢 Undo Baffer ˽ */
DIMENSION_LIST *dimension_list_edit_with_undo(DIMENSION_LIST *point, DIMENSION *change_dimension, DIMENSION_LIST_INFO *p_dimension_list_info);

/* ꥹȤĴ٤ */
long dimension_list_num(DIMENSION_LIST_INFO *p_dimension_list_info);
/* n ܤΥǡθ */
DIMENSION_LIST *dimension_search_num(long search_number, DIMENSION_LIST_INFO *p_dimension_list_info);
/* DIMENSION Υǡθ */
DIMENSION_LIST *dimension_search_dimension(DIMENSION *p_dimension, DIMENSION_LIST_INFO *p_dimension_list_info);
/* DIMENSION Υǡθ */
long dimension_search_dimension_to_num(DIMENSION *p_dimension, DIMENSION_LIST_INFO *p_dimension_list_info);

/* DIMENSION Data ꥹȤ */
int dimension_list_free(DIMENSION_LIST *del_List, DIMENSION_LIST_INFO *p_dimension_list_info);
/* ꥹȤ */
void dimension_list_all_free(DIMENSION_LIST_INFO *p_dimension_list_info);

/* DIMENSION ꥹȤɽ */
void dimension_list_print(DIMENSION_LIST_INFO *p_dimension_list_info);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LIST_DIMENSION_H__ */



/* ====================================================================
 * ===  Copyright (C) 1998-2006 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_Dimension.h
 * ====================================================================
 */
